PROGRAM QHead; {v1.00 - Free DOS utility: Get message headers from QWK files.}
{$M 5120,0,0}  {5k stack, no heap needed}
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I-} {disable I/O checking - trap errors by checking IOResult}

{===========================================================================}
                       (** Global declarations ... **)
{===========================================================================}

USES
  DOS, CRT, ArcType;

CONST
  cursorState : BYTE = 1;  {0..3}
  cursorData : ARRAY [0..3] OF CHAR = (#179, #47, #196, #92);

VAR
  qheader, qline : string[80];
  unqwk, unzip, unlha, unarj, unzoo : PATHSTR;

VAR
  confnumb : WORD;

{===========================================================================}
                (** Custom help & exit procedure ... **)
{===========================================================================}

VAR
  SavedExitProc: POINTER;

PROCEDURE cursorOn; FORWARD;

PROCEDURE CustomExit; FAR;
{---- Always exit through here ----}
CONST
  progdesc = 'QHead v1.00 - Free DOS utility: Extract message headers from QWK packets.';
  author   = 'May 12, 1995. Copyright (c) 1995 by David Daniel Anderson - Reign Ware.';
  usage    = 'Usage:    QHead <QWKpacket(s)> <conference>';
  example  = 'Example:  QHead c:\qwks\*.qwk cnf100.hdr';
  note     = 'Note: DOS wildcards may be used when specifying the QWKpackets.';

VAR
  message: STRING [79];
BEGIN
  ExitProc := SavedExitProc;
  cursorOn;
  IF (ExitCode > 0) THEN BEGIN
    WriteLn (progdesc);
    WriteLn (author);    WriteLn;
    WriteLn (usage);
    WriteLn (example);   WriteLn;
    WriteLn (note);      WriteLn;
  END;
  IF ErrorAddr <> NIL THEN
  BEGIN
    WriteLn ('An unanticipated error occurred, please contact DDA with the following data:');
    WriteLn ('Address = ', Seg (ErrorAddr^), ':', Ofs (ErrorAddr^));
    WriteLn ('Code    = ', ExitCode);
    ErrorAddr := NIL;
  END
  ELSE
    IF (ExitCode > 0) AND (ExitCode < 255) THEN BEGIN
      CASE ExitCode OF
        1 : message := 'No files found.  First parameter must be a valid file specification.';
        2 : message := 'The second parameter must contain a conference number.';
        5 : message := 'Not enough memory to extract MESSAGES.DAT - aborting!';
        6 : message := 'You cannot just specify a path, add "*.*" or "\*.*" for all files.';
        7 : message := 'File handling error.  Text file is most likely incomplete - or nonexistent.';
        ELSE  message := 'Unknown error.';
      END;
      WriteLn (#7, 'Error encountered (number ', ExitCode, '):'); WriteLn (message);
    END;
END;

{===========================================================================}
                      (** Supporting subroutines ... **)
{===========================================================================}

PROCEDURE iocheck (CONST iores : BYTE);
BEGIN
  IF iores <> 0 THEN Halt (7);
END;

PROCEDURE cursorOn; ASSEMBLER; ASM
  mov AH, 3; mov BH, 0; Int $10; AND CH, NOT $20; mov AH, 1; Int $10;
END;

PROCEDURE cursorOff; ASSEMBLER; ASM
  mov AH, 3; mov BH, 0; Int $10; OR CH, $20; mov AH, 1; Int $10;
END;

PROCEDURE updateCursor;
BEGIN
  cursorState := Succ (cursorState) AND 3;
  Write (cursorData [cursorState], ^H);
END;

FUNCTION leadingzero (CONST w: WORD): STRING;
VAR
  s : STRING;
BEGIN
  Str (w : 0, s);
  IF (Length (s) = 1) THEN
    s := '0' + s;
  leadingzero := s;
END;

FUNCTION RTrim (InStr: STRING): STRING;
BEGIN
  WHILE (Length (InStr) > 0) AND (InStr [Length (InStr) ] IN [#0, #9, #32]) DO
    Dec (InStr [0]);
  RTrim := InStr;
END;

FUNCTION LTrim (InStr: STRING): STRING;
BEGIN
  WHILE (Length (InStr) > 0) AND (InStr [1] IN [#0, #9, #32]) DO
    Delete (InStr, 1, 1);
  LTrim := InStr;
END;

FUNCTION Squeeze (ss: STRING): STRING;
VAR
  controlCHAR: CHAR;
BEGIN
  FOR controlCHAR := #0 TO #31 DO
    WHILE (Ord (ss [0]) > 0) AND (Pos (controlCHAR, ss) > 0) DO
      ss [Pos (controlCHAR, ss) ] := #32;
  ss := RTrim (LTrim (ss));
  Squeeze := ss
END;

FUNCTION fileexists (CONST filename: PATHSTR): BOOLEAN;
VAR
  Attr : WORD;
  f    : FILE;
BEGIN
  Assign (f, filename);
  GetFAttr (f, Attr);
  IF (DosError <> 0) OR ( (Attr AND Directory) = Directory) THEN
    fileexists := FALSE
  ELSE
    fileexists := TRUE;
END;

PROCEDURE EraseFile (CONST MSGFile : STRING);
VAR
  df : FILE;
BEGIN
  IF fileexists (MSGFile) THEN BEGIN
    Assign (df, MSGFile);
    Erase (df); iocheck (IOResult);
  END;
END;

{===========================================================================}
                       (** Primary subroutines ... **)
{===========================================================================}

PROCEDURE GetCFGvars;
VAR
  epath, cpath  : PATHSTR;
  {epath & cpath are fully qualified pathnames of .exe & .cfg files}
  edir: DIRSTR; ename: NAMESTR; eext: EXTSTR;
  config        : TEXT;
  configline,
  unCommand,
  unVarName     : STRING [100];
  equalPos      : BYTE;
BEGIN
  epath := (ParamStr (0));
  FSplit (FExpand (epath), edir, ename, eext); { break up path into components }
  cpath := edir + ename+ '.cfg';

  qheader := '';
  qline := '';
  unqwk := 'pkunzip -# -o';
  unzip := 'pkunzip -# -o';
  unlha := 'lha e';
  unarj := 'arj e';
  unzoo := 'zoo -extract';

  IF fileexists (cpath) THEN
  BEGIN
    Assign (config, cpath);
    Reset (config); iocheck (IOResult);
    REPEAT  { find vars }
      ReadLn (config, configline);
      equalPos := Pos ('=', configline);
      IF (Length (configline) > 10) THEN BEGIN
        unCommand := LTrim (RTrim (Copy (configline, equalPos + 1, Length (configline) - equalPos)));
        unVarName := Copy (configline, 1, 5);

        IF (unVarName = 'unqwk') THEN
          unqwk := unCommand
        ELSE IF (unVarName = 'unzip') THEN
          unzip := unCommand
        ELSE IF (unVarName = 'unlha') THEN
          unlha := unCommand
        ELSE IF (unVarName = 'unarj') THEN
          unarj := unCommand
        ELSE IF (unVarName = 'unzoo') THEN
          unzoo := unCommand
        ELSE IF (unVarName = 'qhead') THEN
          qheader := unCommand
        ELSE IF (unVarName = 'qline') THEN
          qline := unCommand

      END;
    UNTIL EoF (config); { loop back to read another line }
    Close (config);
  END;
END;
{===========================================================================}

FUNCTION GetQWKdir (CONST PSTR: STRING; VAR QP: PATHSTR): DIRSTR;
VAR
  QWKpath   : PATHSTR;    { QWK file path,          }
  QWKdir    : DIRSTR;     {             directory,  }
  QWKname   : NAMESTR;    {             name,       }
  QWKext    : EXTSTR;     {             extension.  }
BEGIN
  QWKpath := PSTR;
  IF QWKpath [1] IN ['/', '-'] THEN Halt (255);
  FSplit (FExpand (QWKpath), QWKdir, QWKname, QWKext);
  IF (QWKname = '')  THEN Halt (6);
  QP := QWKpath;
  GetQWKdir := QWKdir;
END;

FUNCTION ExtractDAT (CONST QWKfile, DATfileName : STRING): BOOLEAN;
VAR
  X, Y : BYTE;
  extract : STRING [80];
BEGIN
  extract := unqwk;

  X := WhereX;
  Y := WhereY;
  CASE GetArcType (QWKfile) OF
    ZIP     : BEGIN Write (' assuming ZIP,'); extract := unzip; END;
    LZH     : BEGIN Write (' assuming LZH,'); extract := unlha; END;
    ARJ     : BEGIN Write (' assuming ARJ,'); extract := unarj; END;
    ZOO     : BEGIN Write (' assuming ZOO,'); extract := unzoo; END;

(*  ARC     : Write(' assuming ARC,');
    HAP     : Write(' assuming HAP,');
    PAK     : Write(' assuming PAK,');
    PKPak   : Write(' assuming PKPak,');
    RAR     : Write(' assuming RAR,');
    SQZ     : Write(' assuming SQZ,');
    UC2     : Write(' assuming UC2,');  *)

    UNKNOWN : WriteLn ('Trying user type,')
    ELSE
      WriteLn ('File not found!');
  END;

  SwapVectors;
    Exec (GetEnv ('COMSPEC'), ' /c ' + extract + ' ' + QWKfile+ ' ' + DATfileName + ' >nul');
    IF DosError = 8 THEN Halt (5);
  SwapVectors;

  GotoXY (X, Y);
  ClrEol;
  cursorOff;
  ExtractDAT := fileexists (DATfileName)
END;
{===========================================================================}

PROCEDURE ProcessHeader (VAR MSGFile: FILE; VAR TXTfile: TEXT; VAR NumChunks: INTEGER);

(* Note: the meaning of the status flag in the header of the QWK
  format specification is interpreted differently by different products.

  According to Patrick Y. Lee's "QWK Mail Packet File Layout" v1.0
  and Robomail v1.30, an asterisk ('*') means private and received,
  and the plus sign ('+') means private and NOT received.

  SLMR 2.1a, SPEED and OLX v1.53 seem to agree that the meaning of the
  two symbols is reversed.

  I believe the second meaning is accurate, so the private and
  received flags will be translated into the following symbols:

  public, unread   =  ' '  (#32)
  public, read     =  '-'  (#45)
  private, unread  =  '*'  (#42)
  private, read    =  '+'  (#43)
*)

TYPE
  MSGDATHdr = RECORD
                Status   : CHAR;
                MSGNum   : ARRAY [1..7] OF CHAR;
                Date     : ARRAY [1..8] OF CHAR;
                Time     : ARRAY [1..5] OF CHAR;
                WhoTo    : ARRAY [1..25] OF CHAR;
                WhoFrom  : ARRAY [1..25] OF CHAR;
                Subject  : ARRAY [1..25] OF CHAR;
                PassWord : ARRAY [1..12] OF CHAR;
                ReferNum : ARRAY [1..8] OF CHAR;
                NumChunk : ARRAY [1..6] OF CHAR;
                Alive    : BYTE;
                ConfNum  : WORD;
                Reserved : ARRAY [1..3] OF CHAR;
              END;
VAR
  VErr          : INTEGER;
  MessageHeader : MSGDATHdr;
  PRIVATE       : CHAR;
BEGIN
  updateCursor;
  BlockRead (MSGFile, MessageHeader, 1);
  Val (Squeeze (MessageHeader. NumChunk), NumChunks, VErr);
  IF (VErr <> 0) THEN NumChunks := 0;
  IF NumChunks <> 0 THEN
    WITH MessageHeader DO BEGIN

      IF (Pos (status, '+*~`!#') > 0) THEN PRIVATE := #158
                                      ELSE PRIVATE := #32;
      IF (confnum = ConfNumb) THEN
        WriteLn (TXTfile, (RTrim (MSGNum)): 6, PRIVATE:2, #32,
        Copy (Date, 1, 5), #32#32,
        Copy (WhoFrom, 1, 21), #32,
        Copy (WhoTo, 1, 21), #32,
        Copy (Subject, 1, 19));
    END;
END;
{===========================================================================}

PROCEDURE ProcessFiles (VAR MSGFile: FILE; VAR TXTfile: TEXT);
VAR
  QWKrecs,
  Chunks    : INTEGER;
BEGIN
  QWKrecs := 2;                         { start at RECORD #2 }
  WHILE QWKrecs < FileSize (MSGFile) DO BEGIN
    Seek (MSGFile, QWKrecs - 1);
    ProcessHeader (MSGFile, TXTfile, Chunks);
    IF Chunks = 0 THEN
      Chunks := 1;
    Inc (QWKrecs, Chunks);
  END;
END;

FUNCTION GetConfNumb (CONST PSTR: STRING): PATHSTR;
VAR
  ConfNumbpath   : PATHSTR;    { ConfNumb file path,     }
  ConfNumbdir    : DIRSTR;     {             directory,  }
  ConfNumbname   : NAMESTR;    {             name,       }
  ConfNumbext    : EXTSTR;     {             extension.  }

  sTemp : STRING;
  index : BYTE;
  VErr  : INTEGER;
BEGIN
  ConfNumbpath := PSTR;
  IF ConfNumbpath [1] IN ['/', '-'] THEN Halt (2);
  FSplit (FExpand (ConfNumbpath), ConfNumbdir, ConfNumbname, ConfNumbext);
  IF (ConfNumbname = '')  THEN Halt (6);

  sTemp := '';
  FOR index := 1 TO Length (ConfNumbname) DO
    IF ConfNumbname [index] IN ['0'..'9'] THEN
      sTemp := sTemp + ConfNumbname [index];
  IF sTemp = '' THEN Halt (2);
  Val (sTemp, confnumb, VErr);  { confnumb is a GLOBAL var }
  IF VErr <> 0 THEN Halt (2);

  GetConfNumb := ConfNumbdir + ConfNumbname + ConfNumbext;
END;

{===========================================================================}
                           (** Main program ... **)
{===========================================================================}

CONST
  MSGFileName = 'MESSAGES.DAT';

VAR
  MSGFile : FILE;
  TXTfile : TEXT;

  QWKpath    : PATHSTR;    { QWK file path. }
  QWKdir     : DIRSTR;     { QWK file dir.  }
  TXTpath    : PATHSTR;    { TXT file path. }
  fileinfo   : SEARCHREC;

BEGIN
  SavedExitProc := ExitProc;
  ExitProc := @CustomExit;
  IF ParamCount <> 2 THEN Halt (255);

  CheckBreak := TRUE;
  cursorOff;

  TXTpath := GetConfNumb (ParamStr (2));
  GetCFGvars;
  QWKdir := GetQWKdir (ParamStr (1), QWKpath);

  FindFirst (QWKpath, Archive, fileinfo); IF DosError <> 0 THEN Halt (1);
  WriteLn ('QHead v1.00 - Free QWK header extractor is now working.');
  WHILE DosError = 0 DO
  BEGIN
    QWKpath := QWKdir + fileinfo. Name;

    EraseFile (MSGFileName);
    Write ('Extracting MESSAGES.DAT from ', QWKpath, ' ...');
    IF ExtractDAT (QWKpath, MSGFileName) THEN BEGIN

      WriteLn (' done!');
      Assign (MSGFile, MSGFileName);
      Reset (MSGFile, 128); iocheck (IOResult);
      Assign (TXTfile, TXTpath);
      IF fileexists (TXTpath) THEN BEGIN
        Append (TXTfile); iocheck (IOResult);
        Write ('Appending ', TXTpath);
      END
      ELSE BEGIN
        Rewrite (TXTfile); iocheck (IOResult);
        IF qheader <> '' THEN
          WriteLn (TXTfile, qheader);
        IF qline <> '' THEN
          WriteLn (TXTfile, qline);
        Write ('Creating ', TXTpath);
      END;
      Write (', and now extracting headers', #32);
      ProcessFiles (MSGFile, TXTfile);
      WriteLn (#8, ', done!');
      Close (MSGFile); iocheck (IOResult);
      Close (TXTfile); iocheck (IOResult);
      EraseFile (MSGFileName);

    END
    ELSE
      WriteLn ('- bad QWK - skipping.');
    FindNext (fileinfo);
  END;
  WriteLn ('Mission accomplished!');
END.
