REM *********************************************************************/
REM                                                                     */
REM   SYSTEM       : HQ-FAX, Uitilities                                 */
REM   COPYRIGHT    : (c) 1995 HTF CONSULTING                            */
REM                                                                     */
REM *********************************************************************/
REM                                                                     */
REM   BAT file name: EP2GRAFX.bat                                       */
REM   DESCRIPTION  : This is the work-horse batch file which drives the */
REM                  conversion and view or send process for the Grp 3  */
REM                  FAX formats                                        */
REM *********************************************************************/
REM
Rem - Documentname Fontname (Options )
Echo off
CLS
Echo *************************************************************************
Echo *****                     HTF CONSULTING                            *****
Echo ***            EPSON to Graphics Conversion Procedure                 ***
Echo **               Copyright (c) 1995  HTF Consulting                    **
Echo *                                                                       *
Echo * Convert EPSON file: '%1.ECL' to FAX in font '%2'
REM Echo *                                                                       *
if not "%3" == "" Echo * Special options chosen are: "%3 %4 %5 %6 %7 %8 %9"
if "%3" == "" Echo * No Special options chosen:
Echo *                                                                       *
Echo * Available special options are:                                        *
Echo *  /CDR     Convert Double-Print to REVERSE-VIDEO                       *
Echo *  /CONT    Make 1 contiguous FAX file                                  *
Echo *  /FHxx    Specify a Fax header format:                                *
Echo *           xx = {00, AD, BF, C1, C2, CA, CP, DC, FR, PC, QL, TB, TF, TH}               *
Echo *  /FORM    Specify a Pre-printed form as a background of every page    *
Echo *  /LOGO    Apply the image 'LOGO.PCX' to the top center of every page  *
Echo *  /MF      Produced multiple files (one per page)                      *
Echo *  /PFxx    Override the default page format(NA) : xx = {A3, A4, B4, NA}*
Echo *  /PPxx.yy Specify start(xx), & end(yy) page numbers (default = all )  *
Echo *  /SEND    Specify Send parameters; Ex: /SEND 999-8888 /TM09:00p       *
Echo *           (Send parameters must be last parameters on command line)   *
Echo *  /STD     Produce a standard resolution file (else FINE)              *
Echo *  /VIEW    View the produced image(s)                                  *
Echo *  /RVx     Specify Reverse-Video trigger character: x = {*, ~, \, ^ }  *
Echo *************************************************************************
Pause
if not exist %1.ECL goto Abend
if not exist %2.FNT goto Abend

CLS
Echo **************************************************************************
Echo ***  Converting EPSON file %1.ECL to graphics images
Echo ***  Approximate time required will be 1 minutes per full page          **
Echo ***  ( When run on a 16 Mhz AT 386/SX )                                 **
Echo ***                                                                     **
Echo ***  Approximate disk space required will be:                           **
Echo ***      .05 Megabytes (50K) per page                                   **
Echo ***                                                                     **
Echo **************************************************************************
Echo Working .....

ECL2FAX3.exe %1.ECL %2 * %3 %4 %5 %6 %7 %8 %9
if errorlevel 2 goto Abend

:Display
if %4 == /VIEW  Call viewfax3.bat %1 %3
if %5 == /VIEW  Call viewfax3.bat %1 %3
if %6 == /VIEW  Call viewfax3.bat %1 %3
if %7 == /VIEW  Call viewfax3.bat %1 %3
if %8 == /VIEW  Call viewfax3.bat %1 %3
if %9 == /VIEW  Call viewfax3.bat %1 %3

:Dial
REM - Call the Faxsend.bat file to issue a DOS command line send
if %4 == /SEND Faxsend.bat %1 %3 %5 %6 %7 %8 %9
if %5 == /SEND Faxsend.bat %1 %3 %6 %7 %8 %9
if %6 == /SEND Faxsend.bat %1 %3 %7 %8 %9
if %7 == /SEND Faxsend.bat %1 %3 %8 %9
if %8 == /SEND Faxsend.bat %1 %3 %9

:Abend
if not errorlevel 2 CLS
REM Type Bell.txt
Echo **************************************************************************
Echo ***                                                                      *
Echo ***  ep2grafx.bat: Abnormal end of job:                                  *
Echo ***  Source document %1.ECL,  Font table %2.FNT
Echo ***                                                                      *
Echo **************************************************************************
Echo *
if not exist %1.ECL Echo ***    EPSON file %1.ECL not found
if exist %3.FNT goto quit
Echo ***    %2.FNT - File not found
Echo ***
Echo ***  Chosen font not available - Available Fonts are listed below:
dir *.fnt /w
Echo ***
Echo ***  The 'A' suffixes are for Alternate Fonts (Elite pitch)
Pause

:quit
Echo on
Rem - chdir c:\

:quit
Echo on
Rem - chdir c:\
