PROGRAM Sort_Conference_Participation_Tracker_Database;
{$M 5120,0,655360}
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I-} {disable I/O checking - trap errors by checking IOResult}
USES CRT, DOS, NUMDAYS, CPT_CODE;

VAR SavedExitProc: POINTER;

{===========================================================================}

PROCEDURE CustomExit; FAR;
  {---- Always exit through here ----}
CONST
  progdesc = 'CPT-Sort - Free DOS utility: Sort CPT Database.';
  usage    = 'Usage: CPT-Sort <CPT file> <sort order(s) [see below]>';
  name_a   = '    name     = sort by first name, ascending (A to Z)';
  name_d   = '   -name     = sort by first name, descending (Z to A)';
  sent_a   = '    sent     = sort by messages sent, ascending (fewest messages at top)';
  sent_d   = '   -sent     = sort by messages sent, descending (most messages at top)';
  oldest_a = '    oldest   = sort by oldest message, ascending (new people at end)';
  oldest_d = '   -oldest   = sort by oldest message, descending (new people at top)';
  newest_a = '    newest   = sort by newest message, ascending (current posters at end)';
  newest_d = '   -newest   = sort by newest message, descending (current posters at top)';
  example1 = 'Example:  CPT-Sort cnf_100.dat -sent';
  example2 = 'Example:  CPT-Stat 67.mem -sent name';
  
BEGIN
  ExitProc := SavedExitProc;
  cursorOn;
  IF (ExitCode > 0) THEN BEGIN
    WriteLn (progdesc);
    WriteLn (author);    WriteLn;
    WriteLn (usage);     WriteLn;
    WriteLn (name_a);    WriteLn (name_d);
    WriteLn (sent_a);    WriteLn (sent_d);
    WriteLn (oldest_a);  WriteLn (oldest_d);
    WriteLn (newest_a);  WriteLn (newest_d);  WriteLn;
    WriteLn (example1);
    WriteLn (example2);  WriteLn;
  END;
  IF ErrorAddr <> NIL THEN
  BEGIN
    WriteLn ('An unanticipated error occurred, please contact DDA with the following data:');
    WriteLn ('Address = ', Seg (ErrorAddr^), ':', Ofs (ErrorAddr^));
    WriteLn ('Code    = ', ExitCode);
    ErrorAddr := NIL;
  END
  ELSE
    IF (ExitCode > 0) AND (ExitCode < 255) THEN
      WriteError (ExitCode);
END;
{===========================================================================}

VAR MemberInfo  : MemLink;
  Members     : WORD;
  MemFileName : PATHSTR;
  PCount      : BYTE;
  
BEGIN
  SavedExitProc := ExitProc;
  ExitProc := @CustomExit;
  
  IF ParamCount < 2 THEN Halt (255);
  
  MemFileName := GetMFN (ParamStr (1));
  IF NOT fileexists (MemFileName) THEN Halt (1);
  WriteLn ('CPT-Sort resorting ', MemFileName);
  Members := BuildList (MemberInfo, MemFileName); WriteLn;
  
  IF MemberInfo <> NIL THEN BEGIN
    FOR PCount := ParamCount DOWNTO 2 DO BEGIN
      GetSortField (ParamStr (Pcount));
      SortLinkedList (MemberInfo); WriteLn;
    END;
    WriteList (MemberInfo, MemFileName, Members); WriteLn;
  END;
  WriteLn ('Mission accomplished!');
END.
