#include "FiveWin.ch"

//----------------------------------------------------------------------------//

CLASS TWorkArea

   DATA   nArea     AS Numeric              // No cambiar el orden
   DATA   lBufferOn AS Logical   READONLY   // de estas declaraciones
   DATA   aBuffer   AS Array                // de datos.

   METHOD New( nArea )  CONSTRUCTOR     // Buffering ON By default

   METHOD FieldGet( nField ) EXTERN TWAFieldGe()       // if buffering
   METHOD FieldPut( nField, uVal ) EXTERN TWAFieldSe() // access to buffer.
   METHOD Load()        EXTERN TWALoad()
   METHOD Save()        EXTERN TWASave()
   METHOD SetBuffer( lOnOff )  // if TRUE reloads buffer
   METHOD Blank()

   HIDE METHOD SetArea( nArea )

   METHOD Eof()         EXTERN TWAEof()
   METHOD Bof()         EXTERN TWABof()
   METHOD FCount()      EXTERN TWAFCount()
   METHOD RecNo()       EXTERN TWARecNo()
   METHOD Deleted()     EXTERN TWADeleted()
   METHOD LastRec()     EXTERN TWALastRec()
   METHOD RecCount()    EXTERN TWALastRec()
   METHOD Lock()        EXTERN TWALock()
   METHOD RecLock()     EXTERN TWARLock()
   METHOD GoTop()       EXTERN TWAGoTop()    // if buffering reloads buffer
   METHOD GoBottom()    EXTERN TWAGoBotto()  //    "
   METHOD Commit()      EXTERN TWACommit()
   METHOD Delete()      EXTERN TWADelete()
   METHOD ReCall()      EXTERN TWAReCall()
   METHOD DBEval( bBlock, bFor, bWhile, nNext, nRecord, lRest ) ;
                        EXTERN TWAEval()
   METHOD Seek( uExp, lSoft ) EXTERN TWASeek() // if buffering reloads buffer
   METHOD Skip( nRecords ) EXTERN TWASkip()    //    "
   METHOD GoTo( nRecNo ) EXTERN TWAGoTo()      //    "
   METHOD Append()      EXTERN TWAAppend()
   METHOD UnLock()      EXTERN TWAUnLock()
   METHOD Pack()        EXTERN TWAPack()
   METHOD Zap()         EXTERN TWAZap()

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nArea ) CLASS TWorkArea

   if Empty( nArea )
      nArea := Select()
   endif   

   ::lBufferOn := .T.
   ::nArea     := nArea

   ::SetArea()

return Self

//----------------------------------------------------------------------------//

METHOD SetArea() CLASS TWorkArea

   static nClassH
   local  n, nOldArea := Select()
   
   DEFAULT nClassH := TWorkArea():ClassH()

   SELECT ( ::nArea )

   for n = 1 to FCount()
       TWADictAdd( nClassH, "_" + Field( n ), Field( n ) )
   next

   ::aBuffer := Array( FCount() )

   if ::lBufferOn
      ::Load()
   endif

   SELECT ( nOldArea )

return nil

//---------------------------------------------------------------------------//

METHOD SetBuffer( lOnOff ) CLASS TWorkArea

    DEFAULT lOnOff := .f.

    ::lBufferOn := lOnOff

    if ::lBufferOn
       ::Load()
    endif

return nil

//----------------------------------------------------------------------------//

METHOD Blank() CLASS TWorkArea

   AEval( ::aBuffer, ;
          { | uVal, n | ::aBuffer[ n ] := uValBlank( ::aBuffer[ n ] ) } )
return nil

//---------------------------------------------------------------------------//
