#include <WinTen.h>
#include <Windows.h>
#include <ClipApi.h>

//----------------------------------------------------------------------------//

WORD GetWindowRows( HWND hWnd, HDC hDC, HFONT hFont )
{
   TEXTMETRIC tm;
   RECT rct;
   WORD wRows;
   BOOL bDCDestroy = FALSE;
   HFONT hOldFont;

   if( ! hDC )
   {
      bDCDestroy = TRUE;
      hDC = GetDC( hWnd );
   }

   if( hFont )
      hOldFont = SelectObject( hDC, hFont );

   GetTextMetrics( hDC, &tm );
   GetClientRect( hWnd, &rct );
   wRows = ( rct.bottom - rct.top ) / tm.tmHeight;

   if( hFont )
      SelectObject( hDC, hOldFont );

   if( bDCDestroy )
      ReleaseDC( hWnd, hDC );

   return wRows;
}

//----------------------------------------------------------------------------//

CLIPPER nWRows()        // hWnd, hDC, hFont
{
   _retni( GetWindowRows( _parni( 1 ), _parni( 2 ), _parni( 3 ) ) );
}

//----------------------------------------------------------------------------//

WORD GetWindowRow( HWND hWnd, HDC hDC, WORD wGraphRow, HFONT hFont ) // -> wTextRow
{
   TEXTMETRIC tm;
   RECT rct;
   WORD wRow;
   BOOL bDCDestroy = FALSE;
   HFONT hOldFont;

   if( ! hDC )
   {
      bDCDestroy = TRUE;
      hDC = GetDC( hWnd );
   }

   if( hFont )
      hOldFont = SelectObject( hDC, hFont );

   GetTextMetrics( hDC, &tm );
   GetClientRect( hWnd, &rct );
   wRow = ( wGraphRow - rct.top ) / tm.tmHeight;

   if( hFont )
      SelectObject( hDC, hOldFont );

   if( bDCDestroy )
      ReleaseDC( hWnd, hDC );

   return wRow;
}

//----------------------------------------------------------------------------//

CLIPPER nWRow()        // hWnd, hDC, nGraphRow, hFont -> nTextRow
{
   _retni( GetWindowRow( _parni( 1 ), _parni( 2 ), _parni( 3 ), _parni( 4 ) ) );
}

//----------------------------------------------------------------------------//
