// Use WinExec( ..., 9 ) to execute the _same_ external application
// using the previous one if already running.

#include <WinTen.h>
#include <Windows.h>
#include <ClipApi.h>

BOOL SysRefresh( void );

//----------------------------------------------------------------------------//

CLIPPER WINEXEC()
{
   WORD wMode = ( PCOUNT() > 1 ) ? _parni( 2 ): SW_NORMAL;

   _retni( WinExec( _parc( 1 ), wMode ) );
}

//----------------------------------------------------------------------------//

CLIPPER GETWINDIR() //  --> cWindowsPath
{
   BYTE bBuffer[ 255 ];

   GetWindowsDirectory( bBuffer, 254 );
   _retc( bBuffer );
}

//----------------------------------------------------------------------------//

CLIPPER GETSYSDIR() // --> cWindowsSystemPath
{
   BYTE bBuffer[ 255 ];

   GetSystemDirectory( bBuffer, 254 );
   _retc( bBuffer );
}

//----------------------------------------------------------------------------//

CLIPPER GETNUMTASK() // S()  --> nTasksInUse
{
   _retni( GetNumTasks() );
}

//----------------------------------------------------------------------------//

CLIPPER GETVERSION() //  --> anVersions
{
   LONG lInfo = GetVersion();

   _reta( 4 );
   _storni( LOBYTE( LOWORD( lInfo ) ), -1, 1 );
   _storni( HIBYTE( LOWORD( lInfo ) ), -1, 2 );
   _storni( HIBYTE( HIWORD( lInfo ) ), -1, 3 );
   _storni( LOBYTE( HIWORD( lInfo ) ), -1, 4 );
}

//----------------------------------------------------------------------------//

CLIPPER GETMODULEF() // ILENAME()  hInstance --> cAppName
{
   BYTE bBuffer[ 250 ];

   GetModuleFileName( _parni( 1 ), bBuffer, 249 );
   _retc( bBuffer );
}

//----------------------------------------------------------------------------//

CLIPPER WAITRUN()
{
   HMODULE hInst = WinExec( _parc( 1 ),
                            IF( ( PCOUNT() > 1 ), _parni( 2 ), SW_NORMAL ) );
   WORD wCount   = GetModuleUsage( hInst );

   while( SysRefresh() && GetModuleUsage( hInst ) > ( wCount - 1 ) );
}

//----------------------------------------------------------------------------//
