#include "FiveWin.ch"
#include "Constant.ch"

static lRegistered := .f.

//----------------------------------------------------------------------------//

CLASS TVideo FROM TControl

   DATA   oMci
   DATA   cAviFile

   METHOD New( nRow, nCol, nWidth, nHeight, cFileName, oWnd,;
               bWhen, bValid ) CONSTRUCTOR

   METHOD ReDefine( nId, cFileName, oDlg, bWhen, bValid ) CONSTRUCTOR

   METHOD Init( hDlg )

   METHOD Play( nFrom, nTo ) INLINE  ::oMci:Play( nFrom, nTo, ::hWnd )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nRow, nCol, nWidth, nHeight, cFileName, oWnd ) CLASS TVideo

   DEFAULT nWidth := 200, nHeight := 200, cFileName := ""

   ::nTop      = nRow *  VID_CHARPIX_H	// 8	  
   ::nLeft     = nCol * VID_CHARPIX_W	// 14
   ::nBottom   = ::nTop  + nHeight - 1
   ::nRight    = ::nLeft + nWidth + 1
   ::nStyle    = nOR( WS_CHILD, WS_VISIBLE, WS_TABSTOP, WS_BORDER )
   ::nId       = ::GetNewId()
   ::oWnd      = oWnd
   ::cAviFile  = cFileName
   ::oMci      = TMci():New( "avivideo", cFileName )
   ::lDrag     = .f.
   ::lCaptured = .f.

   if ! lRegistered
      ::Register( nOR( CS_VREDRAW, CS_HREDRAW ) )
      lRegistered = .t.
   endif

   if oWnd:lVisible
      ::Create()
      ::oMci:lOpen()
      ::oMci:SetWindow( Self )
   else
      oWnd:DefControl( Self )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD ReDefine( nId, cFileName, oDlg, bWhen, bValid ) CLASS TVideo

   ::nId      = nId
   ::cAviFile = cFileName
   ::bWhen    = bWhen
   ::bValid   = bValid
   ::oWnd     = oDlg
   ::oMci     = TMci():New( "avivideo", cFileName )

   if ! lRegistered
      ::Register( nOR( CS_VREDRAW, CS_HREDRAW ) )
      lRegistered = .t.
   endif

   oDlg:DefControl( Self )

return nil

//----------------------------------------------------------------------------//

METHOD Init( hDlg ) CLASS TVideo

   Super:Init( hDlg )
   ::oMci:lOpen()

return nil

//----------------------------------------------------------------------------//
