// In this exercise we are going to build Dialog Boxes directly from
// our program. In next exercises we will review how to build them using
// a resource editor.

#include "FiveWin.ch"

static oWnd

//----------------------------------------------------------------------------//

function Main()

   DEFINE WINDOW oWnd FROM 1, 1 TO 22, 75 ;
      TITLE OemToAnsi( "Construyendo una Caja de Dilogo" ) ;
      MENU  BuildMenu()

   SET MESSAGE OF oWnd ;
      TO OemToAnsi( "FiveWin 1.5, (c) A.Linares & F.Pulpn, 1993-4" )

   ACTIVATE WINDOW oWnd MAXIMIZED

return nil

//----------------------------------------------------------------------------//

function BuildMenu()

   local oMenu

   MENU oMenu
      MENUITEM OemToAnsi( "&Informacin" )
      MENU
         MENUITEM "&Acerca de..." ;
            ACTION MsgInfo( OemToAnsi( "Tutorial de FiveWin" + Chr( 13 ) + ;
                            "(c) A.Linares, F.Pulpn, 1993" ) ) ;
            MESSAGE OemToAnsi( "Informacin acerca de este programa" )
         SEPARATOR
         MENUITEM "&Terminar..."  ;
            ACTION If( MsgYesNo( OemToAnsi( " Desea terminar ?" ) ),;
                       oWnd:End(),) ;
            MESSAGE OemToAnsi( "Terminar la ejecucin de este programa" )
      ENDMENU

      MENUITEM "&Ficheros"
      MENU
         MENUITEM   "&Clientes..."           ;
            ACTION  Clientes() ;
            MESSAGE OemToAnsi( "Mantenimiento de Clientes" )

         MENUITEM   OemToAnsi( "&Almacn" ) ;
            ACTION  MsgInfo( OemToAnsi( "Control del Almacn" ) ) ;
            MESSAGE OemToAnsi( "Control del Almacn" )
      ENDMENU

      MENUITEM "&Utilidades"
      MENU
         MENUITEM "&Calculadora..." ;
            ACTION WinExec( "Calc" ) ;
            MESSAGE "Llamar a la calculadora de Windows"

         MENUITEM "C&alendario..." ;
            ACTION WinExec( "Calendar" ) ;
            MESSAGE "Llamar al calendario de Windows"

         MENUITEM "&Fichero..." ;
            ACTION WinExec( "CardFile" ) ;
            MESSAGE "Llamar al gestor de ficheros de Windows"
      ENDMENU
   ENDMENU

return oMenu

//----------------------------------------------------------------------------//

function Clientes()

   local oDlg
   local cNombre := "Este es el nombre de mi Cliente       "
   local lUsaFiveWin := .t.
   local numero := 0

   DEFINE DIALOG oDlg FROM 6, 7 TO 21, 72 TITLE "Mantenimiento de Clientes"

   @ 1,  2 SAY "Nombre:" OF oDlg
   @ 1,  8 GET cNombre  OF oDlg
   @ 4,  8 GET numero PICTURE "99.99" OF oDlg

   @ 3,  2 CHECKBOX lUsaFiveWin PROMPT "Usa Clipper y FiveWin" OF oDlg

   @ 8,  3 BUTTON "&Anterior"  OF oDlg SIZE 50, 12 ACTION MsgInfo( "Anterior" )
   @ 8, 14 BUTTON "&Siguiente" OF oDlg SIZE 50, 12 ACTION MsgInfo( "Siguiente" )
   @ 8, 26 BUTTON "&Terminar"  OF oDlg SIZE 50, 12 ACTION oDlg:End()

   ACTIVATE DIALOG oDlg

return nil

//----------------------------------------------------------------------------//
