#include "FiveWin.ch"

#define MM_ANISOTROPIC     8

static lRegistered := .f.

//----------------------------------------------------------------------------//

CLASS TMetaFile FROM TControl

   DATA   hMeta

   DATA   nWidth, nHeight, nXorig, nYorig

   DATA   lZoom

   METHOD New( nTop, nLeft, nWidth, nHeight, cMetaFile, oWnd,;
               nClrFore, nClrBack ) CONSTRUCTOR

   METHOD Redefine( nId, cMetaFile, oWnd, nClrFore, nClrBack ) CONSTRUCTOR

   METHOD Display() INLINE ::BeginPaint(), ::Paint(), ::EndPaint(), 0
   METHOD Paint()

   METHOD SetFile(cFile)

   METHOD End()

   METHOD ZoomIn()  INLINE IIF(!::lZoom, (::nWidth  /= 2 ,;
                                          ::nHeight /= 4   ,;
                                          ::lZoom   := .T. ,;
                                          ::Refresh()), )
   METHOD ZoomOut() INLINE IIF(::lZoom , (::nWidth  *= 2 ,;
                                          ::nHeight *= 4   ,;
                                          ::lZoom   := .F. ,;
                                          ::nXorig  := 0   ,;
                                          ::nYorig  := 0   ,;
                                          ::Refresh()), )

   METHOD SetOrg(nX,nY)    INLINE iif(nX != NIL, ::nXorig := nX ,) ,;
                                  iif(nY != NIL, ::nYorig := nY ,)

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nTop, nLeft, nWidth, nHeight, cMetaFile, oWnd,;
            nClrFore, nClrBack,nLogWidth, nLogHeight ) CLASS TMetaFile

   DEFAULT nWidth := 100, nHeight := 100, oWnd := GetWndDefault()

   ::nTop     = nTop
   ::nLeft    = nLeft
   ::nBottom  = nTop + nHeight - 1
   ::nRight   = nLeft + nWidth - 1
   ::cCaption = cMetaFile
   ::oWnd     = oWnd
   ::nStyle   = nOr( WS_CHILD, WS_BORDER, WS_VISIBLE )
   ::nWidth   = nLogWidth
   ::nHeight  = nLogHeight
   ::lZoom    = .F.
   ::nXorig   = 0
   ::nYorig   = 0
   ::hMeta    = 0

   if ! lRegistered
      ::Register()
      lRegistered = .t.
   endif

   ::SetColor( nClrFore, nClrBack )

   if oWnd:lVisible
      ::Create()
      ::Default()
      ::lVisible = .t.
      oWnd:AddControl( Self )
   else
      oWnd:DefControl( Self )
      ::lVisible  = .f.
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Redefine( nId, cMetaFile, oWnd, nClrFore, nClrBack ) CLASS TMetaFile

   DEFAULT oWnd := GetWndDefault()

   ::nId      = nId
   ::cCaption = cMetaFile
   ::oWnd     = oWnd
   ::nWidth   = 100
   ::nHeight  = 100
   ::hMeta    = 0

   if ! lRegistered
      ::Register()
      lRegistered = .t.
   endif

   ::SetColor( nClrFore, nClrBack )

   oWnd:DefControl( Self )

return nil

//----------------------------------------------------------------------------//

METHOD Paint() CLASS TMetaFile

   local oRect := ::GetRect()

   IF ::hMeta == 0
        IF file(::cCaption)
           ::hMeta := GetMetaFile( ::cCaption )
        ELSEIF !empty(::cCaption)
           Alert("Could not find the Metafile,"+CRLF+;
                 "please check your TEMP environment variable")
        ENDIF
   ENDIF


   IF ::hMeta != 0
        SetWindowOrg(::hDC, ::nXorig, ::nYorig)
        SetMapMode( ::hDC, MM_ANISOTROPIC )
        SetWindowExt( ::hDC, ::nWidth, ::nHeight )
        SetViewportExt( ::hDC, oRect:nRight - oRect:nLeft,;
                        oRect:nBottom - oRect:nTop )
        PlayMetaFile( ::hDC, ::hMeta )
   ENDIF

return nil

//----------------------------------------------------------------------------//
METHOD SetFile(cFile) CLASS TMetaFile

     IF file(cFile)
          ::cCaption := cFile
     ELSE
          ::cCaption := ""
     ENDIF

     IF ::hMeta != 0
          DeleteMetafile(::hMeta)
          ::hMeta := 0
     ENDIF

RETURN NIL

//----------------------------------------------------------------------------//
METHOD End() CLASS TMetaFile

     IF ::hMeta != 0
          DeleteMetafile(::hMeta)
          ::hMeta := 0
     ENDIF

     Super:End()

RETURN NIL
