// FiveWin - Windows MAIL services Object Oriented implementation

#include "FiveWin.ch"

//----------------------------------------------------------------------------//

CLASS TMail

   DATA   cSubject, cNoteText, cMsgType
   DATA   cConversationID
   DATA   dDate, cTime
   DATA   lReceipt, lFromUser
   DATA   aOrigin, aRecipients, aFiles

   METHOD New( cSubject, cNoteText, cMsgType, cConversationID,;
               dDate, cTime, lReceipt, lFromUser, aOrigin, aRecipients,;
               aFiles ) CONSTRUCTOR

   METHOD Activate()

   METHOD End() INLINE MAPILogOff()

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( cSubject, cNoteText, cMsgType, cConversationID,;
            dDate, cTime, lReceipt, lFromUSer, aOrigin, aRecipients,;
            aFiles ) CLASS TMail

   DEFAULT cNoteText := "", cSubject := "", cMsgType := "",;
           cConversationID := "", dDate := Date(), cTime := Time(),;
           lReceipt := .f., lFromUser := .t.,;
           aOrigin := {}, aRecipients := {}, aFiles := {}

   ::cNoteText   = cNoteText
   ::cSubject    = cSubject
   ::cMsgType    = cMsgType
   ::cConversationID = cConversationID
   ::dDate       = If( ValType( dDate ) == "C", CToD( dDate ), dDate )
   ::cTime       = cTime
   ::lReceipt    = lReceipt
   ::lFromUser   = lFromUser
   ::aOrigin     = aOrigin
   ::aRecipients = aRecipients
   ::aFiles      = aFiles

return nil

//----------------------------------------------------------------------------//

METHOD Activate() CLASS TMail

   MAPILogOn()
   MAPISendMail( ::cSubject, ::cNoteText, ::cMsgType,;
                 DToS( ::dDate ) + " " + ::cTime,;
                 ::cConversationID, ::lReceipt, ::lFromUser,;
                 ::aOrigin, ::aRecipients )
return nil

//----------------------------------------------------------------------------//
