// FiveWin own Trees management

#include "FiveWin.ch"

static oBar
static oDlgChild

//----------------------------------------------------------------------------//

function Main()

   local oDlg, oLbx, oTree, oSay, oFolder

   SET 3DLOOK ON

   DEFINE DIALOG oDlg RESOURCE "Main"

   oDlg:bKeyChar = { || MsgBeep() }

   TREE oTree BITMAPS "Folder1", "Folder2"
      TREEITEM "Main window"      RESOURCE "Wnd2"  OPENED
      TREE
         TREEITEM "PullDown Menu"    RESOURCE "Menu"
         TREE
            TREEITEM "&Information"  RESOURCE "Menu"
            TREE
               TREEITEM "&About..."  RESOURCE "Dialog"
            ENDTREE
            TREEITEM "&DataBases"    RESOURCE "Menu"
            TREE
               TREEITEM "&Customers" RESOURCE "Dialog"
               TREEITEM "&Stock"     RESOURCE "Dialog"
            ENDTREE
            TREEITEM    "&Utilities" RESOURCE "Menu"
            TREE
               TREEITEM "&Calc"      RESOURCE "Calc"
            ENDTREE
         ENDTREE
         TREEITEM "ButtonBar"     RESOURCE "BtnBar"
         TREEITEM "MessageBar"    RESOURCE "MsgBar"
         TREEITEM "DataBases"     RESOURCE "Dbfs"
      ENDTREE
      TREEITEM "Source Code"      RESOURCE "Source" OPENED
      TREE
         TREEITEM "Rmake File"    RESOURCE "Make"
         TREEITEM "Libraries"     RESOURCE "Lib"
      ENDTREE
      TREEITEM "Help File"        RESOURCE "Help"
   ENDTREE

   REDEFINE LISTBOX oLbx FIELDS ;
      HEADERS "", "", "Application components" ;
      ID 110 OF oDlg

   oLbx:SetTree( oTree )

   oFolder = TFolder():ReDefine( 120,;
                       { "Caption & Size", "Style", "Controls", "Test" },;
                       { { || MsgInfo( "One" ) },;
                         { || CapSize( oSay ), oFolder:SetFocus() },;
                         { || WndControls( oSay ), oFolder:SetFocus() },;
                         { || MsgInfo( "Four" ) } },;
                        oDlg )

   REDEFINE SAY oSay ID 130 OF oDlg

   oSay:bKeyChar = { || MsgBeep() }

   REDEFINE BITMAP ID 140 RESOURCE "FwQad" OF oDlg

   ACTIVATE DIALOG oDlg CENTERED ;
      ON INIT ( PlaceButtons( oDlg ) ) ;
      VALID MsgYesNo( "Do you want to exit ?" )

return nil

//----------------------------------------------------------------------------//

function PlaceButtons( oDlg )

   DEFINE BUTTONBAR oBar 3D SIZE 33, 33 OF oDlg

   DEFINE BUTTON OF oBar RESOURCE "Info" ACTION MsgAbout( "FiveWin - QAD" )
   DEFINE BUTTON OF oBar
   DEFINE BUTTON OF oBar RESOURCE "Exit" ACTION oDlg:End()

   SET MESSAGE OF oDlg TO "FiveWin Control Center" CENTERED

return nil

//----------------------------------------------------------------------------//

function CapSize( oWnd )

   if oDlgChild != nil
      oDlgChild:End()
      SysRefresh()
      oDlgChild = nil
   endif

   DEFINE DIALOG oDlgChild RESOURCE "CapSize" OF oWnd

   ACTIVATE DIALOG oDlgChild ;
      ON INIT oDlgChild:Move( 2, 2 )

return nil

//----------------------------------------------------------------------------//

function WndControls( oWnd )

   if oDlgChild != nil
      oDlgChild:End()
      SysRefresh()
      oDlgChild = nil
   endif

   DEFINE DIALOG oDlgChild RESOURCE "WndControls" OF oWnd

   ACTIVATE DIALOG oDlgChild NOWAIT ;
      ON INIT oDlgChild:Move( 2, 2 )

return nil

//----------------------------------------------------------------------------//
