// More reports...

#include "report.ch"
#include "FiveWin.ch"

STATIC oReport

Function Main()

     LOCAL oWnd

     USE Customer ALIAS Test
     INDEX ON Test->State TO CustStat
     SET INDEX TO CustStat

     DEFINE DIALOG oWnd TITLE "Prueba informes" ;
          FROM 10,10 TO 18,50

     @ 3,8.5 BUTTON "Imprimir" ;
          DEFAULT OF oWnd  ;
          SIZE 50,15          ;
          ACTION Report()

     ACTIVATE DIALOG oWnd


RETURN NIL


//----------------------------------------------------------------------------//

Function Report()

     LOCAL oFont1, oFont2, oFont3

     DEFINE FONT oFont1 NAME "ARIAL" SIZE 0,-10
     DEFINE FONT oFont2 NAME "ARIAL" SIZE 0,-10 BOLD
     DEFINE FONT oFont3 NAME "ARIAL" SIZE 0,-10 BOLD ITALIC

     GO TOP

     REPORT oReport ;
          TITLE  "*** LISTADO DE PRUEBA ***",;
                 "",;
                 OemtoAnsi("Ignacio Ortiz de Zuiga"),;
                 "" ;
          FONT   oFont1,;
                 oFont2,;
                 oFont3 ;
          HEADER "Fecha: "+dtoc(date()),;
                 "Hora:  "+time() ;
                 RIGHT ;
          FOOTER OemtoAnsi("Pgina: ")+str(oReport:nPage,3) ;
                 CENTERED ;
          TO SCREEN // PREVIEW

     GROUP ON Test->State ;
           FOOTER "Total Estado "+oReport:aGroups[1]:cValue ;
           FONT 2

     COLUMN TITLE "ST" ;
          DATA Test->State ;
          FONT 2

     COLUMN TITLE "City" ;
          DATA Test->City

     COLUMN TITLE "First Name","Last Name" ;
          DATA Test->First, Test->Last

     COLUMN TITLE "   Salary" ;
          DATA Test->Salary ;
          PICTURE "9,999,999" ;
          SIZE 9 ;
          TOTAL
          //RIGHT

     END REPORT


     IF !oReport:lCreated
          RETU NIL
     ENDIF

     /*
     Comentarios en espaol
     */

     oReport:lSpanish := .f.

     /*
     Primera linea del titulo en negrita
     */

     oReport:oTitle:aFont[1] := {|| 2 }

     /*
     Poner en italica  cuando el salario es mas de 100.000
     */

     oReport:aColumns[4]:bDataFont := {|| iif(Test->Salary>100000,3 ,1 ) }

     ACTIVATE REPORT oReport ON STARTGROUP oReport:NewLine() ;
                             ON INIT Datos()

RETURN NIL

Function Datos()

     local cText

     cText := "Ancho hoja    : "+str(oReport:nWidth)+CRLF
     cText += "Alto hoja     : "+str(oReport:nHeight)+CRLF
     cText += "Ancho listado : "+str(oReport:nRptWidth)+CRLF
     cText += "Margen Izquier: "+str(oReport:nLeftMargin)+CRLF
     cText += "Margen Derecho: "+str(oReport:nRightMargin)+CRLF
     cText += "Ancho del Font: "+str(oReport:aFont[1]:nWidth)+CRLF
     cText += "Alto del Font:  "+str(oReport:aFont[1]:nHeight)+CRLF
     cText += "Ancho Standard: "+str(oReport:nSeparator)+CRLF
     cText += "Ancho columna1: "+str(oReport:aColumns[1]:nWidth)+CRLF
     cText += "Ancho columna2: "+str(oReport:aColumns[2]:nWidth)+CRLF
     cText += "nlogPixelsX   : "+str(oReport:oDevice:nLogPixelsX())+CRLF
     cText += "nlogPixelsY   : "+str(oReport:oDevice:nLogPixelsY())+CRLF
     cText += "Horzside      : "+str(oReport:oDevice:nHorzsize())+CRLF
     cText += "Vertside      : "+str(oReport:oDevice:nVertsize())+CRLF

     Alert(cText)

RETURN NIL




