// This is a demo of the FiveWin report Engine

#include "FiveWin.ch"
#include "report.ch"

#define BLANCO     1
#define ROJO       2
#define AMARILLO   3
#define AZUL       4
#define VERDE      5

static oWnd

//----------------------------------------------------------------------------//

Function Main()

   LOCAL oBar

   FIELD State, City

   USE Customer
   INDEX ON State+City TO CustStCt
   SET INDEX TO CustStCt

   DEFINE WINDOW oWnd TITLE "FiveWin Report Engine demo" MDI

   DEFINE BUTTONBAR oBar OF oWnd

   DEFINE BUTTON OF oBar ACTION DoReport()

   ACTIVATE WINDOW oWnd

return nil

//----------------------------------------------------------------------------//

function DoReport()

   local oReport

   REPORT oReport ;
        TITLE "*** LISTADO DE PRUEBA ***","","Ignacio Ortiz de Zuiga","" ;
        HEADER "Fecha: "+dtoc(date())+space(44)+"Hora:  "+time() ;
        FOOTER "Pgina: "+str(oReport:nPage,3)

   GROUP ON Customer->State ;
        HEADER " " ;
        FOOTER "Total Estado "+oReport:aGroups[1]:cValue

   COLUMN TITLE "ST" ;
        DATA Customer->State

   COLUMN TITLE "City" ;
        DATA Customer->City ;
        SIZE 30

   COLUMN TITLE "First Name","Last Name" ;
        DATA Customer->First, Customer->Last ;
        SIZE 30

   COLUMN TITLE "   Salary" ;
        DATA Customer->Salary ;
        PICTURE "9,999,999" ;
        SIZE 9 ;
        TOTAL

   END REPORT

   // Color para lineas en verde
   // oReport:bStdFont := {|| VERDE }

   //Color para totales de cuarta columna en AZUL
   // oReport:aColumns[4]:bTotalFont := {|| AZUL }

   //Header y Footer en azul
   // oReport:oHeader:aFont[1] := {|| AZUL }
   // oReport:oFooter:aFont[1] := {|| AZUL }

   // Titulo, header y Footer de grupo en amarillo
   // oReport:oTitle:aFont[1] := {|| AMARILLO }
   // oReport:aGroups[1]:bHeadFont :={||  AMARILLO }
   // oReport:aGroups[1]:bFootFont :={||  AMARILLO }

   ACTIVATE REPORT oReport ;
      ON STARTPAGE Tone( 100, 1 )

RETURN NIL

//----------------------------------------------------------------------------//
