// Sample showing how to use INI files with FiveWin

#include "FiveWin.ch"

//----------------------------------------------------------------------------//

function Main()

   local oWnd, oIni, oBar
   local cTitle, cMsg, cLogo
   local nRow  := 3, nCol := 5, nWidth := 50, nHeight := 50
   local cBtn1 := "", cBtn2 := ""

   INI oIni FILE ".\MyApp"
      GET cTitle SECTION "main" ENTRY "Title"   OF oIni DEFAULT "FiveWin App"
      GET cMsg   SECTION "main" ENTRY "Message" OF oIni DEFAULT "Main message"

      GET cLogo   SECTION "Logo" ENTRY "File"    OF oIni
      GET nRow    SECTION "Logo" ENTRY "Row"     OF oIni
      GET nCol    SECTION "Logo" ENTRY "Col"     OF oIni
      GET nWidth  SECTION "Logo" ENTRY "Width"   OF oIni
      GET nHeight SECTION "Logo" ENTRY "Height"  OF oIni

      GET cBtn1   SECTION "ButtonBar" ENTRY "Button1" OF oIni
      GET cBtn2   SECTION "ButtonBar" ENTRY "Button2" OF oIni
   ENDINI

   DEFINE WINDOW oWnd FROM 1, 5 TO 20, 60 ;
      TITLE cTitle

   DEFINE BUTTONBAR oBar OF oWnd

   if ! Empty( cBtn1 )
      DEFINE BUTTON OF oBar FILE cBtn1
   endif
   if ! Empty( cBtn2 )
      DEFINE BUTTON OF oBar FILE cBtn2
   endif

   SET MESSAGE OF oWnd TO cMsg

   @ nRow, nCol BITMAP FILE cLogo SIZE nWidth, nHeight OF oWnd

   ACTIVATE WINDOW oWnd

return

//----------------------------------------------------------------------------//
