// Examples of using different Font on the Window

//----------------------------------------------------------------------------//
//  FiveWin 1.4 - Ejemplos
//  (c) A.Linares, F.Pulpn 1993-4
//
//  Construir con BUILD TestFont
//
//----------------------------------------------------------------------------//

// Ejemplos de utilizacin de distintos Fonts en pantalla
// Como estamos utilizando controles para dibujar, no se borrarn al
// redibujar la ventana principal

// Examples of using different Font on the Window
// As we are using controls to draw, the won't be deleted
// when we repaint the main Window

// En este ejercicio estamos tambien combinando, por primera vez, la
// capacidad de inicializar ventanas antes de ser mostradas ( Clasula ON INIT )

// In this exercise we are showing how to init Windows
// before beeing showed ( Clause ON INIT )

// Observa que en este ejercicio no hemos llegado a crear un men principal,
// y estamos situando controles en la ventana principal. Aunque esto ltimo
// no es una practica aconsejable, en determinados casos puede ser muy
// prctico

// Observe that in this exercise we have not created a main menu,
// and we are placing controls on the main Window. This techniques are
// not recommended, but in same situations might be very usefull.

#include "FiveWin.ch"

static oWnd, fntArial, fntRoman

//----------------------------------------------------------------------------//

function Main()

   DEFINE WINDOW oWnd FROM 1, 1 TO 20, 80 ;
      TITLE "Probando Fonts en Pantalla"

   DEFINE FONT fntArial NAME "Arial" SIZE 20, 20
   DEFINE FONT fntRoman NAME "Roman" SIZE 10, 25

   SET MESSAGE OF oWnd ;
      TO OemToAnsi( "FiveWin 1.4 - (c) A.Linares & F.Pulpn, 1993-4" )

   ACTIVATE WINDOW oWnd MAXIMIZED ;
      ON INIT ShowControls( Self )

   RELEASE FONT fntArial, fntRoman

return

//----------------------------------------------------------------------------//

function ShowControls( Self )

   local lFiveWin := .t., lClipper5 := .t., lWindows := .t., lOOPS := .t.

   @ 2, 2 BUTTON "&OOPS" OF oWnd ;
      FONT fntArial ;
      ACTION ;
         MsgInfo( OemToAnsi( "Adquiere en Soft>Mail nuestra librera" + Chr( 13 ) + ;
                  "Objects para estudiar y comprender los" + Chr( 13 ) + ;
                  "fundamentos tericos del OOPS" + Chr( 13 ) + ;
                  "y su aplicacin prctica en Clipper 5." + Chr( 13 ) + Chr( 13 ) + ;
                  "No te quedes atrs.  El OOPS es formidable !" ) )

   @ 5, 2 SAY "Disfruta la potencia" OF oWnd FONT fntArial

   @ 6, 2 SAY OemToAnsi( "de la Programacin Orientada" ) ;
      OF oWnd FONT fntArial

   @ 7, 2 SAY "al Objeto" OF oWnd FONT fntArial

   // Observa que las coordenadas son proporcionales al FONT utilizado
   // Por defecto se utiliza el font de Windows

   @ 5, 5 CHECKBOX lFiveWin  PROMPT "FiveWin" SIZE 200, 30 ;
     OF oWnd FONT fntRoman

   @ 6, 8 CHECKBOX lClipper5 PROMPT "Es Clipper 5" SIZE 200, 30 ;
      OF oWnd FONT fntRoman

   @ 7, 8 CHECKBOX lWindows  PROMPT "en Windows" SIZE 200, 30 ;
      OF oWnd FONT fntRoman

   @ 8, 8 CHECKBOX lOOPS     PROMPT "y usando OOPS" SIZE 200, 30 ;
      OF oWnd FONT fntRoman

return

//----------------------------------------------------------------------------//
