// Using Borland's BiVbx10.dll VBX Controls support

#include "FiveWin.ch"
#include "Testbvbx.ch"

static oDlg, oVbx

//----------------------------------------------------------------------------//

function Main()

   local oName, oProperties, oEvents
   local oNProps, oNEvents

   SET 3DLOOK ON

   DEFINE DIALOG oDlg RESOURCE "Test" VBX

   REDEFINE VBX oVbx ID ID_VBX OF oDlg  ;
                COLOR "N/W"             ;
                ON ON  WQOut( { PCOUNT(), bP1 } ) ;
                ON OFF WQOut( { PCOUNT(), bP1 } )

   REDEFINE LISTBOX oProperties ;
      FIELDS "" ;
      HEADERS "Properties" ;
      ID ID_PROPERTIES OF oDlg

   REDEFINE LISTBOX oEvents ;
      FIELDS "" ;
      HEADERS "Events" ;
      ID ID_EVENTS OF oDlg

   REDEFINE SAY oName    PROMPT oVbx:GetName()    ID ID_NAME        OF oDlg
   REDEFINE SAY oNProps  PROMPT oVbx:nGetProps()  ID ID_NPROPERTIES OF oDlg
   REDEFINE SAY oNEvents PROMPT oVbx:nGetEvents() ID ID_NEVENTS     OF oDlg

   // REDEFINE BUTTON ID ID_LOAD OF oDlg ACTION LoadVbx()
   REDEFINE BUTTON ID ID_LOAD OF oDlg ;
                ACTION WQOut( oVbx:GetEnums( "DragMode" ) )

   ACTIVATE DIALOG oDlg CENTERED ;
      ON INIT ( oName:Refresh(), oNProps:Refresh(), oNEvents:Refresh(),;
                PropertiesInit( oProperties, oVbx ),;
                oEvents:SetArray( oVbx:aEventNames ) )

return nil

//---------------------------------------------------------------------------//

static function ParamInfo( pCount, cEvent, aParams )

    local aTest := array( 2 + pCount * 2 )
    local i, n := 1

    aTest[ n++ ] = pCount
    aTest[ n++ ] = cEvent

    for i = 1 to pCount
        aTest[ n++ ] = valtype( aParams[ i ] )
        aTest[ n++ ] = aParams[ i ]
    next

    WQOut( aTest )

return nil

//----------------------------------------------------------------------------//

function PropertiesInit( oProps, oVbx )

   oProps:nAt       = 1
   oProps:bLine     = { || { oVbx:GetPropName( oProps:nAt ),;
                             cValToChar( oVbx:GetProp( oProps:nAt ) ) } }
   oProps:bGoTop    = { || oProps:nAt := 1 }
   oProps:bGoBottom = { || oProps:nAt := oVbx:nGetProps() }
   oProps:bLogicLen = { || oVbx:nGetProps() }
   oProps:bSkip     = { | nSkip, nOld | nOld := oProps:nAt,;
                        oProps:nAt += nSkip,;
                        oProps:nAt := Min( Max( oProps:nAt, 1 ),;
                        Eval( oProps:bLogicLen ) ), oProps:nAt - nOld }

return nil

//----------------------------------------------------------------------------//

function LoadVbx( oDlg )

   local cVbxFile := cGetFile( "*.vbx", "Select a VBX" )

   if ! Empty( cVbxFile )
      oVbx:End()
      SysRefresh()
   endif

return nil

//----------------------------------------------------------------------------//
