// FiveWin IDE - Stack Inspector MDIChild Window

#include "FiveWin.ch"

static aObjBmps

//----------------------------------------------------------------------------//

function StackInspect()

   local oWndIns, oBrwVars, oBrwStk
   local nStkItem   := 1
   local nVarItem   := 1
   local aStackInfo := StackInfo() // {}
   local aVarInfo   := VarInfo( aStackInfo[ nStkItem ] ) // {}

   DEFAULT aObjBmps := GetObjBmps()

   DEFINE DIALOG oWndIns RESOURCE "FWSTACK"

   REDEFINE LISTBOX oBrwVars FIELDS ""  ID 101 ;
            HEADERS  "  ", "Scope", "VarName", "Type", "Value" ;
            FIELDSIZES 16,     70,         80,     35,     200 ;
            OF oWndIns ;
            ON DBLCLICK ObjInspect( DbgSetGet( aVarInfo[ nVarItem ][ 3 ] ),;
                                    aVarInfo[ nVarItem ][ 2 ] )

       oBrwVars:bLine = { || aVarLine( aVarInfo[ nVarItem ] ) }

       // Browsing an Array using FiveWin TWBrowse Object !

       oBrwVars:bGoTop    = { || nVarItem := 1 }
       oBrwVars:bGoBottom = { || nVarItem := Eval( oBrwVars:bLogicLen ) }

       oBrwVars:bSkip     = { | nWant, nOld | nOld := nVarItem, nVarItem += nWant,;
                            nVarItem := Max( 1, Min( nVarItem, Eval( oBrwVars:bLogicLen ) ) ),;
                            nVarItem - nOld }

       oBrwVars:bLogicLen = { || Len( aVarInfo ) }

       oBrwVars:cAlias    = "Array"  // We need a non empty cAlias !

   REDEFINE LISTBOX oBrwStk FIELDS "" ID 102 ;
            HEADERS  "  ", "Deep", "Proc/Func", "Line", "Module" ;
            FIELDSIZES 16,     35,         145,     35,      120 ;
            ON CHANGE ( aVarInfo   := VarInfo( aStackInfo[ nStkItem ] ), ;
                        oBrwVars:GoTop() ,;
                        oBrwVars:Refresh( .t. ) ) ;
            OF oWndIns

   oBrwStk:bLine = { || aStkLine( aStackInfo, nStkItem ) }

   // Browsing an Array using FiveWin a TWBrowse Object !

   oBrwStk:bGoTop    = { || nStkItem := 1 }
   oBrwStk:bGoBottom = { || nStkItem := Eval( oBrwStk:bLogicLen ) }

   oBrwStk:bSkip     = { | nWant, nOld | nOld := nStkItem, nStkItem += nWant,;
                        nStkItem := Max( 1, Min( nStkItem, Eval( oBrwStk:bLogicLen ) ) ),;
                        nStkItem - nOld }

   oBrwStk:bLogicLen = { || Len( aStackInfo ) }

   oBrwStk:cAlias    = "Array"  // We need a non empty cAlias !

   REDEFINE BUTTON ID 103 OF oWndIns ;
      ACTION ObjInspect( DbgSetGet( aVarInfo[ nVarItem ][ 3 ] ),;
                         aVarInfo[ nVarItem ][ 2 ] )

   ACTIVATE DIALOG oWndIns CENTERED ;
            ON INIT ( aStackInfo := StackInfo(),;
                      aVarInfo   := VarInfo( aStackInfo[ nStkItem ] ), .t. )
return nil

//---------------------------------------------------------------------------//

static function StackInfo()

    local aInfo := {}
    local aItem
    local cProc
    local i     := 0
    local nStkDeep

    while ! empty( cProc := ProcName( ++i ) ) .and. cProc != "STACKINSPE"
    end
    nStkDeep = i

    while ! Empty( cProc := ProcName( ++i ) )
        aItem := DbgAct( i )
        AAdd( aInfo, { i - nStkDeep, cProc, str( ProcLine( i ), 4 ),;
             If( Empty( aItem ), "", aItem[ 2 ] ) } )
    end

return aInfo

//----------------------------------------------------------------------------//

static function aStkLine( aStkInfo, nItem )

   local aInfo := aStkInfo[ nItem ]
   local n     := Len( aObjBmps )

return { If( !empty( aInfo[ 4 ] ), aObjBmps[ n - 1 ], aObjBmps[ n ] ),;
         Str( Len( aStkInfo ) - aInfo[ 1 ] + 1, 4 ), ;
         aInfo[ 2 ], xPadL( aInfo[ 3 ], 40 ), aInfo[ 4 ]  }

//----------------------------------------------------------------------------//

static function VarInfo( aStkPosInfo )

    local cProc
    local nStkDeep := 0

    while ! Empty( cProc := ProcName( ++nStkDeep ) ) ;
          .and. cProc != "STACKINSPE"
    end

return DbgVarInfo( aStkPosInfo[ 1 ] + nStkDeep, 31 )

//---------------------------------------------------------------------------//

static function aVarLine( aVarInfo )

    local cScope := ""
    local cType  := DbgValType( aVarInfo[ 3 ] )

    do case
        case aVarInfo[ 1 ] == 1
            cScope = "BlockLocal"

        case aVarInfo[ 1 ] == 2
            cScope = "Local"

        case aVarInfo[ 1 ] == 4
            cScope = "Static"

        case aVarInfo[ 1 ] == 8
            cScope = "Private"

        case aVarInfo[ 1 ] == 16
            cScope = "Public"
    endcase

return { aObjBmps[ At( cType, "ABCDLNMOU" ) ], cScope,;
         cChr2Data( aVarInfo[ 2 ] ), "< " + cType + " >",;
         DbgValToStr( aVarInfo[ 3 ] ) }

//---------------------------------------------------------------------------//
