// FiveWin - RTF (Rich Text format) Class
// FiveWin Documentation tools

#include "FiveWin.ch"

//----------------------------------------------------------------------------//

CLASS TRtfFile

   DATA    hFile
   DATA    aBitmaps
   DATA    cFileName

   METHOD  New( cFileName ) CONSTRUCTOR

   METHOD  WriteShort( cShort, cJumpTo, lPopup, cBitmap )

   METHOD  WriteLong( cLong )

   METHOD  WriteId( cIdentifier ) INLINE ;
                    FWrite( ::hFile, "#{\footnote " + cIdentifier + "}" + ;
                            CRLF +  "\par\pard" + CRLF )

   METHOD  WriteSeeAlso( cSeeAlsoList ) INLINE ;
                       FWrite( ::hFile, "!seealso:" + cSeeAlsoList + CRLF )

   METHOD  NewPage() INLINE FWrite( ::hFile, "\page" + CRLF )

   METHOD  End()

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( cFileName ) CLASS TRtf

   ::cFileName = cFileName
   ::hFile     = FCreate( cFileName )
   ::aBitmaps  = {}

   FWrite( ::hFile, "{\rtf1\ansi \deff0" + CRLF + ;
                    "{\fonttbl" + CRLF + ;
                    "{\f0\fmodern Courier New;}" + CRLF + ;
                    "{\f1\fdecor  Courier New;}" + CRLF + ;
                    "{\f2\fswiss  Arial;}}" + CRLF + ;
                    "{\colortbl;" + CRLF + ;
                    "\red0\green0\blue0;" + CRLF + ;
                    "\red0\green0\blue255;" + CRLF + ;
                    "\red0\green255\blue255;" + CRLF + ;
                    "\red0\green255\blue0;" + CRLF + ;
                    "\red255\green0\blue255;" + CRLF + ;
                    "\red255\green0\blue0;" + CRLF + ;
                    "\red255\green255\blue0;" + CRLF + ;
                    "\red255\green255\blue255;}" + CRLF + ;
                    "\f2\fs20" + CRLF )

return nil

//----------------------------------------------------------------------------//

METHOD WriteLong( cLong ) CLASS TRtfFile

   local nLines := MlCount( cLong )
   local cLine, cChar
   local n, nChar

   for n = 1 to nLines
      cLine = MemoLine( cLong,, n ) + "\line"

      for nChar = 1 to Len( cLine )
          if Asc( cChar := SubStr( cLine, nChar, 1 ) ) > 127
             FWrite( ::hFile, "\'" + C2Hex( cChar ) )
          else
             FWrite( ::hFile, cChar )
          endif
      next
   next
   FWrite( ::hFile, CRLF )

return nil

//----------------------------------------------------------------------------//

METHOD WriteShort( cShort, cJumpTo, lPopup, cBitmap ) CLASS TRtfFile

   local cBuffer := "\b\tab"
   local cChar
   local n, nChar

   DEFAULT cJumpTo := "", lPopup := .f.

   if ! Empty( cBitmap )
      cBuffer += If( lPopup, "{\ul", "{\uldb" ) + "\{bmc " + ;
                 AllTrim( cNoPath( cBitmap ) ) + "\}}\b\tab"
      AAdd( ::aBitmaps, cBitmap )
   endif

   cBuffer += If( lPopup, "{\ul ", "{\uldb " ) + ;
              AllTrim( cShort ) + "}{\v " + cJumpTo + ;
              "}\par\pard" + CRLF

   for nChar = 1 to Len( cBuffer )
       if Asc( cChar := SubStr( cBuffer, nChar, 1 ) ) > 127
          FWrite( ::hFile, "\'" + C2Hex( cChar ) )
       else
          FWrite( ::hFile, cChar )
       endif
   next

return nil

//----------------------------------------------------------------------------//

METHOD End() CLASS TRtfFile

   local hHpj
   local n

   FWrite( ::hFile, "}" )
   FClose( ::hFile )

   hHpj = FCreate( cNoExt( ::cFileName ) + ".hpj" )

   FWrite( hHpj, "[files]" + CRLF )
   FWrite( hHpj, cNoPath( ::cFileName ) + CRLF + CRLF )

   FWrite( hHpj, "[bitmaps]" + CRLF )

   for n = 1 to Len( ::aBitmaps )
      FWrite( hHpj, ::aBitmaps[ n ] + CRLF )
   next
   FClose( hHpj )

return nil

//----------------------------------------------------------------------------//
