#include "FiveWin.ch"

//----------------------------------------------------------------------------//

function Relations( cAlias )

  local oWndRel, oBar, oBrw, oIco, oFont
  local nRel   := 1, cRelAlias
  local hBmpThis := LoadBitmap( GetResources(), "This" )

  DEFAULT cAlias := Alias()

  DEFINE FONT oFont NAME "Arial" SIZE 6, 15 BOLD

  DEFINE ICON oIco RESOURCE "Relation"

  DEFINE WINDOW oWndRel FROM 2, 1 TO 15, 50 ;
     TITLE "Relations: " + cAlias ICON oIco MDICHILD

  DEFINE BUTTONBAR oBar OF oWndRel

  DEFINE BUTTON RESOURCE "New" OF oBar ;
     MESSAGE "Set a new relation"

  DEFINE BUTTON RESOURCE "Edit" OF oBar ;
     MESSAGE "Modify this relation"

  DEFINE BUTTON RESOURCE "Del" OF oBar ;
     MESSAGE "Cancel this relation"

  @ 6, 127 SAY "WorkAreas:" PIXEL SIZE 120, 20 OF oBar ;
     FONT oFont COLOR "W+/N*"

  @ 3, 200 COMBOBOX cAlias ITEMS aGetWorkAreas() ;
     SIZE 100, 120 PIXEL OF oBar ;
     COLOR "N/W" FONT oFont ;
     ON CHANGE ( oWndRel:cTitle := "Relations: " + cAlias,;
                 oBrw:Refresh(), oBrw:SetFocus() )

  @ 0, 0 LISTBOX oBrw FIELDS "" ;
     FIELDSIZES 25, 200, 200 ;
     HEADERS "Rel", "Expression", "Target Workarea" ;
     OF oWndRel FONT oFont ;
     SIZE 500, 500

  oBrw:bLine = { || If( Select( cAlias ) != 0,;
                   { xPadL( cValToChar( nRel ), 20 ),;
                     ( cAlias )->( DbRelation( nRel ) ),;
                     If( ( cRelAlias := Alias( ( cAlias )->( DbRSelect( nRel ) ) ) ) != ;
                         Alias(), cRelAlias, "" ) },;
                   { "", "", "" } ) }
  oBrw:bGoTop    = { || nRel := 1 }
  oBrw:bGoBottom = { || nRel := 8 }
  oBrw:bLogicLen = { || 8 }
  oBrw:bSkip     = { | nSkip, nDo | nDo := nRel, nRel += nSkip,;
                       nRel := Max( 1, Min( nRel, 8 ) ),;
                       nRel - nDo }

  oWndRel:SetControl( oBrw )

  ACTIVATE WINDOW oWndRel ;
     VALID ( DeleteObject( hBmpThis ), .t. )

return nil

//----------------------------------------------------------------------------//
