// FiveWin Project management
// FiveWin visual-make tools

#include "FiveWin.ch"

static aPrjBmps
static nTemp := 50

//----------------------------------------------------------------------------//

function PrjNew()

   local cPrjName := cGetNewFileName( "PROJECT", "prj" )

   if ! File( cPrjName )
      DbCreate( cPrjName, { { "TYPE",     "N",  2, 0 },;
                            { "NAME",     "C", 50, 0 },;
                            { "DESCRIPT", "C", 50, 0 } } )
   endif

   PrjOpen( cPrjName )

return nil

//----------------------------------------------------------------------------//

function PrjOpen( cPrjName )

   local oIco, oWndPrj, oBrw, oBar, oFont, oHand, oWndAreas := GetWndAreas()
   local cNtxName, cAlias
   local nType
   FIELD Type, Name, Descript

   DEFAULT cPrjName := cGetFile( "FiveWin IDE Project ( *.prj ) | *.prj",;
                                 "Select a Project" ),;
           aPrjBmps := GetPrjBmps()

   if ! File( cPrjName )
      MsgStop( "I can't find " + cPrjName )
      return nil
   endif

   if ! Empty( cPrjName )
      USE ( cPrjName ) NEW SHARED
      If RecCount() == 0
         APPEND BLANK
         Type     := 0
         Name     := "UnDefined"
         Descript := "No description available"
      endif
      cNtxName = cNoExt( cPrjName )
      INDEX ON Type TO ( cNtxName )
      SET INDEX TO ( cNtxName )
   else
      return nil
   endif

   cAlias = Alias()

   DEFINE ICON oIco RESOURCE "Project"

   DEFINE WINDOW oWndPrj FROM 1, 35 TO 23, 79 ;
      TITLE "Project: " + cNoPath( cNoExt( cPrjName ) ) MDICHILD ;
      ICON oIco

   DEFINE FONT oFont NAME "Arial" SIZE 6, 15 BOLD

   DEFINE CURSOR oHand RESOURCE "Hand"

   @  0, 0 LISTBOX oBrw ;
      FIELDS aPrjBmps[ Min( Max( ( cAlias )->Type + 1, 1 ),;
                            Len( aPrjBmps ) ) ],;
                       Upper( cNoPath( ( cAlias )->Name ) ),;
                       ( cAlias )->Descript ;
      FIELDSIZES 16, 110, 500 ;
      HEADERS " ", "Name", "Description" ;
      OF oWndPrj ;
      ON DBLCLICK ItemOpen( oBrw ) ;
      ON CHANGE If( oWndAreas != nil, oWndAreas:oControl:Refresh(),) ;
      FONT oFont CURSOR oHand ;
      SIZE 400, 400 ;
      MESSAGE "Visual make of all the project elements"

   DEFINE BUTTONBAR oBar OF oWndPrj

   DEFINE BUTTON OF oBar RESOURCE "New" ;
      ACTION oBrw:RecAdd() ;
      MESSAGE "Add a new item to the project"

   DEFINE BUTTON OF oBar RESOURCE "Edit" ;
      ACTION ItemNew( oBrw ) ;
      MESSAGE "Edit the current project item"

   DEFINE BUTTON OF oBar RESOURCE "Del" ;
      MESSAGE "Delete the current project item" ;
      ACTION ItemDel( oBrw )

   DEFINE BUTTON OF oBar RESOURCE "InspSma" ;
      ACTION ItemOpen( oBrw ) ;
      MESSAGE "Inspect the current project item"

   DEFINE BUTTON RESOURCE "Font" GROUP OF oBar ACTION oBrw:SelFont() ;
      MESSAGE "Selects a different font and Text Color"

   DEFINE BUTTON RESOURCE "Clr" OF oBar ACTION oBrw:SelColor() ;
      MESSAGE "Selects the Background Color"

   oWndPrj:SetControl( oBrw )

   ACTIVATE WINDOW oWndPrj ;
      VALID If( MsgYesNo( "Close project ?" ), oBrw:lCloseArea(), .f. )

   if oWndAreas != nil
      oWndAreas:oControl:Refresh()  // We updates the info on the WorkAreas
   endif                            // inspector

return nil

//----------------------------------------------------------------------------//
