#include "FiveWin.ch"

#define COLOR_BTNFACE   15
#define COLOR_BTNSHADOW 16

static lRegistered := .f.

//----------------------------------------------------------------------------//

CLASS TMsgBar FROM TWindow

   DATA   cMsgDef
   DATA   lCentered

   METHOD New( oWnd, cPrompt, lCentered ) CONSTRUCTOR
   METHOD Adjust()
                                                               // erase
   METHOD Paint() INLINE MsgPaint( ::hWnd, ::cMsg, ::cMsgDef, .t.,;
                                   ::lCentered )

   METHOD SetMsg( cText )


ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( oWnd, cPrompt, lCentered ) CLASS TMsgBar

   local oRect := oWnd:GetCliRect()

   DEFAULT cPrompt := "", lCentered := .f.

   ::nClrPane    = COLOR_BTNFACE + 1
   ::oWnd        = oWnd
   ::cMsg := ::cMsgDef  := cPrompt
   ::nStyle      = nOR( WS_VISIBLE, WS_CHILD, WS_OVERLAPPED, WS_BORDER )
   ::nLeft       = -1
   ::nTop        = oRect:nBottom - 25
   ::nBottom     = oRect:nBottom
   ::nRight      = oRect:nRight  + 1
   ::oBrush      = TBrush():New( , nRGB( 192, 192, 192 ), )
   ::lCentered   = lCentered
   ::lValidating = .f.

   if ! lRegistered
      ::Register()
      lRegistered = .t.
   endif

   ::Create()

return nil

//----------------------------------------------------------------------------//

METHOD Adjust() CLASS TMsgBar

   local rctParent := ::oWnd:GetCliRect()

   ::SetCoors( TRect():New( rctParent:nBottom - 25, rctParent:nLeft - 1,;
                            rctParent:nBottom, rctParent:nRight ) )
return nil

//----------------------------------------------------------------------------//

METHOD SetMsg( cText ) CLASS TMsgBar

   DEFAULT ::cMsg := ""

   if Empty( cText )
      if ! Empty( ::cMsg )
         MsgPaint( ::hWnd, ::cMsg := "", ::cMsgDef, .f., ::lCentered )
      endif
   else
      if ::cMsg != cText
         MsgPaint( ::hWnd, ::cMsg := cText, ::cMsgDef, .f., ::lCentered )
      endif
   endif

return nil

//----------------------------------------------------------------------------//
