#include "FiveWin.ch"

static oWnd,hBorland 
static oBrw,aDispos
static aMciDev,oBrw2

Function Main()
   Local cBuffer:=Space(200),xValor,aDisp[7]
   Local cBuffer2:=Space(200),nVolR:=0,nVolL:=0,nVol:=0
   Local aDev:={0,0,0,Space(32),0,0},nA
   Local nMciDev,oBrush,nDisp,nMci
   
   aDispos:={}
   aMciDev:={}

   DEFINE BRUSH oBrush STYLE TILED

   DEFINE WINDOW oWnd FROM 1,1 TO 30,88 ;
         TITLE "CONTROL MULTIMEDIA" ;
         BRUSH oBrush ;
         MENU BuildMenu()

	hBorland := LoadLibrary( "BWCC.DLL" )     // Loading Borland's dll
   SET RESOURCES TO "MMEDIA.DLL"           // Our stored screens

   SET 3DLOOK ON   

   mciSendStr("SYSINFO ALL QUANTITY",@cBuffer,oWnd:hWnd)   
   nMciDev=Val(cBuffer)
   For nA:= 1 To nMciDev
      mciSendStr("SYSINFO ALL NAME "+lTrim(Str(nA)),@cBuffer,oWnd:hWnd)   
      AADD(aMciDev,{xPadL( lTrim(Str(nA)),30),Left(cBuffer,15),"","",""} )

      mciSendStr("CAPABILITY "+Upper(AllTrim(aMciDev[nA,2]))+" DEVICE TYPE",@cBuffer,oWnd:hWnd)
      aMciDev[nA,3]=Left(cBuffer,15)

      mciSendStr("SYSINFO "+Upper(AllTrim(aMciDev[nA,2]))+" QUANTITY",@cBuffer,oWnd:hWnd)
      aMciDev[nA,4]=Trim(cBuffer)

      mciSendStr("SYSINFO "+Upper(AllTrim(aMciDev[nA,2]))+" QUANTITY OPEN",@cBuffer,oWnd:hWnd)
      aMciDev[nA,5]=Trim(cBuffer)
   Next nA



   For nA:= 0 To AUXGETDEV()-1

      AUXGETCAPS(nA,@aDev)
      AuxGetVol(nA,@nVolL,@nVolR)

      AADD(aDispos,{xPadL( lTrim(Str(nA)),30),xPadL( lTrim(Str(aDev[1])),30 ),xPadL( lTrim(Str(aDev[2])),30 ),;
                   xPadL( lTrim(Str(aDev[3])),30 ),xPadR( "  "+Left(aDev[4],20),200),;
                   xPadL( lTrim(Str(aDev[5])),30 ),xPadL( lTrim(Str(aDev[6])),30 ),;
                   xPadL( lTrim(Str(nVolL  )),60 ),xPadL( lTrim(Str(nVolR  )),60 )}  )
   Next nA   

   if Len( aDispos ) == 0
      AAdd( aDispos, { "", "", "", "", "", "", "", "", "" } )
   endif

   nDisp=1
   @11,24 SAY " AUXILIARY DEVICES WITH VOLUMEN CONTROL : " BORDER PIXELS COLOR "R+/W" SIZE 360,18
   @ 2, 3 LISTBOX oBrw FIELDS aDispos[nDisp,1],aDispos[nDisp,2],;
                            aDispos[nDisp,3],aDispos[nDisp,4],;
                            aDispos[nDisp,5],aDispos[nDisp,6],;
                            aDispos[nDisp,7],aDispos[nDisp,8],;
                            aDispos[nDisp,9] ;
                            FIELDSIZES 40, 40, 40, 40, 210, 40, 40, 70, 70 ;
                            HEADERS "DISP.","M.Id.","P.Id.","Ver","Name","Tech.","V.Supp","Lft. Vol.","Rght. Vol." ;
                            OF oWnd SIZE 620,200

   // Some blocks for management the browse array

   oBrw:bLogicLen = { || Len( aDispos ) }

   oBrw:bGoTop    = { || nDisp := 1 }
   oBrw:bGoBottom = { || nDisp := Len( aDispos ) }
   oBrw:bSkip     = { | nWant, nDo | ;
                      nDo := Min( Max( nWant, 1 - nDisp ), ;
                      Len( aDispos ) - nDisp ), ;
                      nDisp += nDo, nDo }


   nMci=1
   @19,20 SAY " MCI DEVICES INSTALLED :"  BORDER COLOR "R+/W" SIZE 200,18
   @19,20 LISTBOX oBrw2 FIELDS aMciDev[nMci,1],aMciDev[nMci,2],;
                              aMciDev[nMci,3],aMciDev[nMci,4], ;
                              aMciDev[nMci,5] ;
                              FIELDSIZES 40, 100, 100, 20,20  ;
                              HEADERS "DISP.","Name","I.Name","N","Op." ;
                              OF oWnd SIZE 320,150

   // Some blocks for management the browse array

   oBrw2:bLogicLen = { || Len( aMciDev ) }

   oBrw2:bGoTop    = { || nMci := 1 }
   oBrw2:bGoBottom = { || nMci := Len( aMciDev ) }
   oBrw2:bSkip     = { | nWant, nDo | ;
                      nDo := Min( Max( nWant, 1 - nMci ), ;
                      Len( aMciDev ) - nMci ), ;
                      nMci += nDo, nDo }

	ACTIVATE WINDOW oWnd

   SET RESOURCES TO

   FreeLibrary( hBorland )                // We have finish with it

   Return nil


Function BuildMenu()
   local oMenu

   MENU oMenu
      MENUITEM "&Control CD" ;
                ACTION (CdAudio(),ActuVol(@aDispos),oBrw:Refresh() )
      MENUITEM "&Control Wave" ;
                ACTION (WaveAudio(),ActuVol(@aDispos),oBrw:Refresh() )
      MENUITEM "&Control AviVideo" ;
                ACTION (AviVideo(),ActuVol(@aDispos),oBrw:Refresh() )
      MENUITEM "&Control MIDI" ;
                ACTION (Sequencer(),ActuVol(@aDispos),oBrw:Refresh() )
      MENUITEM "&Salir" ACTION If( MsgYesNo( OemToAnsi( " Desea terminar la Ejecucin ?" ), ;
                                             "Seleccione, por favor" ), ;
                                   oWnd:End,)
   ENDMENU

return oMenu

Function ActuVol(aDispos)
   Local nA,nVolL:=0,nVolR:=0

   For nA=1 To AUXGETDEV()
      AuxGetVol(nA-1,@nVolL,@nVolR)
      aDispos[nA,8]=xPadL( lTrim(Str(nVolL  )),60 )
      aDispos[nA,9]=xPadL( lTrim(Str(nVolR  )),60 )
   Next nA
   Return nil


Function CdAudio()
   Local cPrompt     // Declared to avoid array range error. See FOR loop
   Local oDlg,lMute,lLeft,lRight,lOpen
   Local oPLay,oStop,oAvTrack,oReTrack,oOpenClose,oSalir
   Local oT1,oT2,oT3,oT4,oT5,oT6,oT7,oT8,oT9,oT10
   Local oL1,oL2,oL3,oL4,oL5,oL6,oL7,oL8,l1,l2,l3,l4,l5,l6,l7,l8
   Local cBuffer:=Space(200),oSBRight,oSBLeft,nVolR:=0,nVolL:=0
   Local oTextLV,oTextRV
   Local oTimer,oTracks[25]
   Local aoStat[10],acStat[10]
   Local nA,oFile,oType

   DEFINE DIALOG oDlg RESOURCE "CDAUDIO"
   
   mciSendStr("OPEN CDAUDIO",@cBuffer,oDlg:hWnd)
   mciSendStr("SET CDAUDIO TIME FORMAT TMSF",@cBuffer,oDlg:hWnd)
   
	DEFINE TIMER oTimer INTERVAL 2000 ACTION (GetStat(@acStat,@oDlg),RefreshStat(@aoStat,@acStat))

   mciSendStr("CAPABILITY CDAUDIO CAN EJECT"      ,@cBuffer,oDlg:hWnd)
   l1 :=  cBuffer=="verdadero"
   mciSendStr("CAPABILITY CDAUDIO CAN PLAY"       ,@cBuffer,oDlg:hWnd)  
   l2 := cBuffer=="verdadero"
   mciSendStr("CAPABILITY CDAUDIO CAN RECORD"     ,@cBuffer,oDlg:hWnd)
   l3 := cBuffer=="verdadero"
   mciSendStr("CAPABILITY CDAUDIO CAN SAVE"       ,@cBuffer,oDlg:hWnd)
   l4 := cBuffer=="verdadero"
   mciSendStr("CAPABILITY CDAUDIO COMPOUND DEVICE",@cBuffer,oDlg:hWnd)
   l5 := cBuffer=="verdadero"
   mciSendStr("CAPABILITY CDAUDIO HAS AUDIO"      ,@cBuffer,oDlg:hWnd)
   l6 := cBuffer=="verdadero"
   mciSendStr("CAPABILITY CDAUDIO HAS VIDEO"      ,@cBuffer,oDlg:hWnd)
   l7 := cBuffer=="verdadero"
   mciSendStr("CAPABILITY CDAUDIO USES FILES"      ,@cBuffer,oDlg:hWnd)
   l8 := cBuffer=="verdadero"

   REDEFINE BUTTON oPlay      ID 103 OF oDlg ACTION mciSendStr("PLAY CDAUDIO",@cBuffer,oDlg:hWnd)
   REDEFINE BUTTON oStop      ID 109 OF oDlg ACTION mciSendStr("STOP CDAUDIO",@cBuffer,oDlg:hWnd)
   REDEFINE BUTTON oAvTrack   ID 101 OF oDlg ACTION ( AvPista(@oDlg),mciSendStr("PLAY CDAUDIO",@cBuffer,oDlg:hWnd) )
   REDEFINE BUTTON oReTrack   ID 106 OF oDlg ACTION ( RePista(@oDlg),mciSendStr("PLAY CDAUDIO",@cBuffer,oDlg:hWnd) )
   REDEFINE BUTTON oOpenClose ID 107 OF oDlg ACTION OpenClose(@oDlg)
   REDEFINE BUTTON oSalir     ID 115 OF oDlg ACTION ( mciSendStr("STOP CDAUDIO",@cBuffer,oDlg:hWnd),mciSendStr("CLOSE CDAUDIO",@cBuffer,oDlg:hWnd),oDlg:End() )

   REDEFINE CHECKBOX oL1 VAR l1 ID 150 OF oDlg
   REDEFINE CHECKBOX oL2 VAR l2 ID 151 OF oDlg
   REDEFINE CHECKBOX oL3 VAR l3 ID 152 OF oDlg
   REDEFINE CHECKBOX oL4 VAR l4 ID 153 OF oDlg
   REDEFINE CHECKBOX oL5 VAR l5 ID 154 OF oDlg
   REDEFINE CHECKBOX oL6 VAR l6 ID 155 OF oDlg
   REDEFINE CHECKBOX oL7 VAR l7 ID 156 OF oDlg
   REDEFINE CHECKBOX oL8 VAR l8 ID 157 OF oDlg

   mciSendStr("CAPABILITY CDAUDIO DEVICE TYPE"      ,@cBuffer,oDlg:hWnd)
   REDEFINE SAY oType PROMPT UPPER(cBuffer) ID 170 OF oDlg

   AuxGetVol(5,@nVolL,@nVolR)
   REDEFINE SAY oTextLV PROMPT Str(nVolR) ID 122 OF oDlg
   REDEFINE SAY oTextRV PROMPT Str(nVolR) ID 123 OF oDlg

   GetStat(@acStat,@oDlg)
   For nA=1 TO LEN(aoStat)
      cPrompt := acStat[nA]
      REDEFINE SAY aoStat[nA] PROMPT cPrompt ID 160+(nA-1) OF oDlg
   Next nA

   REDEFINE SCROLLBAR oSBRight ID 130 RANGE 0,32 ;
    ON UP   (AuxGetVol(5,@nVolL,@nVolR),;
             AuxSetVol(5,if(nVolL<63000,nVolL+2047,nVolL),nVolR),;
             AuxGetVol(5,@nVolL,@nVolR),;
             oTextLV:SetText(Str(nVolL)),oTextRV:SetText(Str(nVolR)) ) ;
    ON DOWN (AuxGetVol(5,@nVolL,@nVolR),;
             AuxSetVol(5,if(nVolL>2047,nVolL-2047,nVolL),nVolR),;
             AuxGetVol(5,@nVolL,@nVolR),;
             oTextLV:SetText(Str(nVolL)),oTextRV:SetText(Str(nVolR)) )  OF oDlg

   REDEFINE SCROLLBAR oSBLeft  ID 131 RANGE 0,32 ;
    ON UP  (AuxGetVol(5,@nVolL,@nVolR),;
            AuxSetVol(5,nVolL,if(nVolR<63000,nVolR+2040,nVolR)),;
            AuxGetVol(5,@nVolL,@nVolR),;
            oTextLV:SetText(Str(nVolL)),oTextRV:SetText(Str(nVolR)) ) ;
    ON DOWN (AuxGetVol(5,@nVolL,@nVolR),;
             AuxSetVol(5,nVolL,if(nVolR>2047,nVolR-2040,nVolR)),;
             AuxGetVol(5,@nVolL,@nVolR),;
             oTextLV:SetText(Str(nVolL)),oTextRV:SetText(Str(nVolR)) ) OF oDlg

   // Botones de Acceso Directo a las Pistas.

   REDEFINE BUTTON oTracks[ 1] ID 201 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 1",@cBuffer,oDlg:hWnd)
   REDEFINE BUTTON oTracks[ 2] ID 202 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 2",@cBuffer,oDlg:hWnd) 
   REDEFINE BUTTON oTracks[ 3] ID 203 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 3",@cBuffer,oDlg:hWnd)
   REDEFINE BUTTON oTracks[ 4] ID 204 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 4",@cBuffer,oDlg:hWnd) 
   REDEFINE BUTTON oTracks[ 5] ID 205 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 5",@cBuffer,oDlg:hWnd) 
   REDEFINE BUTTON oTracks[ 6] ID 206 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 6",@cBuffer,oDlg:hWnd)
   REDEFINE BUTTON oTracks[ 7] ID 207 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 7",@cBuffer,oDlg:hWnd) 
   REDEFINE BUTTON oTracks[ 8] ID 208 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 8",@cBuffer,oDlg:hWnd)
   REDEFINE BUTTON oTracks[ 9] ID 209 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 9",@cBuffer,oDlg:hWnd) 
   REDEFINE BUTTON oTracks[10] ID 210 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 10",@cBuffer,oDlg:hWnd) 
   REDEFINE BUTTON oTracks[11] ID 211 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 11",@cBuffer,oDlg:hWnd)
   REDEFINE BUTTON oTracks[12] ID 212 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 12",@cBuffer,oDlg:hWnd) 
   REDEFINE BUTTON oTracks[13] ID 213 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 13",@cBuffer,oDlg:hWnd)
   REDEFINE BUTTON oTracks[14] ID 214 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 14",@cBuffer,oDlg:hWnd) 
   REDEFINE BUTTON oTracks[15] ID 215 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 15",@cBuffer,oDlg:hWnd) 
   REDEFINE BUTTON oTracks[16] ID 216 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 16",@cBuffer,oDlg:hWnd)
   REDEFINE BUTTON oTracks[17] ID 217 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 17",@cBuffer,oDlg:hWnd) 
   REDEFINE BUTTON oTracks[18] ID 218 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 18",@cBuffer,oDlg:hWnd)
   REDEFINE BUTTON oTracks[19] ID 219 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 19",@cBuffer,oDlg:hWnd) 
   REDEFINE BUTTON oTracks[20] ID 220 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 20",@cBuffer,oDlg:hWnd) 
   REDEFINE BUTTON oTracks[21] ID 221 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 21",@cBuffer,oDlg:hWnd)
   REDEFINE BUTTON oTracks[22] ID 222 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 22",@cBuffer,oDlg:hWnd) 
   REDEFINE BUTTON oTracks[23] ID 223 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 23",@cBuffer,oDlg:hWnd)
   REDEFINE BUTTON oTracks[24] ID 224 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 24",@cBuffer,oDlg:hWnd) 
   REDEFINE BUTTON oTracks[25] ID 225 OF oDlg ACTION mciSendStr("PLAY CDAUDIO FROM 25",@cBuffer,oDlg:hWnd) 

   ACTIVATE DIALOG oDlg ON INIT (oSBLeft:SetPos(nVolL/2047)==oSBRight:SetPos(nVolR/2047),oTimer:Activate()==Nil)

   RELEASE TIMER oTimer   

   RETURN Nil

Function GetStat(acStat,oDlg)
   Local cBuffer:=Space(200),aMessages:={"STATUS CDAUDIO MODE",;
                                         "STATUS CDAUDIO CURRENT TRACK",;
                                         "STATUS CDAUDIO LENGTH",;
                                         "STATUS CDAUDIO LENGTH TRACK",;
                                         "STATUS CDAUDIO TIME FORMAT",;
                                         "STATUS CDAUDIO START POSITION",;
                                         "STATUS CDAUDIO MEDIA PRESENT",;
                                         "STATUS CDAUDIO NUMBER OF TRACKS",;
                                         "STATUS CDAUDIO POSITION",;
                                         "STATUS CDAUDIO READY"}
   Local nA,cActTrack

   For nA=1 TO Len(aMessages)
      mciSendStr(aMessages[nA]+If(nA=4,cActTrack,"" ),@cBuffer,oDlg:hWnd)
      Do Case
         Case nA=3 .or. nA=4
            acStat[nA]=Left(Upper(trim(cBuffer)),5)
         Case nA=6 .or. nA=9
            acStat[nA]=Left(Upper(trim(cBuffer)),8)
         OtherWise
            acStat[nA]=Upper(trim(cBuffer))
      EndCase

      If nA=2
         cActTrack=" "+lTrim(Str(Val(cBuffer)))
      Endif
   Next nA
   Return nil

Function RefreshStat(aoStat,acStat)
   Local nA
   
   For nA=1 to Len(aoStat)
      aoStat[nA]:SetText(acStat[nA])
   Next nA
   Return nil


Function ActPista(oDlg)
   Local nActPista,cBuffer:=Space(200)

   mciSendStr("STATUS CDAUDIO CURRENT TRACK",@cBuffer,oDlg:hWnd)
   nActPista=Val(cBuffer)

   Return "TRACK : "+Ltrim(Str(nActPista))


Function OpenClose(oDlg)
   Local cStatus,cBuffer:=Space(200)

   mciSendStr("STATUS CDAUDIO MODE",@cBuffer,oDlg:hWnd)

   If Upper(cBuffer)="ABIERTO" //.or. Empty(Upper(cBuffer))
      mciSendStr("SET CDAUDIO DOOR CLOSED",@cBuffer,oDlg:hWnd)
   Else
      mciSendStr("SET CDAUDIO DOOR OPEN",@cBuffer,oDlg:hWnd)
   Endif
  
   Return nil


Function AvPista(oDlg)
   Local nActPista,cBuffer:=Space(200)

   mciSendStr("STATUS CDAUDIO CURRENT TRACK",@cBuffer,oDlg:hWnd)
   nActPista=Val(cBuffer)

   mciSendStr("SEEK CDAUDIO TO "+ltrim(Str(nActPista+1)),@cBuffer,oDlg:hWnd)
  
   Return nil

Function RePista(oDlg)
   Local nActPista,cBuffer:=Space(200)

   mciSendStr("STATUS CDAUDIO CURRENT TRACK",@cBuffer,oDlg:hWnd)
   nActPista=Val(cBuffer)

   mciSendStr("SEEK CDAUDIO TO "+ltrim(Str(nActPista-1)),@cBuffer,oDlg:hWnd)
   
   Return nil
