#include "FiveWin.ch"
#include "Constant.ch"
#include "Set.ch"

#define EM_GETSEL       (WM_USER+0)
#define EM_SETSEL       (WM_USER+1)
#define EM_LINEFROMCHAR (WM_USER+25)

#define COLOR_WINDOW              5
#define COLOR_WINDOWTEXT          8

#define ES_CENTER                 1

//----------------------------------------------------------------------------//

CLASS TMultiGet FROM TControl

   DATA   lReadOnly
   DATA   nPos

   METHOD New( nRow, nCol, bSetGet, oWnd, nWidth, nHeight, oFont,;
               lHScroll, nClrFore, nClrBack, oCursor, lPixel, cMsg,;
               lUpdate, bWhen, lCenter, lRight, lReadOnly, bValid ) CONSTRUCTOR

   METHOD ReDefine( nId, bSetGet, oWnd, nHelpId, nClrFore, nClrBack, oFont,;
                    oCursor, cMsg, lUpdate, bWhen, lReadOnly, bValid ) CONSTRUCTOR

   METHOD cToChar() INLINE  Super:cToChar( "EDIT" )

   METHOD GotFocus() INLINE Super:GotFocus(),;
                            SetWindowText( ::hWnd, Eval( ::bSetGet ) ),;
                            ::SetPos( ::nPos ),;
                            CallWindowProc( ::nOldProc, ::hWnd, WM_SETFOCUS ),;
                            If( Set( _SET_INSERT ),;
                            ( DestroyCaret(),;
                              CreateCaret( ::hWnd, 0, 6, ::oFont:nHeight ),;
                              ShowCaret( ::hWnd ) ),), 0

   METHOD Init( hDlg )

   METHOD LostFocus() INLINE Super:LostFocus(),;
                             Eval( ::bSetGet, GetWindowText( ::hWnd ) ),;
                             ::nPos := nLoWord( ::SendMsg( EM_GETSEL ) )

   METHOD MouseMove( nRow, nCol, nKeyFlags )

   METHOD cText( cText ) SETGET

   METHOD Refresh() INLINE ;
                    SetWindowText( ::hWnd, cValToChar( Eval( ::bSetGet ) ) )

   METHOD Save() INLINE Eval( ::bSetGet, GetWindowText( ::hWnd ) )

   METHOD VScroll( nWParam, nLParam ) VIRTUAL

   METHOD HScroll( nWParam, nLParam ) VIRTUAL

   METHOD GetSel()

   METHOD KeyChar( nKey, nFlags )

   METHOD KeyDown( nKey, nFlags )

   METHOD SetPos( nStart, nEnd ) INLINE ;
                 nEnd := If( nEnd == nil, nStart, nEnd ),;
                 ::SendMsg( EM_SETSEL, 0, nMakeLong( nStart, nEnd ) )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nRow, nCol, bSetGet, oWnd, nWidth, nHeight, oFont, lHScroll,;
            nClrFore, nClrBack, oCursor, lPixel, cMsg, lUpdate,;
            bWhen, lCenter, lRight, lReadOnly, bValid ) CLASS TMultiGet

   DEFAULT lHScroll  := .f.,;
           nClrFore  := GetSysColor( COLOR_WINDOWTEXT ),;
           nClrBack  := GetSysColor( COLOR_WINDOW ),;
           lPixel    := .f., lUpdate := .f.,;
           lCenter   := .f., lRight := .f.,;
           lReadOnly := .f.

   ::cCaption = cValToChar( Eval( bSetGet ) )
   ::nTop     = nRow * If( lPixel, 1, MGET_CHARPIX_H )  //13
   ::nLeft    = nCol * If( lPixel, 1, MGET_CHARPIX_W )	// 8
   ::nBottom  = If( nHeight == nil, ::nTop + 11, ::nTop + nHeight )
   ::nRight   = If( nWidth == nil, ::nLeft + Len( ::cCaption ) * 3.5, ;
                    ::nLeft + nWidth )
   ::bSetGet  = bSetGet
   ::oWnd     = oWnd
   ::nStyle   = nOR( WS_CHILD, WS_VISIBLE, WS_BORDER, WS_TABSTOP, ES_LEFT,;
                     ES_WANTRETURN, ES_MULTILINE, WS_VSCROLL,;
                     If( lHScroll, WS_HSCROLL, 0 ),;
                     If( lCenter, ES_CENTER, If( lRight, ES_RIGHT, ES_LEFT ) ) )
   ::nId       = ::GetNewId()
   ::cCaption  = RTrim( ::cCaption )
   ::lDrag     = .f.
   ::lCaptured = .f.
   ::oCursor   = oCursor
   ::oFont     = oFont
   ::cMsg      = cMsg
   ::lUpdate   = lUpdate
   ::bWhen     = bWhen
   ::bValid    = bValid
   ::lReadOnly = lReadOnly
   ::lVisible  = oWnd:lVisible
   ::nPos      = 0

   ::SetColor( nClrFore, nClrBack )

   if oWnd:lVisible
      ::Create( "EDIT" )
      oWnd:AddControl( Self )
   else
      oWnd:DefControl( Self )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD ReDefine( nId, bSetGet, oWnd, nHelpId, nClrFore, nClrBack, oFont,;
             oCursor, cMsg, lUpdate, bWhen, lReadOnly, bValid ) CLASS TMultiGet

   DEFAULT nClrFore := GetSysColor( COLOR_WINDOWTEXT ),;
           nClrBack := GetSysColor( COLOR_WINDOW ),;
           lUpdate  := .f., lReadOnly := .f.

   ::nId       = nId
   ::bSetGet   = bSetGet
   ::oWnd      = oWnd
   ::nHelpId   = nHelpId
   ::lDrag     = .f.
   ::lCaptured = .f.
   ::oFont     = oFont
   ::oCursor   = oCursor
   ::cMsg      = cMsg
   ::lUpdate   = lUpdate
   ::bWhen     = bWhen
   ::bValid    = bValid
   ::lReadOnly = lReadOnly
   ::nPos      = 0

   ::SetColor( nClrFore, nClrBack )

   oWnd:DefControl( Self )

return nil

//----------------------------------------------------------------------------//

METHOD Init( hDlg ) CLASS TMultiGet

   Super:Init( hDlg )
   SetWindowText( ::hWnd, cValToChar( Eval( ::bSetGet ) ) )

return nil

//----------------------------------------------------------------------------//

METHOD cText( cText ) CLASS TMultiGet

   if PCount() == 1
      SetWindowText( ::hWnd, cText )
      Eval( ::bSetGet, cText )
   endif

return GetWindowText( ::hWnd )

//----------------------------------------------------------------------------//

METHOD GetSel() CLASS TMultiGet

   local n      := ::SendMsg( EM_GETSEL )
   local nStart := nLoWord( n )
   local nEnd   := nHiWord( n )

return If( nStart != nEnd, SubStr( ::cText, nStart + 1, nEnd - nStart + 1 ), "" )

//----------------------------------------------------------------------------//

METHOD MouseMove( nRow, nCol, nKeyFlags ) CLASS TMultiGet

   if ::lDrag
      return Super:MouseMove( nRow, nCol, nKeyFlags )
   else
      if ::oCursor != nil
         SetCursor( ::oCursor:hCursor )
      else
         CursorIBeam()
      endif
   endif

return nil      // We want standard MultiLine Get behavior !!!

//---------------------------------------------------------------------------//

METHOD KeyDown( nKey, nFlags ) CLASS TMultiGet

   do case
      case nKey == VK_INSERT
           Set( _SET_INSERT, ! Set( _SET_INSERT ) )
           DestroyCaret()
           if Set( _SET_INSERT )
              CreateCaret( ::hWnd, 0, 6, ::oFont:nHeight )
           else
              CreateCaret( ::hWnd, 0, 1, ::oFont:nHeight )
           endif
           ShowCaret( ::hWnd )

      case nKey == VK_DELETE
           if ::lReadOnly
              return 0
           endif
   endcase

return Super:KeyDown( nKey, nFlags )

//---------------------------------------------------------------------------//

METHOD KeyChar( nKey, nFlags ) CLASS TMultiGet

   local bKeyAction := SetKey( nKey )

   if bKeyAction != nil
      Eval( bKeyAction, ProcName( 4 ), ProcLine( 4 ) )
      return 0         // Already processed, API do nothing
   endif

   if ::lReadOnly
      return 0
   endif

return Super:KeyChar( nKey, nFlags )

//---------------------------------------------------------------------------//
