#include "FiveWin.ch"
#include "Constant.ch"

#define LTGRAY_BRUSH 1

static lRegistered := .f.

//----------------------------------------------------------------------------//

CLASS TMeter FROM TControl

   DATA nTotal
   DATA nClrBar, nClrBText
   DATA cText, lPorcentage

   METHOD New( nRow, nCol, bSetGet, nTotal, oWnd, nWidth, nHeight,;
               lUpdate, lPixel, oFont, cText, lNoPorcentage, ;
               nClrPane, nClrText, nClrBar, nClrBText ) CONSTRUCTOR

   METHOD ReDefine( nId, bSetGet, nTotal, oWnd, lUpdate, ;
                    oFont, cText, lNoPorcentage, ;
                    nClrPane, nClrText, nClrBar, nClrBText ) CONSTRUCTOR
   METHOD Default()

   METHOD Init( hDlg ) INLINE Super:Init( hDlg ), ::Default()

   METHOD HandleEvent( nMsg, nWParam, nLParam )

   METHOD Paint() BLOCK ;
      { | Self, nActual | MeterPaint( ::hWnd, ::hDC,;
                          nActual := Eval( ::bSetGet ), ::nTotal,;
                          nActual * 100 / ::nTotal, ;
                          ::cText, ::lPorcentage,  ;
                          ::nClrPane, ::nClrText,  ;
                          ::nClrBar,  ::nClrBText, ;
                          If( ::oFont == NIL, 0, ::oFont:hFont ) ) }

   METHOD Set( nActual )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nRow, nCol, bSetGet, nTotal, oWnd, nWidth, nHeight,;
            lUpdate, lPixel, oFont, cText, lNoPorcentage, nClrPane, nClrText, ;
            nClrBar, nClrBText ) CLASS TMeter

   DEFAULT lNoPorcentage := .f.
   DEFAULT lPixel   := .f.
   DEFAULT nClrBar  := CLR_HBLUE, nClrBText := CLR_WHITE
   DEFAULT nClrText := oWnd:nClrText, nClrPane := oWnd:nClrPane
   DEFAULT cText    := Chr( 0 )
   DEFAULT nTotal   := 10, nWidth := 300, nHeight := 20,;
           lUpdate  := .f.

   ::nTop      = If( lPixel, nRow, nRow * MTR_CHARPIX_H )  //14
   ::nLeft     = If( lPixel, nCol, nCol *  MTR_CHARPIX_W ) //8
   ::nBottom   = ::nTop  + nHeight
   ::nRight    = ::nLeft + nWidth
   ::oWnd      = oWnd
   ::nStyle    = nOR( WS_CHILD, WS_VISIBLE )
   ::nId       = ::GetNewId()
   ::bSetGet   = bSetGet
   ::nTotal    = nTotal
   ::lDrag     = .f.
   ::lCaptured = .f.
   ::lUpdate   = .f.

   ::nClrText  = nClrText
   ::nClrPane  = nClrPane
   ::nClrBar   = nClrBar
   ::nClrBText = nClrBText
   ::cText     = cText
   ::lPorcentage = ! lNoPorcentage

   ::oFont     = oFont

   if ! lRegistered
      ::Register( nOR( CS_VREDRAW, CS_HREDRAW ) )
      lRegistered = .t.
   endif

   if oWnd:lVisible
      ::Create()
      ::Default()
      oWnd:AddControl( Self )
   else
      oWnd:DefControl( Self )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD ReDefine( nId, bSetGet, nTotal, oWnd, lUpdate, ;
                 oFont, cText, lNoPorcentage, nClrPane, nClrText, ;
                 nClrBar, nClrBText ) CLASS TMeter

   DEFAULT lNoPorcentage := .f.
   DEFAULT nTotal   := 10, lUpdate := .f.
   DEFAULT nClrBar  := CLR_HBLUE, nClrBText := CLR_WHITE
   DEFAULT nClrText := oWnd:nClrText, nClrPane := oWnd:nClrPane
   DEFAULT cText    := Chr( 0 )

   ::nId       = nId
   ::bSetGet   = bSetGet
   ::nTotal    = nTotal
   ::oWnd      = oWnd
   ::lDrag     = .f.
   ::lCaptured = .f.
   ::lUpdate   = lUpdate

   ::nClrText  = nClrText
   ::nClrPane  = nClrPane
   ::nClrBar   = nClrBar
   ::nClrBText = nClrBText
   ::cText     = cText
   ::lPorcentage = ! lNoPorcentage
   ::oFont     = oFont

   if ! lRegistered
      ::Register( nOR( CS_VREDRAW, CS_HREDRAW ) )
      lRegistered = .t.
   endif

   if oWnd != nil
      oWnd:DefControl( Self )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD HandleEvent( nMsg, nWParam, nLParam ) CLASS TMeter

   if nMsg == WM_PAINT
      ::BeginPaint()
      ::Paint()
      ::EndPaint()
      return 0
   endif

return Super:HandleEvent( nMsg, nWParam, nLParam )

//----------------------------------------------------------------------------//

METHOD Set( nActual ) CLASS TMeter

   DEFAULT nActual := Eval( ::bSetGet )

   if nActual > ::nTotal
      nActual = ::nTotal
   endif

   if nActual < 0
      nActual = 0
   endif

   Eval( ::bSetGet, nActual )

   ::Refresh( .f. )

return nil

//----------------------------------------------------------------------------//

METHOD Default() CLASS TMeter

   if ValType( Eval( ::bSetGet ) ) == "U"
      Eval( ::bSetGet, 0 )
   endif

   if ::oFont != nil
      ::SetFont( ::oFont )
   else
      ::SetFont( ::oWnd:oFont )
   endif

return nil

//----------------------------------------------------------------------------//
