#include "FiveWin.ch"
#include "Constant.ch"

#define LB_ADDSTRING         ( WM_USER +  1 )
#define LB_INSERTSTRING      ( WM_USER +  2 )
#define LB_DELETESTRING      ( WM_USER +  3 )
#define LB_RESETCONTENT      ( WM_USER +  5 )
#define LB_SETCURSEL         ( WM_USER +  7 )
#define LB_GETCURSEL         ( WM_USER +  9 )
#define LB_GETCOUNT          ( WM_USER + 12 )
#define LB_DIR               ( WM_USER + 14 )
#define LB_ERR                           -1

#define COLOR_WINDOW       5
#define COLOR_WINDOWTEXT   8

//----------------------------------------------------------------------------//

CLASS TListBox FROM TControl

   DATA   aItems
   DATA   lOwnerDraw, nBmpSize
   DATA   cFileSpec

   METHOD New( nRow, nCol, bSetGet, aItems, nWidth, nHeight, bChange,;
               oWnd, bValid, nClrFore, nClrBack, lPixel, lDesign,;
               bLDblClicked, oFont, cMsg, lUpdate, bWhen ) CONSTRUCTOR

   METHOD ReDefine( nId, bSetGet, aItems, bChange,  oWnd, nHelpId,;
                    lOwnerDraw, nBmpSize, bValid, cFileSpec,;
                    nClrFore, nClrBack, bLDblClicked, cMsg,;
                    lUpdate, bWhen ) CONSTRUCTOR

   METHOD cToChar() INLINE Super:cToChar( "LISTBOX" )

   METHOD cGenPrg()

   METHOD Init( hDlg ) INLINE  Super:Init( hDlg ),;
                               ::Default()

   METHOD MouseMove( nRow, nCol, nKeyFlags )

   METHOD GoTop()    INLINE ::Select( 1 )
   METHOD GoBottom() INLINE ::Select( Len( ::aItems ) )

   METHOD Select( nItem ) INLINE ::SendMsg( LB_SETCURSEL, nItem - 1, 0 ),;
                                 ::Change()

   METHOD Set( cNewItem )

   METHOD SetItems( aItems ) INLINE ::Reset(), ::aItems := aItems,;
                                    ::Default(),;
                                    ::SendMsg( LB_SETCURSEL, 0 ),;
                                    ::Change()

   METHOD Add( cItem, nAt )
   METHOD Modify( cItem, nAt )
   METHOD Insert( cItem, nAt )
   METHOD Del( nAt )
   METHOD GetItem( nItem ) INLINE  LbxGetItem( ::hWnd, nItem )

   METHOD Len() INLINE  SendMessage( ::hWnd, LB_GETCOUNT )

   METHOD LostFocus()

   METHOD Reset() INLINE Eval( ::bSetGet,;
                         If( ValType( Eval( ::bSetGet ) ) == "N", 0, "" ) ),;
                         ::SendMsg( LB_RESETCONTENT )

   METHOD Change()

   METHOD FillMeasure( nPInfo ) INLINE  LbxMeasure( nPInfo, ::nBmpSize )

   METHOD DrawItem( nPStruct ) INLINE  LbxDrawItem( nPStruct, ::aItems )

   METHOD GetPos() BLOCK ;             // it has to be a BLOCK
      { | Self, nPos | nPos := ::SendMsg( LB_GETCURSEL ),;
                       If( nPos == -1, 0, nPos + 1 ) }

   METHOD Default()

   METHOD VScroll( nWParam, nLParam ) VIRTUAL  // We request default behaviors

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nRow, nCol, bSetGet, aItems, nWidth, nHeight, bChange, ;
            oWnd, bValid, nClrFore, nClrBack, lPixel, lDesign,;
            bLDblClicked, oFont, cMsg, lUpdate, bWhen )  CLASS TListBox

   if nClrFore == nil
      nClrBack := GetSysColor( COLOR_WINDOW )
   endif

   DEFAULT aItems   := {}, nWidth := 40, nHeight := 40,;
           nClrFore := GetSysColor( COLOR_WINDOWTEXT ),;
           lPixel   := .f., lDesign := .f., lUpdate := .f.,;
           oWnd     := GetWndDefault()

   ::cCaption   = ""
   ::nTop       = nRow * If( lPixel, 1, LST_CHARPIX_H )		//14
   ::nLeft      = nCol * If( lPixel, 1, LST_CHARPIX_W )	  // 8
   ::nBottom    = ::nTop  + nHeight - 1
   ::nRight     = ::nLeft + nWidth - 1
   ::aItems     = aItems
   ::bSetGet    = bSetGet
   ::bChange    = bChange
   ::bLDblClick = bLDblClicked
   ::oWnd       = oWnd
   ::oFont      = oFont
   ::lOwnerDraw = .f.
   ::nStyle     = nOR( LBS_NOTIFY, WS_TABSTOP, LBS_DISABLENOSCROLL,;
                       LBS_USETABSTOPS, WS_CHILD, WS_VISIBLE, WS_BORDER,;
                       WS_VSCROLL, If( lDesign, WS_THICKFRAME, 0 ) )
   ::nId        = ::GetNewId()
   ::bValid     = bValid
   ::lDrag      = lDesign
   ::lCaptured  = .f.
   ::cMsg       = cMsg
   ::lUpdate    = lUpdate
   ::bWhen      = bWhen

   ::SetColor( nClrFore, nClrBack )

   if ! Empty( oWnd:hWnd )
      ::Create( "LISTBOX" )
      ::Default()
      oWnd:AddControl( Self )
   else
      oWnd:DefControl( Self )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD ReDefine( nId, bSetGet, aItems, bChange, oWnd, nHelpId,;
                 lOwnerDraw, nBmpSize, bValid, cFileSpec, nClrFore,;
                 nClrBack, bLDblClicked, cMsg, lUpdate, bWhen ) CLASS TListBox

   if nClrFore == nil
      nClrBack := GetSysColor( COLOR_WINDOW )
   endif

   DEFAULT aItems   := {}, nBmpSize := 30,;
           nClrFore := GetSysColor( COLOR_WINDOWTEXT ),;
           lUpdate  := .f.

   ::nId        = nId
   ::hWnd       = 0
   ::aItems     = aItems
   ::bSetGet    = bSetGet
   ::bChange    = bChange
   ::bLDblClick = bLDblClicked
   ::oWnd       = oWnd
   ::nHelpId    = nHelpId
   ::lOwnerDraw = lOwnerDraw
   ::nBmpSize   = nBmpSize
   ::bValid     = bValid
   ::cFileSpec  = cFileSpec
   ::lDrag      = .f.
   ::lCaptured  = .f.
   ::cMsg       = cMsg
   ::lUpdate    = lUpdate
   ::bWhen      = bWhen

   ::SetColor( nClrFore, nClrBack )

   if lOwnerDraw
      AEval( ::aItems, ;
             { | cBitmap, n | ::aItems[ n ] := ReadBitmap( 0, cBitmap ) } )
   endif

   oWnd:DefControl( Self )

return nil

//----------------------------------------------------------------------------//

METHOD Set( cNewItem ) CLASS TListBox

   local nAt := AScan( ::aItems,;
                       { | cItem | Upper( AllTrim( cItem ) ) == ;
                                   Upper( AllTrim( cNewItem ) ) } )

   if nAt != 0
      ::Select( nAt - 1 )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD LostFocus() CLASS TListBox

   local nAt := ::SendMsg( LB_GETCURSEL )

   Super:LostFocus()

   if nAt != -1
      if ValType( Eval( ::bSetGet ) ) == "N"
         Eval( ::bSetGet, nAt + 1 )
      else
         Eval( ::bSetGet, ::aItems[ nAt + 1 ] )
      endif
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Add( cItem, nAt ) CLASS TListBox

   DEFAULT nAt := Len( ::aItems )

   if nAt == Len( ::aItems )
      AAdd( ::aItems, cItem )
      ::SendMsg( LB_ADDSTRING, nAt, cItem )
   else
      ASize( ::aItems, Len( ::aItems ) + 1 )
      AIns( ::aItems, nAt + 1 )
      ::aItems[ nAt + 1 ] = cItem
      ::SendMsg( LB_INSERTSTRING, nAt, cItem )
   endif

   ::SendMsg( LB_SETCURSEL, nAt )

return nil

//----------------------------------------------------------------------------//

METHOD Modify( cItem, nAt ) CLASS TListBox

   if nAt == nil
      if ( nAt := ::SendMsg( LB_GETCURSEL ) ) != -1
         nAt++
      endif
   endif

   if nAt > 0
      ::aItems[ nAt ] = cItem
      ::SendMsg( LB_DELETESTRING, nAt - 1 )
      ::SendMsg( LB_INSERTSTRING, nAt - 1, cItem )
      ::SendMsg( LB_SETCURSEL, nAt - 1 )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Insert( cItem, nAt ) CLASS TListBox

   if nAt == nil
      if ( nAt := ::SendMsg( LB_GETCURSEL ) ) != -1
         nAt++
      endif
   endif

   if nAt > 0
      ASize( ::aItems, Len( ::aItems ) + 1 )
      AIns( ::aItems, nAt )
      ::aItems[ nAt ] = cItem
      ::SendMsg( LB_INSERTSTRING, nAt - 1, cItem )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Del( nAt ) CLASS TListBox

   if nAt == nil
      if ( nAt := ::SendMsg( LB_GETCURSEL ) ) != -1
         nAt++
      endif
   endif

   if nAt > 0
      ADel( ::aItems, nAt )
      ASize( ::aItems, Len( ::aItems ) - 1 )
      ::SendMsg( LB_DELETESTRING, nAt - 1 )
      ::SendMsg( LB_SETCURSEL, Min( nAt, Len( ::aItems ) ) - 1 )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Change() CLASS TListBox

   if ValType( Eval( ::bSetGet ) ) == "N"
      Eval( ::bSetGet, ::SendMsg( LB_GETCURSEL ) + 1 )
   else
      Eval( ::bSetGet, ::aItems[ ::SendMsg( LB_GETCURSEL ) + 1 ] )
   endif

   if ::bChange != nil
      Eval( ::bChange, Self )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Default() CLASS TListBox

   local nAt
   local cStart := Eval( ::bSetGet )
   local aFiles

   DEFAULT cStart := ""

   if ! ::lOwnerDraw
      if ! Empty( ::cFileSpec )
         aFiles = Directory( ::cFileSpec )
         for nAt = 1 to Len( aFiles )
            AAdd( ::aItems, aFiles[ nAt ][ 1 ] )
         next
         ASort( ::aItems )
      endif

      AEval( ::aItems,;
             { | cItem, nAt | If( cItem == nil, ::aItems[ nAt ] := "",),;
                              ::SendMsg( LB_ADDSTRING, nAt,;
                              If( cItem == nil, "", cItem ) ) } )

      if ValType( cStart ) != "N"
         nAt = AScan( ::aItems, { | cItem | Upper( AllTrim( cItem ) ) == ;
                                    Upper( AllTrim( cStart ) ) } )
      else
         nAt = cStart
      endif

      if nAt != 0
         ::SendMsg( LB_SETCURSEL, nAt - 1 )
      endif
   else
      AEval( ::aItems, { | cItem | ::Add( "Testing..." ) } )
   endif

   if ::oFont != nil
      ::SetFont( ::oFont )
   else
      ::SetFont( ::oWnd:oFont )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD MouseMove( nRow, nCol, nKeyFlags ) CLASS TListBox

   local nResult := Super:MouseMove( nRow, nCol, nKeyFlags )

return If( ::lDrag, nResult, nil )    // We want standard behavior !!!

//----------------------------------------------------------------------------//

METHOD cGenPrg() CLASS TListBox

   local cCode := ""
   local n

   cCode += CRLF + "   @ " + Str( ::nTop, 3 ) + ", " + Str( ::nLeft, 3 ) + ;
            " LISTBOX oLbx ITEMS { "

   for n = 1 to Len( ::aItems )
      if n > 1
         cCode += ", "
      endif
      cCode += '"' + ::aItems[ n ] + '"'
   next

   cCode += " } ;" + CRLF + ;
            "      SIZE " + Str( ::nRight - ::nLeft + 1, 3 ) + ", " + ;
            Str( ::nBottom - ::nTop + 1, 3 ) + " PIXEL OF oWnd" + CRLF

return cCode

//----------------------------------------------------------------------------//
