// Drawing lines and some management colors

#include "FiveWin.ch"

//----------------------------------------------------------------------------//

static aPoints, nCount, nColor := 0, oWnd

function Main()

   aPoints := Array( 1000 )
   nCount  := 0
   
   DEFINE WINDOW oWnd FROM 1, 1 TO 30, 50 ;
      TITLE OemToAnsi( "FiveWin 1.0 - Pulsar en la pantalla con el ratn" ) ;
      MENU BuildMenu()

   oWnd:bLClicked := { | y, x, flags | Click( y, x ) }
   oWnd:bPainted  := { || MiPaint() }
   
   ACTIVATE WINDOW oWnd

return 0

//----------------------------------------------------------------------------//

function BuildMenu()

   local oMenu

   MENU oMenu
      MENUITEM "&Operaciones"
      MENU
         MENUITEM "&Limpiar"  ACTION Limpiar()
         MENUITEM "&Undo"     ACTION Undo()
         SEPARATOR
         MENUITEM "&Color"    ACTION NewColor()
      ENDMENU

      MENUITEM "&Salir"       ACTION oWnd:End()

   ENDMENU

return oMenu

//----------------------------------------------------------------------------//

STATIC PROCEDURE Limpiar()
   nCount := 0
   oWnd:Refresh()

//----------------------------------------------------------------------------//

STATIC PROCEDURE Undo()
   if nCount > 0
      nCount--
      oWnd:Refresh()
   endif

//----------------------------------------------------------------------------//

STATIC PROCEDURE NewColor()
   LOCAL OldColor := nColor
   if ( nColor := ChooseColor() ) == -1
      nColor := OldColor
   endif

//----------------------------------------------------------------------------//

STATIC PROCEDURE Click( x, y )

   aPoints[ ++nCount ] := { y, x }

   DrawLine( x, y )
   RETURN

//----------------------------------------------------------------------------//

STATIC PROCEDURE DrawLine( x, y )
   LOCAL n, hPen, hOldPen

   oWnd:GetDc()
   hPen := CreatePen( 0, 1, nColor )
   hOldPen := SelectObject( oWnd:hDc, hPen )

   for n := 1 to nCount - 1
      MoveTo( oWnd:hDC, aPoints[ n, 1 ], aPoints[ n, 2 ] )
      LineTo( oWnd:hDC, y, x )
   next

   SelectObject( oWnd:hDc, hOldPen )
   DeleteObject( hPen )
   oWnd:ReleaseDc()
   RETURN

//----------------------------------------------------------------------------//

STATIC PROCEDURE MiPaint()
   LOCAL n
   for n := 1 to nCount
      DrawLine( aPoints[n, 2], aPoints[n, 1] )
   next
   RETURN
