// FiveWin LIB files management
// FiveWin LIB tools

#include "FiveWin.ch"

//----------------------------------------------------------------------------//

function LibOpen( cLibName )

   local oIco, oWndLib, oBrw, oBar, oFont, oHand
   local cNtxName, cAlias
   local nType
   local aModules := {}

   DEFAULT cLibName := cGetFile( "Library file ( *.lib ) | *.lib",;
                                 "Select a Library" )

   if ! File( cLibName )
      MsgStop( "I can't find " + cLibName )
      return nil
   endif

   CursorWait()
   if lLibOpen( cLibName )
      aModules = aLibModules()
      lLibClose()
      CursorHand()
   endif

   DEFINE ICON oIco RESOURCE "Libs"

   DEFINE WINDOW oWndLib FROM 1, 1 TO 23, 33 ;
      TITLE "Library: " + cNoPath( cNoExt( cLibName ) ) MDICHILD ;
      ICON oIco

   DEFINE FONT oFont NAME "Arial" SIZE 6, 15 BOLD

   DEFINE CURSOR oHand RESOURCE "Hand"

   @  0, 0 LISTBOX oBrw FIELDS "" ;
      HEADERS "Modules" ;
      OF oWndLib ;
      FONT oFont CURSOR oHand ;
      SIZE 400, 400

   oBrw:bLine = { || { aModules[ oBrw:nAt ] } }
   oBrw:SetArray( aModules )

   DEFINE BUTTONBAR oBar OF oWndLib

   DEFINE BUTTON OF oBar RESOURCE "New" ;
      MESSAGE "Add a new item to the project"

   oWndLib:SetControl( oBrw )

   ACTIVATE WINDOW oWndLib

return nil

//----------------------------------------------------------------------------//
