// Returns an array with the names of all the active Tasks running in Windows

#define GHW_HWNDFIRST 0
#define GHW_HWNDNEXT  2

#define GWW_HINSTANCE -6

//----------------------------------------------------------------------------//

function GetTasks()

   local hWnd   := GetWindow( GetActiveWindow(), GHW_HWNDFIRST )
   local aTasks := {}
   local cTask

   while hWnd != 0
      cTask = GetModuleFileName( GetWindowWord( hWnd, GWW_HINSTANCE ) )
      if AScan( aTasks, cTask ) == 0
         AAdd( aTasks, cTask )
      endif
      hWnd = GetWindow( hWnd, GHW_HWNDNEXT )
   end

return aTasks

//----------------------------------------------------------------------------//
