#include <WinTen.h>
#include <Windows.h>
#include <CommDlg.h>
#include <ClipApi.h>

#define LF_HEIGHT          1
#define LF_WIDTH           2
#define LF_ESCAPEMENT      3
#define LF_ORIENTATION     4
#define LF_WEIGHT          5
#define LF_ITALIC          6
#define LF_UNDERLINE       7
#define LF_STRIKEOUT       8
#define LF_CHARSET         9
#define LF_OUTPRECISION   10
#define LF_CLIPPRECISION  11
#define LF_QUALITY        12
#define LF_PITCHANDFAMILY 13
#define LF_FACENAME       14

//----------------------------------------------------------------------------//

CLIPPER ChooseFONT()    //  [ aPreviousFont, @ nRGBColor ]  --> aNewFont
{
   CHOOSEFONT cf;
   LOGFONT    lf;
   BYTE    bChars[ 15 ];  // Keep this under lf for the name
   BOOL      bOk, bInitLF = ISARRAY( 1 );

   _bset( ( BYTE * ) &cf, 0, sizeof( CHOOSEFONT ) );
   _bset( ( BYTE * ) &lf, 0, sizeof( LOGFONT ) );

   if( bInitLF )      // Previous Font is provided
   {
      lf.lfHeight         = _parni( 1, LF_HEIGHT );
      lf.lfWidth          = _parni( 1, LF_WIDTH );
      lf.lfEscapement     = _parni( 1, LF_ESCAPEMENT );
      lf.lfOrientation    = _parni( 1, LF_ORIENTATION );
      lf.lfWeight         = _parni( 1, LF_WEIGHT );
      lf.lfItalic         = _parl(  1, LF_ITALIC );
      lf.lfUnderline      = _parl(  1, LF_UNDERLINE );
      lf.lfStrikeOut      = _parl(  1, LF_STRIKEOUT );
      lf.lfCharSet        = _parni( 1, LF_CHARSET );
      lf.lfOutPrecision   = _parni( 1, LF_OUTPRECISION );
      lf.lfClipPrecision  = _parni( 1, LF_CLIPPRECISION );
      lf.lfQuality        = _parni( 1, LF_QUALITY );
      lf.lfPitchAndFamily = _parni( 1, LF_PITCHANDFAMILY );

      if( _parclen( 1, LF_FACENAME ) )
         strcpy( &( lf.lfFaceName ), _parc( 1, LF_FACENAME ) );
   }

   cf.lStructSize = sizeof( CHOOSEFONT );
   cf.hwndOwner   = GetActiveWindow();
   cf.lpLogFont   = &lf;
   cf.Flags       = CF_SCREENFONTS | CF_EFFECTS |
                    IF( bInitLF, CF_INITTOLOGFONTSTRUCT, 0 );
   cf.rgbColors   = ( COLORREF ) IF( PCOUNT() > 1, _parnl( 2 ), 0 );
   cf.nFontType   = PRINTER_FONTTYPE;

   bOk = ChooseFont( &cf );

   _reta( 14 );
   _storni( bOk ? lf.lfHeight:         0, -1, LF_HEIGHT );
   _storni( bOk ? lf.lfWidth:          0, -1, LF_WIDTH );
   _storni( bOk ? lf.lfEscapement:     0, -1, LF_ESCAPEMENT );
   _storni( bOk ? lf.lfOrientation:    0, -1, LF_ORIENTATION );
   _storni( bOk ? lf.lfWeight:         0, -1, LF_WEIGHT );
   _storl(  bOk ? lf.lfItalic:         0, -1, LF_ITALIC );
   _storl(  bOk ? lf.lfUnderline:      0, -1, LF_UNDERLINE );
   _storl(  bOk ? lf.lfStrikeOut:      0, -1, LF_STRIKEOUT );
   _storni( bOk ? lf.lfCharSet:        0, -1, LF_CHARSET );
   _storni( bOk ? lf.lfOutPrecision:   0, -1, LF_OUTPRECISION );
   _storni( bOk ? lf.lfClipPrecision:  0, -1, LF_CLIPPRECISION );
   _storni( bOk ? lf.lfQuality:        0, -1, LF_QUALITY );
   _storni( bOk ? lf.lfPitchAndFamily: 0, -1, LF_PITCHANDFAMILY );
   _storc(  bOk ? lf.lfFaceName:      "", -1, LF_FACENAME );

   if( bOk && ( PCOUNT() == 2 ) )
      _stornl( cf.rgbColors, 2 );
}

//----------------------------------------------------------------------------//
