// This sample shows how to build FiveWin aplications in visual Mode.

// Warning: Under construction. Not available yet!
// FiveGuru 1.5  - Our Guru for building applications in FiveWin!

// Visual Design tools

// Some have 'experts' and others have 'wizards...", but here
// we have a real Guru!!!  <g>

#include "FiveWin.ch"
#include "FiveGuru.ch"

static oWnd, oBar, oMsg, oMenu
static nBrushStyle := 1

//----------------------------------------------------------------------------//

function Main()

   SET 3DLOOK ON

   DEFINE WINDOW oWnd TITLE "FiveGuru 1.5" MDI

   ACTIVATE WINDOW oWnd ;
      ON INIT ( oWnd:oMenu:End(), MainQuery() ) ;
      ON RIGHT CLICK MainQuery()

return nil

//----------------------------------------------------------------------------//

function MainQuery()

   local oDlg
   local cTitle     := PadR( oWnd:cTitle, 50 )
   local lButtonBar := ( oBar  != nil )
   local lMsgBar    := ( oMsg  != nil )
   local lMenu      := ( oMenu != nil )
   local lBrush     := .f.

   DEFINE DIALOG oDlg RESOURCE "AppInspect"

   REDEFINE GET cTitle ID 110 OF oDlg ;
      VALID ( oWnd:cTitle := AllTrim( cTitle ), .t. )

   REDEFINE CHECKBOX lButtonBar ID 120 OF oDlg ;
      ON CHANGE ToggleButtonBar()

   REDEFINE CHECKBOX lMsgBar ID 130 OF oDlg ;
      ON CHANGE ToggleMessageBar()

   REDEFINE CHECKBOX lMenu ID 150 OF oDlg ;
      ON CHANGE ToggleMenu()

   REDEFINE CHECKBOX lBrush ID ID_BRUSH OF oDlg ;
      ON CHANGE BrushInspect()

   REDEFINE BUTTON ID ID_GEN OF oDlg ;
      ACTION ( oWnd:cGenPRG( "GuruCode.prg" ),;
               MsgInfo( "Ok, See GuruCode.prg" ) )

   ACTIVATE DIALOG oDlg CENTERED NOWAIT

return nil

//----------------------------------------------------------------------------//

function AddControl()

   local oDlg, oCtrl
   local nControl  := 1
   local lCheckBox := .f.
   local cItem     := ""

   DEFINE DIALOG oDlg RESOURCE "Controls"

   REDEFINE RADIO nControl ID ID_PUSHBUTTON, ID_CHECKBOX, ID_LISTBOX OF oDlg

   ACTIVATE DIALOG oDlg CENTERED

   if oDlg:nResult == ID_OK
      do case
         case nControl == 1
              @ 3, 3 BUTTON oCtrl PROMPT "&PushButton" SIZE 100, 30 OF oWnd
              oCtrl:lDrag = .t.

         case nControl == 2
              @ 3, 3 CHECKBOX oCtrl VAR lCheckBox PROMPT "&CheckBox" SIZE 100, 30 OF oWnd
              oCtrl:lDrag = .t.

         case nControl == 3
              @ 3, 3 LISTBOX oCtrl VAR cItem ;
                ITEMS { "This", "is", "a", "listbox" } ;
                SIZE 150, 150 OF oWnd
              oCtrl:lDrag = .t.

      endcase
   endif

return nil

//----------------------------------------------------------------------------//

function ToggleButtonBar( l3D )

   DEFAULT l3D := .f.

   if oBar == nil
      if l3D
         DEFINE BUTTONBAR oBar 3D OF oWnd
      else
         DEFINE BUTTONBAR oBar 3D OF oWnd
      endif
      oWnd:CoorsUpdate()
      oWnd:Move( oWnd:nTop, oWnd:nLeft,;
                 oWnd:nRight - oWnd:nLeft,;
                 oWnd:nBottom - oWnd:nTop )
      oBar:bRClicked = { || BarInspect() }
   else
      oBar:End()
      SysRefresh()
      oBar = nil
   endif

return nil

//----------------------------------------------------------------------------//

function ToggleMessageBar()

   if oMsg == nil
      SET MESSAGE OF oWnd TO "Message Bar"
      oMsg = oWnd:oMsgBar
      oMsg:Adjust()
      oWnd:CoorsUpdate()
      oWnd:Move( oWnd:nTop, oWnd:nLeft,;
                 oWnd:nRight - oWnd:nLeft,;
                 oWnd:nBottom - oWnd:nTop )
      oMsg:bRClicked = { || MsgInspect() }
   else
      oMsg:End()
      SysRefresh()
      oMsg = nil
   endif

return nil

//----------------------------------------------------------------------------//

function ToggleMenu()

   if oMenu == nil
      MENU oMenu
         MENUITEM "&MenuItem..." ACTION MenuItemInspect()
         MENU
            MENUITEM "&One..."
            MENUITEM "&Two..."
            MENUITEM "&Three..."
         ENDMENU

         MENUITEM RESOURCE "MenuInsp" ACTION MenuInspect()
      ENDMENU
      oWnd:SetMenu( oMenu )
      oWnd:CoorsUpdate()
      oWnd:Move( oWnd:nTop, oWnd:nLeft,;
                 oWnd:nRight - oWnd:nLeft,;
                 oWnd:nBottom - oWnd:nTop )
   else
      oMenu:End()
      SysRefresh()
      oMenu = nil
   endif

return nil

//----------------------------------------------------------------------------//

function MsgInspect()

   local oDlg
   local cMessage := PadR( oMsg:cMsgDef, 60 )

   DEFINE DIALOG oDlg RESOURCE "MsgInspect"

   REDEFINE GET cMessage ID 110 OF oDlg

   REDEFINE CHECKBOX oMsg:lCentered ID 120 OF oDlg ;
      ON CHANGE oMsg:Refresh()

   ACTIVATE DIALOG oDlg CENTERED

   if oDlg:nResult == ID_OK
      oMsg:cMsgDef = AllTrim( cMessage )
      oMsg:Refresh()
   endif

return nil

//----------------------------------------------------------------------------//

function BarInspect()

   local oDlg, oGroup
   local lGroup := .f.

   DEFINE DIALOG oDlg RESOURCE "BarInspect"

   REDEFINE CHECKBOX oGroup VAR lGroup ID 110 OF oDlg

   REDEFINE BUTTON ID 120 OF oDlg ;
      ACTION ( AddBarButton( lGroup ), lGroup := .f., oGroup:Refresh() )

   REDEFINE BUTTON ID 130 OF oDlg ;
      ACTION ( oWnd:oBar:End(), SysRefresh(), oBar := nil,;
               ToggleButtonBar( .t. ) )

   REDEFINE BUTTON ID ID_SELCOLOR OF oDlg ;
      ACTION oBar:SetColor( oBar:nClrText, ChooseColor( oBar:nClrPane ) )

   ACTIVATE DIALOG oDlg CENTERED NOWAIT

return nil

//----------------------------------------------------------------------------//

function AddBarButton( lGroup )

   local oBtnBmp

   if lGroup
      DEFINE BUTTON oBtnBmp OF oBar ;
         ACTION BtnBmpAction( oBtnBmp ) GROUP ;
         MESSAGE "I am a button"
   else
      DEFINE BUTTON oBtnBmp OF oBar ;
         ACTION BtnBmpAction( oBtnBmp ) ;
         MESSAGE "I am a button"
   endif

   oBtnBmp:bRClicked = { || BtnBmpInspect( oBtnBmp ) }

return nil

//----------------------------------------------------------------------------//

function BtnBmpAction( oBtnBmp )

   local oWndChild
   local oDlg

   do case
      case oBtnBmp:Cargo == "Window"
           DEFINE WINDOW oWndChild TITLE "Child" MDICHILD OF oWnd
           ACTIVATE WINDOW oWndChild ;
              ON RIGHT CLICK ChocBar( oWndChild )

      case oBtnBmp:Cargo == "DialogBox"
           DEFINE DIALOG oDlg FROM 10, 10 TO 22, 50 TITLE "Dialog" OF oWnd
           ACTIVATE DIALOG oDlg ;
              ON RIGHT CLICK ChocBar( oDlg )
   endcase

return nil

//----------------------------------------------------------------------------//

function BtnBmpInspect( oBtnBmp )

   local oDlg
   local cBmpUp   := Space( 40 )
   local cBmpDown := Space( 40 )
   local lUp      := .t.
   local cFile
   local aActions := { "Window", "DialogBox", "Extern EXE", "CodeBlock" }

   DEFINE DIALOG oDlg RESOURCE "BtnBmpInspect"

   REDEFINE GET cBmpUp ID ID_BITMAPUP OF oDlg ;
      VALID ( lUp := .t., oBtnBmp:SetFile( cBmpUp ), .t. )

   REDEFINE BUTTON ID ID_FIND OF oDlg ;
      ACTION If( ! Empty( cFile := cGetFile( "*.bmp", "Select a BMP file" ) ),;
             oBtnBmp:SetFile( If( lUp, cFile, "" ), If( ! lUp, cFile, "" ) ),)

   REDEFINE COMBOBOX oBtnBmp:Cargo PROMPTS aActions ID 170 OF oDlg

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//

function MenuInspect()

   local oDlg

   DEFINE DIALOG oDlg RESOURCE "MenuInspect"

   ACTIVATE DIALOG oDlg CENTERED NOWAIT

return nil

//----------------------------------------------------------------------------//

function MenuItemInspect()

   local oDlg
   local cAction := ""

   DEFINE DIALOG oDlg RESOURCE "MenuItemInspect"

   REDEFINE COMBOBOX cAction ITEMS { "DialogBox", "Window", "PopMenu" } ;
      ID ID_ACTION OF oDlg

   REDEFINE BUTTON ID ID_EXECUTE OF oDlg ACTION NewWindow()

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//

function BrushInspect()

   local oDlg

   DEFINE DIALOG oDlg RESOURCE "BrushInspect"

   REDEFINE RADIO nBrushStyle ID ID_BORLAND, ID_TILED, ID_BRICKS OF oDlg ;
      ON CLICK oWnd:SetBrush( TBrush():New( { "BORLAND",;
         "TILED", "BRICKS" }[ nBrushStyle ] ) )

   REDEFINE BUTTON ID ID_COLORSELECT OF oDlg ;
      ACTION oWnd:SetBrush( TBrush():New(,ChooseColor()) )

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//

function NewWindow()

   local oWndChild

   DEFINE WINDOW oWndChild FROM 2, 2 TO 12, 40 TITLE "Child Window" ;
      STYLE WS_OVERLAPPEDWINDOW

   ACTIVATE WINDOW oWndChild

return nil

//----------------------------------------------------------------------------//

#define BTN_WIDTH  18
#define BTN_HEIGHT 18

function ChocBar( oDlgParent )

   local oDlg
   local nTop := 2, nLeft := 2

   SET 3DLOOK ON

   DEFINE DIALOG oDlg ;
      FROM 2, 2 TO 187, 74 PIXEL ;
      TITLE "Tools" OF oDlgParent

   @ nTop, 0 BUTTON SIZE BTN_WIDTH, BTN_HEIGHT ;
      FILENAME "..\bitmaps\Window.bmp" OF oDlg ;
      ACTION AddButton( oDlgParent )

   @ nTop, BTN_WIDTH BUTTON SIZE BTN_WIDTH, BTN_HEIGHT ;
      FILENAME "..\bitmaps\Menu.bmp" OF oDlg ;
      ACTION AddBrowse( oDlgParent )

   @ nTop += BTN_HEIGHT, 0 BUTTON SIZE BTN_WIDTH, BTN_HEIGHT ;
      FILENAME "..\bitmaps\BtnBar.bmp" OF oDlg

   @ nTop, BTN_WIDTH BUTTON SIZE BTN_WIDTH, BTN_HEIGHT ;
      FILENAME "..\bitmaps\arrow.bmp" OF oDlg

   @ nTop += BTN_HEIGHT, 0 BUTTON SIZE BTN_WIDTH, BTN_HEIGHT ;
      FILENAME "..\bitmaps\arrow.bmp" OF oDlg

   @ nTop, BTN_WIDTH BUTTON SIZE BTN_WIDTH, BTN_HEIGHT ;
      FILENAME "..\bitmaps\arrow.bmp" OF oDlg

   @ nTop += BTN_HEIGHT, 0 BUTTON SIZE BTN_WIDTH, BTN_HEIGHT ;
      FILENAME "..\bitmaps\arrow.bmp" OF oDlg

   @ nTop, BTN_WIDTH BUTTON SIZE BTN_WIDTH, BTN_HEIGHT ;
      FILENAME "..\bitmaps\arrow.bmp" OF oDlg

   @ nTop += BTN_HEIGHT, 0 BUTTON SIZE BTN_WIDTH, BTN_HEIGHT ;
      FILENAME "..\bitmaps\arrow.bmp" OF oDlg

   @ nTop, BTN_WIDTH BUTTON SIZE BTN_WIDTH, BTN_HEIGHT ;
      FILENAME "..\bitmaps\arrow.bmp" OF oDlg

   ACTIVATE DIALOG oDlg NOWAIT

return nil

//----------------------------------------------------------------------------//

function AddButton( oDlg )

   @ 2, 2 BUTTON "&Hello" SIZE 80, 20 OF oDlg DESIGN

return nil

//----------------------------------------------------------------------------//

function AddBrowse( oDlg )

   @ 2, 2 LISTBOX FIELDS HEADERS "Browse" DESIGN ;
      SIZE 200, 100 OF oDlg

return nil

//----------------------------------------------------------------------------//
