

//---------------------------------------------------------------------------//

function cFileDisc( cPathMask )  // devuelve cUnidad lgica
                                 // ej: de "c:\pepe\file.*"
                                 // devuelve "C:"
                                 // de : "\pepe\file.*"
                                 // devuelve ""
return if( at( ":", cPathMask ) == 2, ;
              upper( left( cPathMask, 2 ) ), "" )

//---------------------------------------------------------------------------//

function cFilePath( cPathMask )  // DEVUELVE ACCESO
                                 // ej.: de "c:\path\path\filename.ext"
                                 // devuelve "c:\path\path\"
                                 // ej:  de  "" -> "\"
                                 // EJ: de "C:" -> "C:\"
                                 // ej: de "C:filename.ext" -> "C:\"

    local i := rat( "\", cPathMask )

return if( i > 0, ;
           upper( left( cPathMask, i ) ),;
           cFileDisc( cPathMask ) + "\" )

//---------------------------------------------------------------------------//

function cFileName( cPathMask )

    local i := rat( "\", cPathMask )

return upper( if( i > 0 .and. i < len( cPathMask ),;
                  right( cPathMask, len( cPathMask ) - i ),;
                  if( i := at(":", cPathMask ) > 0,;
                      right( cPathMask, len( cPathMask ) - i ),;
                      cPathMask ) ) )

//---------------------------------------------------------------------------//

function cFileMask( cPathMask ) // devuelve Mascara de un filename
                                // ej. de "c:\dir\*.bat" devuelve "*.BAT"
                                // ojo que si NO es una mascara devolver
                                // un string vaco: "".
    local cMask := cFileName( cPathMask )

return if( ( "*" $ cMask ) .or. ( "?" $ cMask ), cMask, "" )

//---------------------------------------------------------------------------//

FUNCTION cFileNoExt( cPathMask ) // ojo que si es una mascara devolver
                                 // la parte nombre de la mascara.
    local cName := alltrim( cFileName( cPathMask ) )
    local i     := at( ".", cName )

return alltrim( if( i > 0, left( cName, i-1 ), cName ) )

//---------------------------------------------------------------------------//

FUNCTION cFileExt( cPathMask ) // ojo que si es una mascara devolver
                               // la parte extensin de la mascara.

    local cExt := alltrim( cFilename( cPathMask ) )
    local i    := rat( ".", cExt )

return alltrim( if( i > 0 .and. len( cExt ) > i,;
                    right( cExt, len( cExt ) - i ), "" ) )

//---------------------------------------------------------------------------//

/******
  Devuelve el subdirectorio del Path recibido.
*/
FUNCTION cFileSubDir( cPath )   // el Path puede terminar en "\"
                                // ej: de "C:\MIPATH\subdir\" -> "C:\MIPATH\"
                                // ej: de "C:\MIPATH\subdir"  -> "C:\MIPATH\"

return upper( cFilePath( if( right( cPath, 1 ) == "\" ,;   // me han dado un path terminado en "\"
                      left( cPath, len( cPath ) - 1 ),;
                      cPath ) ) )

//---------------------------------------------------------------------------//
