#include "FiveWin.ch"

//----------------------------------------------------------------------------//

CLASS TFile

   PROTECT DATA cName   AS CHARACTER
   HIDE    DATA cStruct AS CHARACTER

   MESSAGE New( cFileName )      EXTERN TFNew
   MESSAGE Open( nOpenMode )     EXTERN TFOpen
   MESSAGE Create( nCreateMode ) EXTERN TFCreate
   MESSAGE Close()               EXTERN TFClose
   MESSAGE GoTop()               EXTERN TFGoTop
   MESSAGE RecNo()               EXTERN TFRecNo
   MESSAGE GoBottom()            EXTERN TFGoBottom
   MESSAGE Skip( nRecords )      EXTERN TFSkip
   MESSAGE ReadLN()              EXTERN TFReadLN
   MESSAGE LastRec()             EXTERN TFLastRec
   MESSAGE lEof()                EXTERN TFlEof
   MESSAGE lBof()                EXTERN TFlBof
   MESSAGE Eof()                 EXTERN TFlEof
   MESSAGE Bof()                 EXTERN TFlBof
   MESSAGE GoTo( nRecord )       EXTERN TFGoTo
   MESSAGE WriteLN( cRecord, lInsert ) EXTERN TFWriteLN
   MESSAGE Append( nRecords )    EXTERN TFAppend
   MESSAGE Delete( nRecords )    EXTERN TFDelete
   MESSAGE Insert( nRecords )    EXTERN TFInsert

   METHOD AppendLn( cLine ) INLINE ::Append(), ::WriteLn( cLine, .f. )

   METHOD Seek( cText )

   __TFInit()

ENDCLASS

//---------------------------------------------------------------------------//

METHOD Seek( cText, nOffSet )  // -> If found, GoTo that position

    local nRec      := ::RecNo()
    local cLine
    local nAt       := 0

    if ! empty( cText )

        DEFAULT nOffSet := 1

        cLine := ::ReadLN()

        nOffSet := max( 1, Min( Len( cLine ), nOffSet ) )

        cLine := substr( cLine, nOffSet, len( cLine ) - nOffSet + 1 )

        while ( nAt := AT( cText, cLine ) ) == 0 .and. !::lEof()
            ::Skip( 1 )
            cLine := ::ReadLN()
        end

        if nAt == 0
           ::GoTo( nRec )
        endif

    endif

return nAt

//---------------------------------------------------------------------------//
