// Sample developed by a FiveWin user

/*
Ŀ
                                                                             
 Program    : EMail                                                          
 Author     : Jon Kilburn                                                    
 Date       : March 20, 1994                                                 
 Notes      : This is a demo of how to create a working windows application  
              In FiveWin.  This is _NOT_ meant to be a classy EMail system   
              in fact it is to be a viewed as an example of how easy         
              FiveWin is to learn.  Make any modification to the program     
              that you wish.  It uses both DIALOGs created on the fly and    
              DIALOGs extracted from inside the EMAIL.DLL                    
                                                                             
              This program is release to the Public Domain                   
                                                                             
 Libraries  : FiveWin                                                        
              WinApi                                                         
                                                                             
ٱ
 
*/

#include "COMMON.CH"
#include "FIVEWIN.CH"

#define  CRLF chr(13) + chr(10)

/*
 N O T I C E Ŀ
                                                                             
 The following are defines to associate to windows dialog item IDs.  This    
 is a standard practice for use with a dialog script.  The reason that this  
 is done is so that the code can be more easily read.  Since many dialogs    
 will often be created with the same numbers these Unique IDs make your      
 code more readable and allow easy assocation between the dialogs and there  
 controls.  For this example I just used the PreFix ID_ (since this is a     
 small app). For larger apps with many dialogs you should use a descriptive  
 prefix such as (in the case of the add mail dialog) ADD_ etc.               
                                                                             
ٱ
  
*/

// Defines for Add Mail
#define  ID_DATE     1000
#define  ID_SUBJECT  1001
#define  ID_GDATE    8000
#define  ID_GSUBJECT 8001
#define  ID_GMEMO    8002
#define  ID_SENDB    9000
#define  ID_CANCELB  9001

// Defines for Listbox (Select User)
#define  ID_LISTBOX  8000
#define  ID_OKBUT    9000
#define  ID_CANCBUT  9001

// Defines for Read Mail
#define ID_NEXT      9000
#define ID_PREV      9001
#define ID_DELETE    9002
#define ID_CANCELR   9003


STATIC oWnd

/*
!short: FUNCTION Brain() */
FUNCTION Brain()
/*
Ŀ
                                                                             
 Function   : Brain()--> NIL                                                 
 Programmer : Jon Kilburn                                                    
 Date       : March 20, 1994                                                 
 Modified   :                                                                
 Purpose    : Main procedure...                                              
 Parameters : None                                                           
 Returns    : NIL                                                            
 Libraries  : FiveWin                                                        
 DataBases  : None                                                           
                                                                             
ٱ
  
*/
LOCAL           ;
      oBar,     ;
      oBrush,   ;
      oIcon

   OpenFiles(.T.)

   SET 3DLOOK ON
   IF LogOn()

      DEFINE BRUSH oBrush STYLE BRICKS
      DEFINE ICON  oIcon  FILE "MAIL.ICO"

      DEFINE WINDOW oWnd FROM 1, 5 TO 20, 65   ;
             BRUSH oBrush                      ;
             TITLE "E-Mail System version 1.0" ;
             ICON  oIcon                       ;
             MENU  BuildMenu()

      DEFINE BUTTONBAR oBar OF oWnd

      DEFINE BUTTON FILE "Exit.bmp" OF oBar MESSAGE "Exit E-Mail System" ;
      ACTION IF(MsgYesNo("Do you wish to exit E-Mail?", "Exit"),oWnd:end(),)

      DEFINE BUTTON FILE "File.bmp" OF oBar MESSAGE  "Read E-Mail" ;
      ACTION ReadMail()

      DEFINE BUTTON FILE "Edit.bmp" OF oBar MESSAGE  "Add New E-Mail Message" ;
      ACTION AddMail()

      DEFINE BUTTON FILE "Link.bmp" OF oBar MESSAGE "Remove Deleted Records" ;
      ACTION PackFile()

      DEFINE BUTTON FILE "Printer.bmp" OF oBar MESSAGE "Printer Setup" ;
      ACTION TPrinter():New("Test")

      DEFINE BUTTON FILE "Help.bmp" OF oBar MESSAGE "Help on E-Mail" ;
      ACTION winhelp("winhelp.hlp")

      SET MESSAGE OF oWnd TO ""
      ACTIVATE WINDOW oWnd MAXIMIZED
   ENDIF

   OpenFiles(.F.)
   SET 3DLOOK OFF

RETURN nil


/*
!short: STATIC FUNCTION OpenFiles(open) */

STATIC FUNCTION OpenFiles(open)
/*
Ŀ
                                                                             
 Function   : OpenFiles( [open] )--> NIL                                     
 Programmer : Jon Kilburn                                                    
 Date       : March 20, 1994                                                 
 Modified   :                                                                
 Purpose    : Open all the database and index files associated to the EMAIL  
              System.  If any of the files don't exist create them (this     
              includes both database and index files)                        
 Parameters : open -- Logical open/close files flag                          
 Returns    : NIL                                                            
 Libraries  : FiveWin                                                        
 DataBases  : USER -- Database of all Email Users                            
              MAIL -- Database of all Email Messages                         
                                                                             
ٱ
  
*/
LOCAL           ;
     aStru

   IF open
      IF ! file("USER.DBF")
         aStru := {                           ;
                    {"Name",     "C", 20, 0}, ;
                    {"User",     "C",  3, 0}, ;
                    {"Title",    "C", 20, 0}  ;
                  }
         dbcreate("USER", aStru)
         USE USER NEW EXCLUSIVE
         IF ! neterr()
            INDEX ON FIELD->Name TO USER
         ELSE
            MsgInfo("Unable to Create User File Index!","Fatal Error")
            CLOSE ALL
            QUIT
         ENDIF
         CLOSE ALL

         SELECT 1
         USE USER INDEX USER SHARED NEW
      ELSE
         IF ! file("USER.NTX")
            USE USER EXCLUSIVE
            IF ! neterr()
               INDEX ON FIELD->Name TO USER
               CLOSE ALL
               SELECT 1
               USE USER INDEX USER SHARED NEW
            ELSE
               MsgInfo("Unable to Create User File Index!","Fatal Error")
               CLOSE ALL
               QUIT
            ENDIF
         ENDIF

         SELECT 1
         USE USER INDEX USER SHARED NEW
      ENDIF

      IF ! file("MAIL.DBF")
         aStru := {                          ;
                    {"User",    "C",  3, 0}, ;
                    {"Mail",    "M", 10, 0}, ;
                    {"Subject", "C", 20, 0}, ;
                    {"Date",    "D",  8, 0}, ;
                    {"Read",    "L",  1, 0}  ;
                  }
         dbcreate("MAIL", aStru)
         SELECT 2
         USE MAIL NEW EXCLUSIVE
         IF ! neterr()
            INDEX ON MAIL->User TO MAIL
         ELSE
            MsgInfo("Unable to Create Mail File Index!","Fatal Error")
            CLOSE ALL
            QUIT
         ENDIF
         MAIL->(dbclosearea())

         SELECT 2
         USE MAIL INDEX MAIL SHARED NEW
      ELSE
         IF ! file("MAIL.NT")
            SELECT 2
            USE MAIL EXCLUSIVE NEW
            IF ! neterr()
               INDEX ON MAIL->User TO MAIL
            ELSE
               MsgInfo("Unable to Create Mail File Index!","Fatal Error")
               CLOSE ALL
               QUIT
            ENDIF
            MAIL->(dbclosearea())
         ENDIF

         SELECT 2
         USE MAIL INDEX MAIL SHARED NEW
      ENDIF
   ELSE
       CLOSE ALL
   ENDIF

RETURN nil


/*
!short: STATIC FUNCTION LogOn() */

STATIC FUNCTION LogOn()
/*
Ŀ
                                                                             
 Function   : LogOn()--> success                                             
 Programmer : Jon Kilburn                                                    
 Date       : March 20, 1994                                                 
 Modified   :                                                                
 Purpose    : Get the current user so they can read there mail               
 Parameters : None                                                           
 Returns    : NIL                                                            
 Libraries  : FiveWin                                                        
 DataBases  : USER                                                           
                                                                             
ٱ
  
*/
LOCAL           ;
      lReturn,  ;
      oDlg,     ;
      cName

   lReturn := .T.
   cName   := space(22)

   IF ! USER->(lastrec()) < 1
      DEFINE DIALOG oDlg FROM 5,5 TO 11, 29 TITLE "User Logon"

      @ 0.2, 1 SAY "User Name.." OF oDlg
      @ 1.2, 1 GET cName OF oDlg PICTURE "@!"

      // Define the Action Associated to the OK Button
      @ 2.7, 1 BUTTON "&Ok"  OF oDlg SIZE 40,12                              ;
      ACTION  (USER->(dbseek(trim(cName))),                                  ;
           IF(! USER->(found()), MsgInfo("Name Not Found!", "Error"),),          ;
           oDlg:end())

      //- Define the Action Associated to the Cancel Button
      @ 2.7, 7 BUTTON "&Cancel" OF oDlg SIZE 40, 12 ACTION oDlg:end()

      ACTIVATE DIALOG oDlg CENTERED
      IF ! USER->(found())
         lReturn := .F.
      ELSE
         SetRead(.T.)
         IF MAIL->(dbseek(USER->User))
            MsgInfo("You have Mail waiting", "Mail Found")
         ENDIF
      ENDIF
   ENDIF

RETURN lReturn


/*
!short: STATIC FUNCTION SetRead(set) */

STATIC FUNCTION SetRead(set)
/*
Ŀ
                                                                             
 Function   : SetRead( set )--> cUser                                        
 Programmer : Jon Kilburn                                                    
 Date       : March 20, 1994                                                 
 Modified   :                                                                
 Purpose    : Store the user initials to seek into the MAIL file             
 Parameters : set -- Logical set the user flag                               
 Returns    : NIL                                                            
 Libraries  : FiveWin                                                        
 DataBases  : USER                                                           
                                                                             
ٱ
  
*/
STATIC          ;
      cUser

    DEFAULT set TO FALSE

    IF set
       cUser := USER->User
    ENDIF

RETURN cUser


/*
!short: STATIC FUNCTION BuildMenu() */

STATIC FUNCTION BuildMenu()
/*
Ŀ
                                                                             
 Function   : BuildMenu()--> oMenu                                           
 Programmer : Jon Kilburn                                                    
 Date       : March 20, 1994                                                 
 Modified   :                                                                
 Purpose    : Creates the menu object [ oMenu ] and returns it.              
 Parameters : None                                                           
 Returns    : NIL                                                            
 Libraries  : FiveWin                                                        
 DataBases  : None                                                           
                                                                             
ٱ
  
*/
LOCAL           ;
     oMenu

   // Define the Menu Object
   MENU oMenu

      //- Create a File Option and Sub menu Options
      MENUITEM "&File"
      MENU
         MENUITEM "&Read Mail" MESSAGE "Read E-Mail" ;
         ACTION ReadMail()

         MENUITEM "&Add Mail" MESSAGE "Add New E-Mail Message" ;
         ACTION AddMail()

         MENUITEM "&Pack File" MESSAGE "Remove Deleted Records" ;
         ACTION PackFile()

         SEPARATOR

         MENUITEM "&Exit" MESSAGE "Exit E-Mail System" ;
         ACTION IF(MsgYesNo("Do you wish to exit E-Mail?", "Exit"),oWnd:end(),)
      ENDMENU

      // Creates A Users Menu Option
      MENUITEM "&Users"
      MENU
         MENUITEM "&Add" MESSAGE "Add a New E-Mail User" ;
         ACTION AddUser()

         MENUITEM "&Modify" MESSAGE "Modify An Existing E-Mail User";
         ACTION USER->(Browse("User Database", "", { || AddUser(.T.) },   ;
                             { || DelUser() }, { || FindUser() }))

      ENDMENU

      // Print Menu Options
      MENUITEM "&Print"
      MENU
         MENUITEM "&Print All" MESSAGE "Print all E-Mail" ;
         ACTION MsgInfo("Print All", "")

         MENUITEM "Print &Range" MESSAGE "Print E-Mail for a Date Range" ;
         ACTION MsgInfo("Print Range", "")

         // Access the Printer Control Dialog
         MENUITEM "&Setup..." MESSAGE "Printer Setup" ;
         ACTION TPrinter():New("Test")
      ENDMENU

      // Create a Help Option and Sub menu Options
      MENUITEM "&Help"
      MENU
         MENUITEM "&How To Use Help" ;
         MESSAGE "How To Use Windows Help" ACTION winhelp("winhelp.hlp")

         SEPARATOR

         MENUITEM "&About E-Mail..." ;
         MESSAGE "About the FiveWin E-Mail System"         ;
         ACTION MsgInfo("FiveWin E-Mail System" + CRLF +  ;
                    "Written By Jon Kilburn" + CRLF +      ;
                    "Version 1.0", "About")
     ENDMENU

   ENDMENU

RETURN oMenu


/*
!short: STATIC FUNCTION AddUser(modify) */

STATIC FUNCTION AddUser(modify)
/*
Ŀ
                                                                             
 Function   : AddUser( [modify] )--> NIL                                     
 Programmer : Jon Kilburn                                                    
 Date       : March 20, 1994                                                 
 Modified   :                                                                
 Purpose    : Add or Modify a User to the USERS database                     
 Parameters : modify -- Logical flag for Modify/Add Mode                     
 Returns    : NIL                                                            
 Libraries  : FiveWin                                                        
 DataBases  : USER                                                           
                                                                             
ٱ
  
*/
LOCAL           ;
     oDlg,      ;
     cName,     ;
     oName,     ;
     cUser,     ;
     oUser,     ;
     cTitle,    ;
     oTitle,    ;
     cStatus

   DEFAULT modify TO FALSE

   IF ! modify
      cName  := space(20)
      cUser  := space(3)
      cTitle := space(20)
   ELSE
      cName  := USER->Name
      cUser  := USER->User
      cTitle := USER->Title
   ENDIF

   DEFINE DIALOG oDlg FROM 5,5 TO 13, 55 TITLE "Add New User"

   @ 1, 1 SAY "&Name" OF oDlg
   @ 1, 8 GET oName VAR cName OF oDlg PICTURE "@!"

   @ 2, 1 SAY "&User Id" OF oDlg
   @ 2, 8 GET oUser VAR cUser OF oDlg PICTURE "!!!" SIZE 20,11

   @ 3, 1 SAY "&Title" OF oDlg
   @ 3, 8 GET oTitle VAR cTitle OF oDlg PICTURE "@!"

   @ 1, 21.2 BUTTON "&Ok" OF oDlg SIZE 40, 12   ;
   ACTION ( oName:refresh(),  ;
            oUser:refresh(),  ;
            oTitle:refresh(), ;
            UpdateUser(cName, cUser, cTitle, modify, oDlg) )

   @ 2.3, 21.2 BUTTON "&Cancel" OF oDlg SIZE 40, 12 ;
   ACTION oDlg:end()

   ACTIVATE DIALOG oDlg CENTERED WAIT

RETURN nil


/*
!short: STATIC FUNCTION UpdateUser(cName, cUser, cTitle, modify, oDlg) */

STATIC FUNCTION UpdateUser(cName, cUser, cTitle, modify, oDlg)
/*
Ŀ
                                                                             
 Function   : UpdateUser( cName, cUser, cTitle, modify, oDlg )--> NIL        
 Programmer : Jon Kilburn                                                    
 Date       :                                                                
 Modified   :                                                                
 Purpose    : Save the current Dialog Contents to the USER file              
 Parameters : cName  -- Name of the User                                     
              cUser  -- User Initials                                        
              cTitle -- Title of the User                                    
              modify -- Logical modify flag (Determines if APPEND is called) 
              oDlg   -- Dialog Object                                        
 Returns    : NIL                                                            
 Libraries  : FiveWin                                                        
 DataBases  : USER                                                           
                                                                             
ٱ
  
*/

   DEFAULT modify TO FALSE

   IF ! modify
      USER->(dbgobottom())
      USER->(dbappend())
      IF USER->(rlock())
         USER->Name     := cName
         USER->User     := cUser
         USER->Title    := cTitle
         USER->(dbunlock())
      ELSE
         MsgInfo("Unable to update User File!", "Add Error")
      ENDIF
   ELSE
      IF USER->(rlock())
         USER->Name     := cName
         USER->User     := cUser
         USER->Title    := cTitle
         USER->(dbunlock())
      ELSE
         MsgInfo("Unable to update User File!", "Modify Error")
      ENDIF
   ENDIF

   oDlg:end()

RETURN nil


/*
!short: STATIC FUNCTION Browse(cTitle, cListName, bModify, bDelete, bSearch) */

STATIC FUNCTION Browse(cTitle, cListName, bModify, bDelete, bSearch)
/*
Ŀ
                                                                             
 Function   : Browse( cTitle, cListName, bModify, bDelete, bSearch )--> NIL  
 Programmer : Jon Kilburn                                                    
 Date       :                                                                
 Modified   :                                                                
 Purpose    : Browse the USER database                                       
 Parameters : cTitle    -- Title of the Browse window                        
              cListName -- Title of the Listbox                              
              bModify   -- Modify Code Block                                 
              bDelete   -- Delete Code Block                                 
              bSearch   -- Search Code Block                                 
 Returns    : NIL                                                            
 Libraries  : FiveWin                                                        
 DataBases  : USER                                                           
                                                                             
ٱ
  
*/
LOCAL           ;
    oDlg,       ;
    oLbx,       ;
    btnModify,  ;
    btnDelete,  ;
    btnSearch,  ;
    btnEnd

   // File Is Empty
   IF USER->(lastrec()) < 1
      MsgInfo("User file is currently Empty!" + CRLF + ;
          "Please add a User First", "Error")
      return NIL
   ENDIF


   DEFINE DIALOG oDlg FROM 3, 3 TO 26, 79 TITLE cTitle

   @ 0,  1 SAY cListName  OF oDlg

   @ 1, 1 LISTBOX oLbx FIELDS USER->Name, USER->User, USER->Title ;
      HEADERS "User Name", "User Id", "User Title"   ;
      SIZE 284, 137  OF oDlg

   @ 13,  8 BUTTON btnModify PROMPT "&Modify" OF oDlg SIZE 40, 12
   @ 13, 15 BUTTON btnDelete PROMPT "&Delete" OF oDlg SIZE 40, 12
   @ 13, 22 BUTTON btnSearch PROMPT "&Search" OF oDlg SIZE 40, 12
   @ 13, 29 BUTTON btnEnd    PROMPT "&Exit"   OF oDlg SIZE 40, 12

   btnModify:bAction = If( bModify != nil,;
                           { || Eval( bModify ),;
                           oLbx:Refresh(), oLbx:SetFocus( .t. ) },)

   btnDelete:bAction = If( bDelete != nil,;
                           { || Eval( bDelete ),;
                           oLbx:Refresh(), oLbx:SetFocus( .t. ) },)

   btnSearch:bAction = If( bSearch != nil,;
                           { || Eval( bSearch ),;
                           oLbx:Refresh(), oLbx:SetFocus( .t. ) },)

   btnEnd:bAction    = { || oDlg:End() }

   ACTIVATE DIALOG oDlg

RETURN nil


/*
!short: STATIC FUNCTION DelUser() */

STATIC FUNCTION DelUser()
/*
Ŀ
                                                                             
 Function   : DelUser()--> NIL                                               
 Programmer : Jon Kilburn                                                    
 Date       : March 20, 1994                                                 
 Modified   :                                                                
 Purpose    : Nuclear Assault on a user...Total destruction..(Delete)        
 Parameters : None                                                           
 Returns    : NIL                                                            
 Libraries  : FiveWin                                                        
 DataBases  : USER                                                           
                                                                             
ٱ
  
*/

   IF ! USER->(deleted())
      IF MsgYesNo("Delete this Record?", "Delete")
         IF USER->(rlock())
            USER->(dbdelete())
            USER->(dbunlock())
         ENDIF
      ENDIF
   ELSE
      IF MsgYesNo("Recall this Record?", "Recall")
         IF USER->(rlock())
            USER->(dbrecall())
            USER->(dbunlock())
         ENDIF
      ENDIF
   ENDIF

RETURN nil


/*
!short: STATIC FUNCTION FindUser() */

STATIC FUNCTION FindUser()
/*
Ŀ
                                                                             
 Function   : FindUser()--> NIL                                              
 Programmer : Jon Kilburn                                                    
 Date       : March 20, 1994                                                 
 Modified   :                                                                
 Purpose    : Opens a Search Dialog and SEEKs the for a user                 
 Parameters : None                                                           
 Returns    : NIL                                                            
 Libraries  : FiveWin                                                        
 DataBases  : USER                                                           
                                                                             
ٱ
  
*/
LOCAL           ;
      oDlg,     ;
      oSearch,  ;
      oBmp,     ;
      cSearch,  ;
      nRec,     ;
      btnOk,    ;
      btnCancel

   nRec := USER->(recno())
   cSearch := space(22)

   DEFINE DIALOG oDlg FROM 5,5 TO 11, 38 TITLE "Search"

   @ 0.2, 5 SAY "Search for User.." OF oDlg
   @ 1.2, 5 GET cSearch OF oDlg PICTURE "@!"
   @ 0.5, 1 BITMAP oBmp FILE "GLASS.BMP" SIZE 21,21 OF oDlg

   // Define the Action Associated to the OK Button
   @ 2.7, 3 BUTTON "&Ok"  OF oDlg SIZE 44,12                                 ;
   ACTION  (USER->(dbseek(cSearch)),                                         ;
           IF(USER->(eof()), MsgInfo("Name Not Found!", "Search Failed"),),  ;
           oDlg:end())

   // Define the Action Associated to the Cancel Button
   @ 2.7, 11 BUTTON "&Cancel" OF oDlg SIZE 44, 12 ACTION oDlg:end()

   ACTIVATE DIALOG oDlg CENTERED

   IF USER->(eof())
      USER->(dbgoto(nRec))
   ENDIF

RETURN nil


/*
!short: STATIC FUNCTION AddMail() */

STATIC FUNCTION AddMail()
/*
Ŀ
                                                                             
 Function   : AddMail()--> NIL                                               
 Programmer : Jon Kilburn                                                    
 Date       : March 20, 1994                                                 
 Modified   :                                                                
 Purpose    : Opens a Add / Read Dialog                                      
 Parameters : None                                                           
 Returns    : NIL                                                            
 Libraries  : FiveWin                                                        
 DataBases  : None                                                           
                                                                             
ٱ
  
*/
LOCAL           ;
      cMemo,    ;
      oMemo,    ;
      oDate,    ;
      cDate,    ;
      oSubject, ;
      cSubject, ;
      oDlg

   cMemo    := space(10)
   cDate    := date()
   cSubject := space(20)


   SET RESOURCES TO "EMAIL.DLL"
   DEFINE DIALOG oDlg RESOURCE "MAIL"  TITLE "Add Mail"

   REDEFINE SAY ID ID_DATE    OF oDlg
   REDEFINE SAY ID ID_SUBJECT OF oDlg

   REDEFINE GET oDate    VAR cDate ID   ID_GDATE       OF oDlg PICTURE "99/99/99"
   REDEFINE GET oSubject VAR cSubject   ID ID_GSUBJECT OF oDlg PICTURE "@!"
   REDEFINE GET oMemo    VAR cMemo MEMO ID ID_GMEMO    OF oDlg

   REDEFINE BUTTON ID ID_SENDB OF oDlg             ;
   ACTION IF(SelectUser(cMemo, cDate, cSubject),   ;
             oDlg:end(), setfocus(oDlg:oMenu))

   REDEFINE BUTTON ID ID_CANCELB OF oDlg ACTION oDlg:end()

   ACTIVATE DIALOG oDlg CENTER

   SET RESOURCES TO

RETURN nil

/*
!short: STATIC FUNCTION SelectUser(cMemo, cDate, cSubject) */

STATIC FUNCTION SelectUser(cMemo, cDate, cSubject)
/*
Ŀ
                                                                             
 Function   : SelectUser( cMemo )--> nReturn                                 
 Programmer : Jon Kilburn                                                    
 Date       : March 20, 1994                                                 
 Modified   :                                                                
 Purpose    : Reads the USER file into a STATIC array for placement in a     
              LISTBOX for selection.  After the users to recieve the EMail   
              have been selected the mail is then copied for each of the     
              Users who are selected                                         
 Parameters : cMemo -- The Mail to be sent to each user                      
 Returns    : NIL                                                            
 Libraries  : FiveWin                                                        
 DataBases  : USER                                                           
                                                                             
ٱ
  
*/
STATIC          ;
      aUsers_

LOCAL           ;
      aSel,     ;
      block,    ;
      oDlg,     ;
      oLbx,     ;
      cLbx,     ;
      nRec,     ;
      nPos,     ;
      nReturn

   DEFAULT nReturn TO TRUE
   DEFAULT aUsers_ TO {}

   IF empty(aUsers_)
      nRec := USER->(recno())
      USER->(dbgotop())
      DO WHILE ! USER->(eof())
         aadd(aUsers_, USER->Name)
         USER->(dbskip())
      ENDDO
      USER->(dbgoto(nRec))
   ENDIF

   IF ! empty(cMemo)
      aSel  := {}
      block := { || adel(aSel, nPos), asize(aSel, len(aSel)-1) }

      DEFINE DIALOG oDlg RESOURCE "USER_LIST"

      /*
       N O T I C E Ŀ
                                                                             
       The following lines of code are used to handle a multiple selection   
       listbox.  The listbox has been defined as a MULTIPLE SELECTION when   
       it was created in BORLAND.  Using the ON CHANGE command I scan the    
       aSel array to see if I can locate the cLbx variable (ON CHANGE places 
       the selected text value in the variable declared with the VAR <cLbx>  
       statement).  IF cLbx isn't found in the aSel array then add it else   
       delete it because it has been de-selected.                            
                                                                             
      ٱ
        
      */

      REDEFINE LISTBOX oLbx VAR cLbx ITEMS aUsers_             ;
      ID ID_LISTBOX ON CHANGE                                  ;
      ( IF((nPos := ascan(aSel, cLbx)) == 0, aadd(aSel, cLbx), ;
            eval(block)) ) OF oDlg

      REDEFINE BUTTON ID ID_OKBUT   OF oDlg                    ;
      ACTION ( Send(aSel, cMemo, cDate, cSubject), oDlg:end()  )

      REDEFINE BUTTON ID ID_CANCBUT OF oDlg ACTION oDlg:end()
      ACTIVATE DIALOG oDlg CENTER
   ELSE
      tone(440, 2)
      MsgInfo("You Cannot Send An Empty Message" + CRLF +      ;
              "Please Enter Mail or Cancel", "Error")
      nReturn := .F.
   ENDIF

RETURN nReturn


/*
!short: STATIC FUNCTION Send(aSel, cMemo, cDate, cSubject) */

STATIC FUNCTION Send(aSel, cMemo, cDate, cSubject)
/*
Ŀ
                                                                             
 Function   : Send( aSel )--> NIL                                            
 Programmer : Jon Kilburn                                                    
 Date       : March 20, 1994                                                 
 Modified   :                                                                
 Purpose    : Scans the aSel array and seeks into the USER database for the  
              selected users USERID.  The USERID is the key in the MAIL      
              database.  So create a copy of the Email message for each      
              Users who is selected                                          
 Parameters : cMemo -- The Mail to be sent to each user                      
 Returns    : NIL                                                            
 Libraries  : FiveWin                                                        
 DataBases  : MAIL                                                           
                                                                             
ٱ
  
*/
LOCAL           ;
      i

    FOR i := 1 TO len(aSel)
       USER->(dbseek(alltrim(aSel[i])))
       MAIL->(dbappend())
       MAIL->(rlock())
       MAIL->User    := USER->User
       MAIL->Mail    := cMemo
       MAIL->Subject := cSubject
       MAIL->Date    := cDate
       MAIL->(dbunlock())
    NEXT i

RETURN nil


/*
!short: STATIC FUNCTION ReadMail() */

STATIC FUNCTION ReadMail()

/*
Ŀ
                                                                             
 Function   : ReadMail()--> NIL                                              
 Programmer : Jon Kilburn                                                    
 Date       : March 20, 1994                                                 
 Modified   :                                                                
 Purpose    : Searches for the first Unread message and displays it.         
 Parameters : None                                                           
 Returns    : NIL                                                            
 Libraries  : FiveWin                                                        
 DataBases  : MAIL                                                           
                                                                             
ٱ
  
*/
LOCAL           ;
      cMemo,    ;
      oMemo,    ;
      cDate,    ;
      oDate,    ;
      cSubject, ;
      oSubject, ;
      cUser,    ;
      oDlg

   cUser := SetRead()

   IF cUser == NIL
      MsgStop("No user is currently active!", "Error")
      RETURN nil
   ENDIF

   IF ! MAIL->(dbseek(SetRead()))
      MsgStop("You have no mail in your mailbox!", "Error")
      RETURN nil
   ELSE
      IF MAIL->(rlock())
         MAIL->Read := .T.
         MAIL->(dbunlock())
      ENDIF
   ENDIF

   cMemo    := MAIL->Mail
   cDate    := MAIL->Date
   cSubject := MAIL->Subject

   SET RESOURCES TO "EMAIL.DLL"
   DEFINE DIALOG oDlg RESOURCE "READ"  TITLE "Read Mail"

   REDEFINE SAY ID ID_DATE    OF oDlg
   REDEFINE SAY ID ID_SUBJECT OF oDlg

   REDEFINE GET oDate    VAR cDate ID   ID_GDATE       OF oDlg PICTURE "99/99/99"
   REDEFINE GET oSubject VAR cSubject   ID ID_GSUBJECT OF oDlg PICTURE "@!"
   REDEFINE GET oMemo    VAR cMemo MEMO ID ID_GMEMO    OF oDlg

   REDEFINE BUTTON ID ID_NEXT OF oDlg                     ;
   ACTION ( Next(),                                       ;
            cDate    := MAIL->Date,    oDate:Refresh(),   ;
            cSubject := MAIL->Subject, oSubject:Refresh(),;
            cMemo    := MAIL->Mail,    oMemo:Refresh()    )

   REDEFINE BUTTON ID ID_PREV OF oDlg                     ;
   ACTION ( Prev(),                                       ;
            cDate    := MAIL->Date,    oDate:Refresh(),   ;
            cSubject := MAIL->Subject, oSubject:Refresh(),;
            cMemo    := MAIL->Mail,    oMemo:Refresh()    )

   REDEFINE BUTTON ID ID_DELETE  OF oDlg ACTION DelMail()
   REDEFINE BUTTON ID ID_CANCELR OF oDlg ACTION oDlg:end()

   ACTIVATE DIALOG oDlg CENTER

   SET RESOURCES TO

RETURN nil

/*
!short: STATIC FUNCTION DelMail() */

STATIC FUNCTION DelMail()
/*
Ŀ
                                                                             
 Function   : DelMail()--> NIL                                               
 Programmer : Jon Kilburn                                                    
 Date       : March 20, 1994                                                 
 Modified   :                                                                
 Purpose    : Delete a current Email Record.                                 
 Parameters : None                                                           
 Returns    : NIL                                                            
 Libraries  : FiveWin                                                        
 DataBases  : MAIL                                                           
                                                                             
ٱ
  
*/
   IF MsgYesNo("Delete this Mail", "Delete")
      IF MAIL->(rlock())
         MAIL->(dbdelete())
         MAIL->(dbunlock())
      ELSE
         MsgInfo("Unable to delete this Mail", "Error")
      ENDIF
   ENDIF

RETURN nil

/*
!short: STATIC FUNCTION Next() */

STATIC FUNCTION Next()
/*
Ŀ
                                                                             
 Function   : Next()--> NIL                                                  
 Programmer : Jon Kilburn                                                    
 Date       : March 20, 1994                                                 
 Modified   :                                                                
 Purpose    : Skips to the Next Record in the MAIL database and checks to    
              see if the message belongs to the current user.                
 Parameters : None                                                           
 Returns    : NIL                                                            
 Libraries  : FiveWin                                                        
 DataBases  : MAIL                                                           
                                                                             
ٱ
  
*/
    MAIL->(dbskip())
    IF MAIL->User != SetRead()
       MsgInfo("No more mail left for you to read", "End of Mail")
       MAIL->(dbskip(-1))
    ELSE
       IF MAIL->(rlock())
          MAIL->Read := .T.
          MAIL->(dbunlock())
       ENDIF
    ENDIF

RETURN nil


/*
!short: STATIC FUNCTION Prev() */

STATIC FUNCTION Prev()
/*
Ŀ
                                                                             
 Function   : Prev()--> NIL                                                  
 Programmer : Jon Kilburn                                                    
 Date       : March 20, 1994                                                 
 Modified   :                                                                
 Purpose    : Skips to the Prev Record in the MAIL database and checks to    
              see if the message belongs to the current user.                
 Parameters : None                                                           
 Returns    : NIL                                                            
 Libraries  : FiveWin                                                        
 DataBases  : MAIL                                                           
                                                                             
ٱ
  
*/
    MAIL->(dbskip(-1))
    IF MAIL->User != SetRead()
       MsgInfo("No more mail left for you to read", "End of Mail")
       MAIL->(dbskip())
    ELSE
       IF MAIL->(rlock())
          MAIL->Read := .T.
          MAIL->(dbunlock())
       ENDIF
    ENDIF

RETURN nil

/*
!short: FUNCTION PackFile() */

FUNCTION PackFile()
/*
Ŀ
                                                                             
 Function   : PackFile()--> NIL                                              
 Programmer : Jon Kilburn                                                    
 Date       : March 20, 1994                                                 
 Modified   :                                                                
 Purpose    : Attempts to open the MAIL file in EXCLUSIVE mode and then      
              PACKs the file to remove delete Mail.                          
 Parameters : None                                                           
 Returns    : NIL                                                            
 Libraries  : FiveWin                                                        
 DataBases  : MAIL                                                           
                                                                             
ٱ
  
*/
   MAIL->(dbclosearea())

   // Attempt to open the file in exclusive
   SELECT 2
   USE MAIL INDEX MAIL EXCLUSIVE NEW

   IF neterr()
      MsgInfo("File is currently in use by another User", "Lock Error")
      SELECT 2
      USE MAIL INDEX MAIL SHARED NEW
      RETURN nil
   ENDIF

   PACK

   MAIL->(dbclosearea())

   SELECT 2
   USE MAIL INDEX MAIL SHARED NEW

RETURN nil
