#include "Fivewin.ch"
#include "Dbms.ch"
#include "DataBase.ch"
#include "Dict.ch"

//----------------------------------------------------------------------------//

function DictOpen( cDictName )

   local oWndDb, oBar, oBrw, oIco, oWndRec, oFont, oHand
   local oWndAreas := GetWndAreas()
   local nFilter, cName
   local oBrush, oIcon
   local cAlias := "DICT_DBs"

   DEFINE ICON oIcon RESOURCE "Database"


   if Empty( cDictName )
      cDictName := cGetFile( "Dictionary databases ("+EXT_DBS+") | *"+EXT_DBS+" |", ;
                             "Select a Dictionary to use" )
   endif

   if ! Empty( cDictName )
   
	  cName:= cNoExt( cDictName )
	  
	  if ! File( cDictName )
	  	 DbCreate( cDictName, aSTRU_DB )
	  endif

      USE ( cName + EXT_DBS ) NEW SHARED ALIAS ( cAlias )

      DEFINE ICON oIco RESOURCE "DataBase"

      DEFINE WINDOW oWndDb FROM 1, 1 TO 23, 33 ;
         TITLE "Database Dictionary: " + cName ;
         ICON oIcon MDICHILD

      DEFINE BUTTONBAR oBar OF oWndDb

      DEFINE BUTTON RESOURCE "New" OF oBar ;
         ACTION ( oBrw:RecAdd(), oBrw:Refresh() ) ;
         MESSAGE "Add a new record"

      DEFINE BUTTON RESOURCE "Edit" OF oBar ;
         MESSAGE "Edit current record" ;
         ACTION  oWndRec := RecEdit( "Record: " + cAlias, oBrw )

      DEFINE BUTTON RESOURCE "Del" OF oBar ;
         MESSAGE "Delete current record" ;

      DEFINE BUTTON RESOURCE "Prg" GROUP OF oBar ;
         MESSAGE "Generate source code"

      DEFINE BUTTON RESOURCE "Font" GROUP OF oBar ;
         ACTION oBrw:SelFont() ;
         MESSAGE "Select a new font"

      DEFINE BUTTON RESOURCE "Clr" OF oBar ;
         ACTION ( oBrw:SelColor(),;
                  If( oWndRec != nil,;
                  oWndRec:oControl:SetColor( oBrw:nClrText, oBrw:nClrPane ),) ) ;
         MESSAGE "Select a new backcolor"

      DEFINE FONT oFont NAME "Arial" SIZE 6, 15 BOLD

      DEFINE CURSOR oHand RESOURCE "Hand"

      @ 0, 0 LISTBOX oBrw FIELDS "" OF oWndDb ;
         ON CHANGE ( If( oWndAreas != nil, oWndAreas:oControl:Refresh(),),;
                     If( oWndRec != nil, oWndRec:oControl:Refresh(),) ) ;
         ON DBLCLICK FldOpen( cName ) ;
         SIZE 400, 400 FONT oFont CURSOR oHand ;
         MESSAGE "Visual make of all the dictionary elements"

      oBrw:bLine = { | aTemp | aTemp := _aFields( cAlias ),;
                               AAdd( aTemp, nil ), AIns( aTemp, 1 ),;
                               aTemp[ 1 ] := If( ( cAlias )->( Deleted() ),;
                               "x", "X" ), aTemp }

      AAdd( oBrw:aColSizes, nil )
      AIns( oBrw:aColSizes, 1 )
      oBrw:aColSizes[ 1 ] = 16

      AAdd( oBrw:aHeaders, nil )
      AIns( oBrw:aHeaders, 1 )
      oBrw:aHeaders[ 1 ] = ""

      oWndDb:SetControl( oBrw )

      ACTIVATE WINDOW oWndDb ;
         VALID ( If( oWndRec != nil, oWndRec:End(),),;
                 oBrw:lCloseArea() )

      if oWndAreas != nil
         oWndAreas:oControl:Refresh()  // We updates the info on the WorkAreas
      endif                            // Inspector

   endif

return nil

//----------------------------------------------------------------------------//

function FldOpen( cName )

   local oWndDb, oBar, oBrw, oIco, oWndRec, oFont, oHand
   local nFilter
   local oBrush, oIcon
   local cAlias := "DICT_FLs"
   local oWndAreas := GetWndAreas()

   DEFINE ICON oIcon RESOURCE "Database"

	  if ! File( cName + EXT_FLS )
	  	 DbCreate( cName + EXT_FLS, aSTRU_FIELD )
	  endif

      USE ( cName + EXT_FLS ) NEW SHARED ALIAS ( cAlias )

      DEFINE ICON oIco RESOURCE "DataBase"

      DEFINE WINDOW oWndDb FROM 1, 1 TO 23, 33 ;
         TITLE "Fields Dictionary: " + cName ;
         ICON oIcon MDICHILD

      DEFINE BUTTONBAR oBar OF oWndDb

      DEFINE BUTTON RESOURCE "New" OF oBar ;
         ACTION ( oBrw:RecAdd(), oBrw:Refresh() ) ;
         MESSAGE "Add a new record"

      DEFINE BUTTON RESOURCE "Edit" OF oBar ;
         MESSAGE "Edit current record" ;
         ACTION  oWndRec := RecEdit( "Record: " + cAlias, oBrw )

      DEFINE BUTTON RESOURCE "Del" OF oBar ;
         MESSAGE "Delete current record" ;

      DEFINE BUTTON RESOURCE "Prg" GROUP OF oBar ;
         MESSAGE "Generate source code"


      DEFINE BUTTON RESOURCE "Font" GROUP OF oBar ;
         ACTION oBrw:SelFont() ;
         MESSAGE "Select a new font"

      DEFINE BUTTON RESOURCE "Clr" OF oBar ;
         ACTION ( oBrw:SelColor(),;
                  If( oWndRec != nil,;
                  oWndRec:oControl:SetColor( oBrw:nClrText, oBrw:nClrPane ),) ) ;
         MESSAGE "Select a new backcolor"

      DEFINE FONT oFont NAME "Arial" SIZE 6, 15 BOLD

      DEFINE CURSOR oHand RESOURCE "Hand"

      @ 0, 0 LISTBOX oBrw FIELDS "" OF oWndDb ;
         ON CHANGE ( If( oWndAreas != nil, oWndAreas:oControl:Refresh(),),;
                     If( oWndRec != nil, oWndRec:oControl:Refresh(),) ) ;
         SIZE 400, 400 FONT oFont ;
         MESSAGE "Visual make of all the dictionary elements"

      oBrw:bLine = { | aTemp | aTemp := _aFields( cAlias ),;
                               AAdd( aTemp, nil ), AIns( aTemp, 1 ),;
                               aTemp[ 1 ] := If( ( cAlias )->( Deleted() ),;
                               "x", "X" ), aTemp }

      AAdd( oBrw:aColSizes, nil )
      AIns( oBrw:aColSizes, 1 )
      oBrw:aColSizes[ 1 ] = 16

      AAdd( oBrw:aHeaders, nil )
      AIns( oBrw:aHeaders, 1 )
      oBrw:aHeaders[ 1 ] = ""

      oWndDb:SetControl( oBrw )

      ACTIVATE WINDOW oWndDb ;
         VALID ( If( oWndRec != nil, oWndRec:End(),),;
                 oBrw:lCloseArea() )

      if oWndAreas != nil
         oWndAreas:oControl:Refresh()  // We updates the info on the WorkAreas
      endif                            // Inspector


Return nil

//----------------------------------------------------------------------------//
