#include "FiveWin.ch"
#include "Constant.ch"

#define LTGRAY_BRUSH     1
#define GRAY_BRUSH       2

#define WM_CTLCOLOR     25  // 0x19       // Don't remove Color Control
#define WM_ERASEBKGND   20  // 0x0014     // or controls will not shown
                                          // colors !!!
#define WM_GETFONT      49  // 0x0031
#define WM_DRAWITEM     43  // 0x002B
#define WM_MEASUREITEM  44  // 0x002C

#define CBN_SELCHANGE      1

#define BM_SETSTYLE        WM_USER + 4

static lRegistered := .f.

//----------------------------------------------------------------------------//

CLASS TDialog FROM TWindow

   DATA   cResName
   DATA   hResources
   DATA   lCentered, lModal, lModify
   DATA   bStart

   METHOD New( nTop, nLeft, nBottom, nRight, cCaption, cResName, hResources,;
               lVbx, nStyle, nClrText, nClrBack, oBrush, oWnd, lPixels,;
               oIco, oFont ) CONSTRUCTOR

   METHOD Define( nTop, nLeft, nBottom, nRight, cCaption, nStyle,;
                  nClrText, nClrPane, oBrush ) CONSTRUCTOR

   METHOD Activate( bClicked, bMoved, bPainted, lCentered, bValid, lModal,;
                    bInit, bRClicked, bWhen )

   METHOD Close( nResult )

   METHOD Command( nWParam, nLParam )
   METHOD cToChar( hActiveWnd )
   METHOD DefControl( oControl )

   METHOD Destroy() INLINE Super:Destroy(), If( ! ::lModal, .t., nil )

   METHOD Display() INLINE ::BeginPaint(), ::Paint(), ::EndPaint(),;
                           If( ::bStart != nil,;
                               Eval( ::bStart, ::bStart := nil ),), .f.

   METHOD End( nResult )

   METHOD EraseBkGnd( hDC )

   METHOD FocusNext( hCtrlFocus, lPrevius )
   METHOD GetItem( nId ) INLINE  GetDlgItem( ::hWnd, nId )

   METHOD GotFocus() INLINE If( ::bGotFocus != nil, Eval( ::bGotFocus ),)

   METHOD HandleEvent( nMsg, nWParam, nLParam ) EXTERN ;
                                 DlgHandleEvent( nMsg, nWParam, nLParam )

   METHOD Init()

   METHOD LostFocus() INLINE If( ::bLostFocus != nil, Eval( ::bLostFocus ),)

   METHOD QueryEndSession() INLINE  ! ::End()

   METHOD VbxFireEvent( pEventInfo ) INLINE VBXEvent( pEventInfo )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nTop, nLeft, nBottom, nRight, cCaption, cResName, hResources,;
            lVbx, nStyle, nClrText, nClrBack, oBrush, oWnd, lPixels,;
            oIco, oFont ) CLASS TDialog

   DEFAULT hResources := GetResources(), lVbx := .f.,;
           nStyle     := nOR( DS_MODALFRAME, WS_POPUP, WS_CAPTION, WS_SYSMENU ),;
           nClrText   := CLR_BLACK, nClrBack := CLR_LIGHTGRAY,;
           lPixels    := .f., nTop := 0, nLeft := 0, nBottom := 10, nRight := 10

   ::aControls  = {}
   ::cResName   = cResName
   ::cCaption   = cCaption
   ::hResources = hResources
   ::lModify    = .t.
   ::lVbx       = lVbx
   ::lVisible   = .f.
   ::nResult    = 0
   ::nStyle     = nStyle
   ::oWnd       = oWnd
   ::oIcon      = oIco
   ::oFont      = oFont
   ::nLastKey   = 0

   ::SetColor( nClrText, nClrBack, oBrush )

   if lPixels  // New PIXELS Clausule
      ::nTop       = nTop
      ::nLeft      = nLeft
      ::nBottom    = nBottom
      ::nRight     = nRight
   else
      // Compatibility
      ::nTop    := int( nTop    * DLG_CHARPIX_H )
      ::nLeft   := int( nLeft   * DLG_CHARPIX_W )
      ::nBottom := int( nBottom * DLG_CHARPIX_H  )
      ::nRight  := int( nRight  * DLG_CHARPIX_W  )
   endif

   if lVbx
      if ! VbxInit( GetInstance(), "" )
         MsgAlert( "VBX support not available" )
      endif
   endif

   if ! lRegistered
      ::Register( nOr( CS_VREDRAW, CS_HREDRAW ) )
      lRegistered = .t.
   endif

   SetWndDefault( Self )          //  Set Default DEFINEd Window

return nil

//----------------------------------------------------------------------------//

METHOD Activate( bLClicked, bMoved, bPainted, lCentered, ;
                 bValid, lModal, bInit, bRClicked, bWhen ) CLASS TDialog

   static nDlgCount := 0

   local hActiveWnd, hWnd

   DEFAULT lCentered := .f., lModal := .t., ::hWnd := 0

   ::nLastKey = 0

   ++nDlgCount

   hActiveWnd = If( ::oWnd != nil, ::oWnd:hWnd,;
                If( nDlgCount > 1 .or. lWRunning(),;
                    GetActiveWindow(), GetWndApp() ) )

   ::lCentered   = lCentered
   ::lModal      = lModal
   ::bLClicked   = bLClicked
   ::bRClicked   = bRClicked
   ::bWhen       = bWhen
   ::bValid      = bValid
   ::bInit       = bInit
   ::bPainted    = bPainted
   ::bMoved      = bMoved
   ::nResult     = nil
   ::lValidating = .f.
   ::lVisible    = .t.

   if ::bWhen != nil
      if ! Eval( ::bWhen, Self )
          ::nResult  = IDCANCEL
          ::lVisible = .f.
          return nil             // <<---------- Warning: Exiting!
      endif
   endif

   ::AEvalWhen()

   if lModal
      ::nResult = if( ! Empty( ::cResName ),;
                      DialogBox( ::hResources, ::cResName,;
                                      hActiveWnd, Self ),;
                      DialogBoxIndirect( GetInstance(), ::cToChar( hActiveWnd ),;
                                      hActiveWnd, Self ) )
      if ::nResult == -1
         CreateDlgError( Self )
      endif

   else
      if ( Len( ::aControls ) > 0 .and. CanRegDialog() ) .or. ;
           Len( ::aControls ) == 0

         ::hWnd = if( ! Empty( ::cResName ),;
                       CreateDlg( ::hResources, ::cResName,;
                                  hActiveWnd, Self ),;
                       CreateDlgIndirect( GetInstance(), ::cToChar( hActiveWnd ),;
                                  hActiveWnd, Self ) )

         if ::hWnd == 0
            CreateDlgError( Self )
         endif

         ::Link( .f. )

         if Len( ::aControls ) > 0 .and. ! RegDialog( ::hWnd )
            ::SendMsg( WM_CLOSE )
            MsgAlert( "Not possible to create more non-modal Dialogs" )
         endif

         ShowWindow( ::hWnd )

      else

         MsgAlert( "Not possible to create more non-modal Dialogs" )

      endif

   endif

   nDlgCount--

   if ::lModal
      ::lVisible = .f.
   endif

return nil

//---------------------------------------------------------------------------//

METHOD DefControl( oCtrl ) CLASS TDialog

   DEFAULT oCtrl:nId := oCtrl:GetNewId()

   if AScan( ::aControls, { | o | o:nId == oCtrl:nId } ) > 0
      #define DUPLICATED_CONTROLID  2
      Eval( ErrorBlock(), _FWGenError( DUPLICATED_CONTROLID, ;
                          "No: " + Str( oCtrl:nId, 6 ) ) )
   else
      AAdd( ::aControls, oCtrl )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD FocusNext( hCtrlFocus, lPrevius ) CLASS TDialog

   local hCtrlNext := NextDlgTab( GetParent( hCtrlFocus ), hCtrlFocus, lPrevius )

   if hCtrlNext != hCtrlFocus
      SetFocus( hCtrlNext )

      // DLGC_BUTTON || DLGC_DEFPUSHBUTTON = 8224
      if SendMessage( hCtrlNext, WM_GETDLGCODE, 0, 0 ) = 8224
         SendMessage( hCtrlNext, BM_SETSTYLE, BS_DEFPUSHBUTTON, 1 )
      endif
   else
      MessageBeep( -1 )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Command( nWParam, nLParam ) CLASS TDialog

   do case
      case ::oPopup != nil
           ::oPopup:Command( nWParam )

      case nLParam == 0 .and. ::oMenu != nil
           ::oMenu:Command( nWParam )

      case nWParam > 0
           do case
              case nHiWord( nLParam ) == BN_CLICKED

                   if nLoWord( nLParam ) > 0 .and. nWParam != IDCANCEL

                      if ::nResult != nil  // latest control which had focus

                         ::nResult:LostFocus()    // updates related variable

                         // There is a pending Valid, it is not a clicked button
                         if ::nResult:nID != nWParam .and. !::nResult:lValid()
                            return nil
                         endif

                      endif

                      if AScan( ::aControls, { |o| o:nID == nWParam } ) > 0
                         SendMessage( nLoWord( nLParam ), FM_CLICK, 0, 0 )
                      elseif nWParam == IDOK
                         ::End( IDOK )
                      endif

                   else

                      if nWParam == IDOK

                         ::FocusNext( GetFocus(), .f. )

                      elseif nLoWord( nLParam ) > 0 .and. ; // There is a control for IDCANCEL
                             AScan( ::aControls, { |o| o:nID == nWParam } ) > 0
                            SendMessage( nLoWord( nLParam ), FM_CLICK, 0, 0 )
                      else
                         ::End( IDCANCEL )
                      endif

                   endif

                   return nil

              case nHiWord( nLParam ) == CBN_SELCHANGE
                   SendMessage( nLoWord( nLParam ), FM_CHANGE, 0, 0 )

           endcase
   endcase

return nil

//----------------------------------------------------------------------------//

METHOD cToChar( hActiveWnd ) CLASS TDialog

   local cResult
   local aControls := ::aControls
   local n     := GetDlgBaseUnits()
   local aRect := GetWndRect( hActiveWnd )

   DEFAULT ::cCaption := ""

   cResult = cDlg2Chr( Len( aControls ),;
                       int( 8 * ( ::nTop  - aRect[ 1 ]   ) / nHiWord( n ) ),;
                       int( 4 * ( ::nLeft - aRect[ 2 ]   ) / nLoWord( n ) ),;
                       int( 8 * ( ::nBottom - aRect[ 1 ] ) / nHiWord( n ) ),;
                       int( 4 * ( ::nRight  - aRect[ 2 ] ) / nLoWord( n ) ),;
                       ::cCaption, ::nStyle )

   for n = 1 to Len( aControls )
      cResult += aControls[ n ]:cToChar()
   next

return cResult

//----------------------------------------------------------------------------//

METHOD Define( nTop, nLeft, nBottom, nRight, cCaption, nStyle, lVbx,;
               nClrText, nClrBack, oBrush ) CLASS TDialog

   DEFAULT lVbx     := .f.,;
           nClrText := CLR_BLACK, nClrBack := CLR_LIGHTGRAY

   ::hWnd     = 0
   ::nTop     = nTop
   ::nLeft    = nLeft
   ::nBottom  = nBottom
   ::nRight   = nRight
   ::cCaption = cCaption
   ::nStyle   = nStyle
   ::lVbx     = lVbx
   ::nLastKey = 0

   ::SetColor( nClrText, nClrBack, oBrush )

return nil

//----------------------------------------------------------------------------//

METHOD End( nResult ) CLASS TDialog

   DEFAULT nResult := 2              // Cancel

   if ! ::lModal
      PostMessage( ::hWnd, WM_CLOSE, nResult )
   else
      if ValType( ::bValid ) == "B"
         if ! Eval( ::bValid, Self )
            return .f.
         endif
      endif
      ::nResult = nResult
      EndDialog( ::hWnd, nResult )
   endif

return .t.

//----------------------------------------------------------------------------//
// Conection with Borland's VBX DLL - at run-time !!!

DLL STATIC FUNCTION VbxInitDialog( hWnd AS WORD, hInstance AS WORD,;
                       cResName AS STRING ) AS BOOL PASCAL LIB "BIVBX10.DLL"

DLL STATIC FUNCTION VbxInit( hInstance AS WORD, cPrefix AS STRING ) ;
                    AS BOOL PASCAL LIB "BIVBX10.DLL"

DLL STATIC FUNCTION VbxTerm() AS VOID PASCAL LIB "BIVBX10.DLL"

//----------------------------------------------------------------------------//

static function CreateDlgError( Self )

   #define CANNOTCREATE_DIALOG 3
   Eval( ErrorBlock(), ;
        _FwGenError( CANNOTCREATE_DIALOG, CHR(13)+CHR(10) + ;
                     If( !Empty( ::cResName ), "Resource: " + ::cResName,;
               "Title: " + If( Empty( ::cCaption ), "", ::cCaption ) ) ) )
return nil

//----------------------------------------------------------------------------//

METHOD Init() CLASS TDialog

   if ::lVbx
      if ! VbxInitDialog( ::hWnd, GetResources(), ::cResName )
         MsgAlert( "Error on VBX's initialization" )
      endif
   endif

   if ::oFont == nil
      ::GetFont()
   endif

   // We can resist to use something more, more faster !!! <g>
   // AEval( ::aControls, { | oCtrl | oCtrl:Init( ::hWnd ) } )
   ASend( ::aControls, "INIT", ::hWnd )

   if ::lCentered
      WndCenter( ::hWnd )
   endif

   if ::cCaption != nil
      ::cTitle = ::cCaption
   endif

   if ::bInit != nil
      Eval( ::bInit, Self )
   endif

return .t.                              // .t. for focus

//----------------------------------------------------------------------------//

METHOD EraseBkGnd( hDC ) CLASS TDialog

   if ::oBrush != nil
      FillRect( hDC, GetClientRect( ::hWnd ), ::oBrush:hBrush )
      return .t.
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Close( nResult ) CLASS TDialog

   if ! ::lModal
      if ValType( ::bValid ) == "B"
         if ! Eval( ::bValid, Self )
            return .t.
         endif
      endif
      ::nResult = nResult
      ::lVisible = .f.
      DestroyWindow( ::hWnd )
      return .t.
   endif

return nil

//----------------------------------------------------------------------------//
