#include "FiveWin.ch"

static aDDEs := {}

static nLastMsg := 0

//----------------------------------------------------------------------------//

CLASS TDde

   DATA   nService, nTopic, nItem
   DATA   bAction, bEnd
   DATA   oWndServer
   DATA   lActive

   METHOD New( cService, cTopic, cItem, bAction, bEnd ) CONSTRUCTOR
   METHOD Activate()
   METHOD Execute( cCommand )

   METHOD End() INLINE ::oWndServer:PostMsg( WM_DDE_TERMINATE, GetWndApp() ),;
                       If( ::bEnd != nil .and. ::lActive,;
                           Eval( ::bEnd, ::bEnd := nil ),),;
                       ::lActive := .f.

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( cService, cTopic, cItem, bAction, bEnd ) CLASS TDde

   ::nService = GlobalAddAtom( cService )
   ::nTopic   = GlobalAddAtom( cTopic )
   ::nItem    = GlobalAddAtom( cItem )
   ::bAction  = bAction
   ::lActive  = .f.
   ::bEnd     = bEnd

   AAdd( aDDEs, Self )

return nil

//----------------------------------------------------------------------------//

METHOD Activate() CLASS TDde

   nLastMsg = WM_DDE_INITIATE

   SendMessage( -1, WM_DDE_INITIATE, GetWndApp(),;
                nMakeLong( ::nService, ::nTopic ) )

return nil

//----------------------------------------------------------------------------//

METHOD Execute( cCommand ) CLASS TDde

   nLastMsg = WM_DDE_EXECUTE

   if ::oWndServer != nil
      ::oWndServer:PostMsg( WM_DDE_EXECUTE, GetWndApp(),;
                            DdeCommand( cCommand ) )

      while nLastMsg != WM_DDE_ACK
         SysRefresh()
      end
   else
      MsgAlert( "DDE Object not properly initialized!" )
   endif

return nil

//----------------------------------------------------------------------------//

function DdeAck( hWndServer, nLParam )

   local nService, nTopic
   local nDde, oDde

   do case
      case nLastMsg == WM_DDE_INITIATE
           nService = nLoWord( nLParam )
           ATail( aDDEs ):oWndServer = TWindow()
           ATail( aDDEs ):oWndServer:hWnd = hWndServer
           ATail( aDDEs ):lActive = .t.

      case nLastMsg == WM_DDE_EXECUTE
           DdeGetCommand( nLParam )
   endcase

   nLastMsg = WM_DDE_ACK

return nil

//----------------------------------------------------------------------------//

function DdeTerminate( hWndServer )

   local nAt := AScan( aDDEs, { | oDDE | oDDE:oWndServer:hWnd == hWndServer } )

   if nAt != 0 .and. nAt <= Len( aDDEs )
      aDDEs[ nAt ]:End()
      aDDEs[ nAt ] = nil
      ADel( aDDEs, nAt )
      if Len( aDDEs ) > 0
         ASize( aDDEs, Len( aDDEs ) - 1 )
      endif
   endif

return nil

//----------------------------------------------------------------------------//
