#include "FiveWin.ch"
#include "sql.ch"

//----------------------------------------------------------------------------//

CLASS TDbOdbc

   DATA   hEnv, hDbc                   AS NUMERIC PROTECTED
   DATA   cConnect, cDSN, cUser, cPassword
   DATA   nRetorno

   METHOD New( cDSN, cUser, cPassword, cConnect, lDlg ) CONSTRUCTOR

   METHOD End()
   
   METHOD GetInfo( nType )
   
   METHOD SetOptions( nType, uBuffer)
   
   METHOD GetOptions( nType)
   
   METHOD Commit() 
   
   METHOD RollBack()

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( cDSN, cUser, cPassword, cConnect, lDlg ) CLASS TDbOdbc

   local hEnv, hDbc
   local nret

   ::nRetorno := 0

   DEFAULT lDlg := .f.           // Dialog Box connection

   ::cDSN      = cDSN
   ::cUser     = cUser
   ::cPassword = cPassword

   if (nRet:=SQLAllocEnv( @hEnv )) == SQL_SUCCESS
      ::hEnv = hEnv
   else
      ::nRetorno:=nRet
      MsgStop( "Error en SQLALLOCENV" )
      return nil
   endif

   if (nret:=SQLAllocConnect( hEnv, @hDbc )) == SQL_SUCCESS
      ::hDbc = hDbc
   else
      ::nRetorno:=nRet
      MsgStop( "Error en SQLALLOCCONNECT" )
      return nil
   endif

   if ! Empty( cConnect )
      if (nret:=SQLDriverConnect( hDbc, @cConnect, lDlg )) != SQL_SUCCESS
         ::nRetorno:=nRet
         MsgStop( "Error en SQLDRIVERCONNECT: No establecida conexin ODBC" )
         return nil
      else
         ::cConnect = cConnect
         ::cDSN     = SubStr( cConnect, 1, At( ";", cConnect ) - 1 )
         ::cDSN     = SubStr( ::cDSN, At( "=", ::cDSN ) + 1 )
      endif
   else
      nret:=SQLConnect( hDbc, cDSN, cUser, cPassword )
      if nret == SQL_SUCCESS .or. nret == SQL_SUCCESS_WITH_INFO
         //MSGALERT("Establecida conexion")
      else
         ::nRetorno:=nRet
         MsgStop( "Error en SQLCONNECT: No establecida conexion ODBC" )
         return nil
      endif
   endif

return nil

//----------------------------------------------------------------------------//

METHOD End() CLASS TDbOdbc

   SQLDisconnect( ::hDbc )
   SQLFreeConnect( ::hDbc )
   SQLFreeEnv( ::hEnv )

   ::hEnv  = 0
   ::hDbc  = 0

return nil

//----------------------------------------------------------------------------//

METHOD GetInfo ( nType ) CLASS TDbOdbc

   local cBuffer:=space(256)
   
   ::nRetorno := SQLGetInfo( ::hDbc , nType , @cBuffer )   

return cBuffer

//----------------------------------------------------------------------------//

METHOD GetOptions ( nType ) CLASS TDbOdbc

   local cBuffer:=space(256)
   
   ::nRetorno := SQLGetConn( ::hDbc , nType , @cBuffer )   

return cBuffer

//----------------------------------------------------------------------------//

METHOD SetOptions ( nType, uBuffer ) CLASS TDbOdbc

  
return (::nRetorno := SQLSetConn( ::hDbc , nType , uBuffer )   )

//----------------------------------------------------------------------------//

METHOD Commit ( ) CLASS TDbOdbc

  
return (::nRetorno := SQLCommit( ::hEnv, ::hDbc )   )

//----------------------------------------------------------------------------//

METHOD RollBack() CLASS TDbOdbc

  
return (::nRetorno := SQLRollBac( ::hEnv, ::hDbc )   )

//----------------------------------------------------------------------------//

