#include "fivewin.ch"
#include "dbm.ch"

CLASS TDbm FROM TDataBase

   DATA aField, aIndex AS Array
   DATA oDict          AS Object

   METHOD New( cAlias, cFile, cDriver, lShared, lReadOnly, aField, aIndex, oDict );
                                                                     CONSTRUCTOR
   METHOD Redefine( oDict )  INLINE oDict:Update( Self ), Self

   METHOD AddField( xField )
   METHOD AddIndex( xIndex )
   METHOD ReadFields()
   METHOD ReadIndexs() VIRTUAL
   METHOD WriteFields()
   METHOD WriteIndexs() VIRTUAL
 
   METHOD Create()
   
ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( cAlias, cFile, cDriver, lShared, lReadOnly, aField, aIndex, oDict ) ;
                                                                     CLASS TDbm
   local n
   
   Super:New( cAlias, cFile, cDriver, lShared, lReadOnly )

   BYNAME oDict
   
   if aField != nil
   	  for n = 1 to len( aField )
   	  	  ::AddField( aField[n] )
   	  next
   end	  
   if aIndex != nil
   	  for n = 1 to len( aIndex )
   	  	  ::AddIndex( aIndex[n] )
   	  next
   end	  
   
   BYNAME aField, aIndex
    
   oDict:AddDb( Self )
   
   ::WriteFields()
   
Return Self

//----------------------------------------------------------------------------//

METHOD AddField( xField ) CLASS TDbm

   	   if valtype( xField ) == "C"
          aAdd( ::aField, oClone( ::oDict:aField[ aScan( ::oDict:aField,;
                                     { |e| e:cName == Upper( xField ) } ) ] ) )
         else
          aAdd( ::aField, xField )
       endif                              
   	   
Return nil

//----------------------------------------------------------------------------//

METHOD AddIndex( xIndex ) CLASS TDbm

   	   if valtype( xIndex ) == "C"
          aAdd( ::aIndex, oClone( ::oDict:aIndex[ aScan( ::oDict:aIndex,;
                                     { |e| e:cName == Upper( xIndex ) } ) ] ) )
         else
          aAdd( ::aIndex, xIndex )
       endif                              
   	   
Return nil

//----------------------------------------------------------------------------//

METHOD ReadFields() CLASS TDbm

   local nOldArea:= Select()
	
   USE (::cFile + EXT_FLD) NEW READONLY
   
   While !Eof()
         ::AddField( TField():New( Upper( FieldGet( 1 ) ),;  // Name.
                                   Upper( FieldGet( 2 ) ),;  // Type.
                                   FieldGet( 3 ),;           // Len.
                                   FieldGet( 4 ) ;           // Dec.
								 );
                   )
         SKIP
   end
   
   CLOSE

   Select ( nOldArea )
   
Return nil

//----------------------------------------------------------------------------//

METHOD WriteFields() CLASS TDbm

   local n, o, nLen := len( ::aField ), nOldArea:= Select()
	
   DbCreate( ::cFile + EXT_FLD, aSTRU_FIELD )
   
   USE (::cFile + EXT_FLD) NEW
       
   for n = 1 to nLen
       o:= ::aField[n]
       APPEND BLANK
       FieldPut( 1, o:cName )
       FieldPut( 2, o:cType )
       FieldPut( 3, o:nLen )
       FieldPut( 4, o:nDec )
   next

   CLOSE
   
   Select ( nOldArea )
   
Return nil

//----------------------------------------------------------------------------//

METHOD Create() CLASS TDbm

   local oField, i, aStruct:= array( len( ::aField ) )

   for i:= 1 to len( ::aField )
       oField:= ::aField[ i ]
       aStruct[i]:= { oField:cName, oField:cType, oField:nLen, oField:nDec }
   next
   ::DbCreate( aStruct )
	   
Return nil

//----------------------------------------------------------------------------//
