// Shows how to change from Oem to Ansi and viceversa

/*
 Programa Ŀ
   Aplicacin: Cambia de Formato Oem a Ansi y viceversa                   
      Fichero: DBFW.PRG                                                   
        Autor: Ignacio Ortiz de Ziga Echeverra                         

*/

#include "fivewin.ch"

#define OEM_TO_ANSI      1
#define ANSI_TO_OEM      2
#define MAX_CHECK       10


Static oWnd, oMeter, oAtoO, oOtoA
Static nActual := 0

//----------------------------------------------------------------------------//

FUNCTION Main()

     LOCAL oIcon

     DEFINE ICON oIcon RESOURCE "ICON_DBFW"

     MsgInfo( If( IsAnsi( "Hola" ), "Ok", "No" ) )

     DEFINE WINDOW oWnd FROM 1, 1 TO 9, 60 ;
          TITLE OemToAnsi("Conversin de Ficheros DBF") ;
          ICON oIcon ;
          BORDER NONE ;
          COLOR "B/W" ;
          NOZOOM

     WndCenter(oWnd:hWnd)

     ACTIVATE WINDOW oWnd ;
          ON INIT Showcontrols()

RETURN (NIL)

//----------------------------------------------------------------------------//

STATIC FUNCTION ShowControls()

     @ 02,01 METER oMeter VAR nActual TOTAL 100 ;
          SIZE 455,20 ;
          OF oWnd

     @ 5,12 BUTTON oOtoA PROMPT "&Oem to Ansi" ;
           DEFAULT ;
           OF oWnd ;
           ACTION Conversion(OEM_TO_ANSI) ;
           SIZE 100,25

     @ 5,40 BUTTON oAtoO PROMPT "&Ansi to Oem" ;
           DEFAULT ;
           OF oWnd ;
           ACTION Conversion(ANSI_TO_OEM) ;
           SIZE 100,25


RETURN (NIL)

//----------------------------------------------------------------------------//

STATIC FUNCTION Conversion(nType)

     LOCAL aData
     LOCAL bBlock
     LOCAL cFichero, cCaption
     LOCAL nTotal, nMeter

     cFichero := GetFichero()

     IF empty(cFichero)
          RETURN NIL
     ENDIF

     oAtoO:disable()
     oOtoA:disable()

     cCaption := oWnd:cCaption

     oWnd:cTitle({"Oem to Ansi","Ansi to Oem"} [nType] + ;
                 ":  ["+SubStr(cFichero, Rat("\",cFichero)+1)+"]")


     IF nType == OEM_TO_ANSI

          bBlock := {|val,elem| iif(Valtype(Val)=="C"             ,;
                                    Fieldput(elem,OemtoAnsi(val)) ,;
                                    NIL ) }

     ELSE

          bBlock := {|val,elem| iif(Valtype(Val)=="C"             ,;
                                    Fieldput(elem,AnsitoOem(val)) ,;
                                    NIL ) }

     ENDIF

     USE (cFichero) NEW EXCLUSIVE
     SET INDEX TO

     IF CheckRec(nType,cFichero)

          oWnd:cTitle(cCaption)
          oAtoO:enable()
          oOtoA:enable()

          CLOSE ALL
          RETU NIL

     ENDIF

     GO TOP

     nTotal := lastrec()

     oMeter:nTotal = RecCount()

     DO WHILE !EOF()

          aData := Scatter()

          Aeval(aData ,bBlock)

          SKIP

          oMeter:Set( RecNo() )
          SysRefresh()
     ENDDO

     CLOSE ALL

     MsgBeep()

     oMeter:Set(0)
     oWnd:cTitle(cCaption)
     oAtoO:enable()
     oOtoA:enable()

RETURN (NIL)

//----------------------------------------------------------------------------//

STATIC FUNCTION GetFichero()

     LOCAL cFile := ""

     cFile := cGetFile("*.dbf"           ,;
                       "Elija la base de datos")

     IF "*"$cFile .OR. !file(cFile)
          cFile := ""
     ENDIF

Return (cFile)

//----------------------------------------------------------------------------//

STATIC Function scatter()

     local fvals := {} , fnum := 1

     Asize(fvals,fcount())

     aeval(fvals, {|| fvals[fnum++] := fieldget(fnum)})

Return(fvals)

//----------------------------------------------------------------------------//

STATIC Function CheckRec(nType, cFichero)


     LOCAL aData
     LOCAL bBlock
     LOCAL nCounter := 0
     LOCAL lAlert   := .F.

     IF nType == OEM_TO_ANSI

          bBlock := {|val| iif(Valtype(Val)=="C" .AND. IsAnsi(val) ,;
                               lAlert := .T.                       ,;
                               NIL ) }

     ELSE

          bBlock := {|val| iif(Valtype(Val)=="C" .AND. IsOem(val)  ,;
                               lAlert := .T.                       ,;
                               NIL ) }

     ENDIF

     CursorWait()

     DO WHILE !Eof() .OR. nCounter <= MAX_CHECK

          aData := Scatter()

          Aeval(aData ,bBlock)

          IF lAlert
               EXIT
          ENDIF

          SKIP

          nCounter++

     ENDDO

     GO TOP

     CursorArrow()

     IF lAlert

          lAlert := !MsgYesNo(OemtoAnsi("Ya esta en formato ")+;
                              {"Ansi","Oem"}[nType]+", desea Continuar?",;
                              cFichero)

     ENDIF

RETURN lAlert

//----------------------------------------------------------------------------//
