#include "FiveWin.ch"
#include "Customer.ch"

static oWnd

//----------------------------------------------------------------------------//

function Main()

   local oBar

   SET 3DLOOK ON
   // SET DATE FRENCH
   SET SOFTSEEK ON

   DEFINE WINDOW oWnd TITLE OemToAnsi( "Customers Management" ) ;
      MENU BuildMenu()

   DEFINE BUTTONBAR oBar 3D SIZE 33, 33 OF oWnd

   DEFINE BUTTON OF oBar ;
      FILENAME "..\..\bitmaps\info.bmp" ;
      MESSAGE "Acerca de este programa" ;
      ACTION MsgAbout( "Bussiness application demonstration",;
                       "(c) Five Technologies" )

   DEFINE BUTTON OF oBar ;
      FILENAME "..\..\bitmaps\exit.bmp" ;
      MESSAGE "End this session" ;
      ACTION oWnd:End()

   DEFINE BUTTON GROUP OF oBar ;
      FILENAME "..\..\bitmaps\client.bmp" ;
      MESSAGE "Customers Management" ;
      ACTION Customers()

   SET MESSAGE OF oWnd ;
      TO "FiveWin - Bussiness application demonstrations" CENTERED

   ACTIVATE WINDOW oWnd MAXIMIZED ;
      VALID MsgYesNo( "Exit this app ?" )

return nil

//----------------------------------------------------------------------------//

function BuildMenu()

   local oMenu

   MENU oMenu
      MENUITEM "&Information"
      MENU
         MENUITEM "&About..." ;
            ACTION MsgAbout( "Customers management",;
                             "FiveWin - Bussiness application demonstrations" )
         SEPARATOR
         MENUITEM "&Finish" ACTION oWnd:End()
      ENDMENU

      MENUITEM "&Files"
      MENU
         MENUITEM "&Customers"
         MENUITEM "&Sales"
         MENUITEM "S&tock"
      ENDMENU
   ENDMENU

return oMenu

//----------------------------------------------------------------------------//

function Customers()

   local oDlg, oBrw
   local oBmp1, oBmp2
   local cNombre

   DEFINE BITMAP oBmp1 RESOURCE "On"
   DEFINE BITMAP oBmp2 RESOURCE "Off"

   USE ..\Customer ALIAS Customers INDEX "..\Cliente.in1"
   USE "..\Pedido.dat"  ALIAS Pedidos  INDEX "..\Pedido.in1"  NEW

   SELECT Customers
   SET RELATION TO Customers->cCodigo INTO Pedidos
   SEEK "A"

   DEFINE DIALOG oDlg RESOURCE "Customers"

   REDEFINE LISTBOX oBrw ;
      FIELDS If( Pedidos->cCodCli == Customers->cCodigo, oBmp1:hBmpPal, oBmp2:hBmpPal ),;
             Customers->cCodigo,;
             DToC( Customers->dAlta ),;
             OemToAnsi( Customers->cNombre ) ;
      HEADER "", OemToAnsi( "Cd." ), "Alta", "Nombre" ;
      ID ID_CLIENTES OF oDlg

   oBrw:bLDblClick = { || Enviado() }

   // nKey, nFlags and Self are automatically provided in the
   // following ON CHANGE clause

   REDEFINE GET cNombre ID ID_BUSCAR OF oDlg ;
      ON CHANGE ( ::Assign(),;  // Self is provided to ON CHANGE,  cNombre is updated !
                  If( Customers->( DbSeek( AnsiToOem( SubStr( cNombre, 1, ::nPos - 1 ) + Chr( nKey ) ) ) ),;
                    ( oBrw:UpStable(), oBrw:Refresh(), .t. ),; // accept the Key
                    ( MsgStop( "No aparece" ), .f. ) ) )       // refuse the key

   REDEFINE BUTTON ID ID_ENVIADO OF oDlg ;
      ACTION ( Enviado(), oBrw:SetFocus() )

   ACTIVATE DIALOG oDlg CENTERED

   USE
   SELECT Pedidos
   USE

   RELEASE BITMAP oBmp1, oBmp2

return nil

//----------------------------------------------------------------------------//

function Enviado()

   local oDlg, oLbx

   if Pedidos->( DbSeek( Customers->cCodigo ) )
      DEFINE DIALOG oDlg RESOURCE "Enviado"

      SELECT Pedidos

      REDEFINE SAY Customers->cCodigo ID ID_CODIGO OF oDlg
      REDEFINE SAY Customers->cNombre ID ID_NOMBRE OF oDlg

      REDEFINE LISTBOX oLbx ;
         FIELDS DToC( Pedidos->dFecha ), Pedidos->cCodPro1 ;
         HEADER "Fecha", "Producto" ;
         SELECT Pedidos->cCodCli FOR Customers->cCodigo ;
         ID ID_PEDIDOS OF oDlg

      SELECT Customers

      ACTIVATE DIALOG oDlg CENTERED
   else
      MsgInfo( OemToAnsi( "Este cliente no ha realizado ningn pedido" ) )
   endif

return nil

//----------------------------------------------------------------------------//
