#include "FiveWin.ch"

//----------------------------------------------------------------------------//

function BmpNew() ; WinExec( "PBrush" ) ; return nil

//----------------------------------------------------------------------------//

function BmpOpen( cBmpFile )

   local oWndBmp, oBar, oBmp, oIcon, oLupa, oCoors, oFont

   DEFAULT cBmpFile := cGetFile( "Windows Bitmap (*.bmp) | *.bmp",;
                                 "Select a BMP" )

   if ! Empty( cBmpFile )

      DEFINE ICON oIcon RESOURCE "Bitmap"

      DEFINE WINDOW oWndBmp FROM 1, 1 TO 23, 33 ;
         ICON oIcon TITLE "Bitmap: " + cNoPath( cNoExt( cBmpFile ) ) ;
         MDICHILD

      DEFINE BUTTONBAR oBar OF oWndBmp

      DEFINE FONT oFont NAME "Arial" SIZE 5, 13

      @ 9, 160 SAY oCoors PROMPT "   0,   0" SIZE 120, 10 ;
         PIXEL OF oBar FONT oFont

      DEFINE BUTTON RESOURCE "Edit" OF oBar ;
         ACTION WinExec( "pbrush " + cBmpFile ) ;
         MESSAGE "Edit this Bitmap"

      DEFINE BUTTON RESOURCE "ZoomOut" OF oBar ;
         ACTION ( oBmp:lStretch := ! oBmp:lStretch,;
                  oBmp:ScrollAdjust(),;
                  oBmp:Refresh( .t. ) ) ;
         MESSAGE "Adjust this Bitmap"

      DEFINE BUTTON RESOURCE "Report" GROUP OF oBar ;
         ACTION ( oBmp:HardCopy( 4 ) ) ;
         MESSAGE "Send this bitmap to the printer"

      DEFINE CURSOR oLupa RESOURCE "Lupa"

      @ 0, 0 BITMAP oBmp FILENAME cBmpFile SCROLL ADJUST OF oWndBmp ;
         CURSOR oLupa SIZE 400, 400

      oBmp:bMMoved = { | nRow, nCol | ;
                         oCoors:SetText( Transform( nRow, "9999" ) + "-" + ;
                                         Transform( nCol, "9999" ) ) }

      oWndBmp:SetControl( oBmp )

      ACTIVATE WINDOW oWndBmp

   endif

return nil

//----------------------------------------------------------------------------//
