
          ********************
          ** Code Generator **
          ********************

    A subtle problem has been detected in the FDIV instruction
    of Intel's Pentium processor. In certain rare cases, the result
    of a floating point divide will have less precision than it 
    should. Contact Intel directly for more information on the issue.
    
    A software workaround has been added to the compilers.
    On startup, the processor that the program is running on 
    will be tested, and if the FDIV instruction is found to 
    be faulty, the low order bit of the variable:
    
    		extern unsigned __near __chipbug;
		
    will be set. If the FDIV instruction does not show
    the problem, the low order bit will be clear. You may
    test this variable in your code in all floating
    point and memory models. When an FDIV instruction is
    generated by the compilers, the code generator will
    now additionally generate code which tests the low order
    bit of __chipbug and, if on, call the software workaround
    code in the math libraries. If the bit is off, an
    inline FDIV instruction will be performed as before.
    
    The compilers generate this additional code when the "-fpd"
    switch is used. If you know that your code will never run on 
    a Pentium CPU, or your analysis shows that the FDIV problem 
    will not affect your results, you can disable the workaround by
    not using the "-fpd" switch on the C/C++ compiler command line.
    Alternatively if your program performs floating point you may 
    wish to test the low order bit of __chipbug in your mainline and, 
    if it is on, issue a warning to the user. You can perform this
    test whether you have compiled with the -fpd switch or not.
    
    The following routines in the libraries have been
    identified to be at risk of being impacted by the FDIV
    problem and have been recompiled with the -fpd switch set:
    
	acos
	asin
	atan
	atan2			(using -fpc only)
	sinh
	cosh
	tanh
	atanh
	complex division	(C++)
	complex sqrt		(C++)
	cabs
	j0
	j1
	jn
	y0
	y1
	yn
	pow			(when second parameter is negative)
	fmod			(using -fpi/-fpi87 only)
	sin,cos,tan		(using -fpc only)
    
===========================================================
