#define INCL_DOSERRORS

#include <process.h>
#include <stddef.h>
#include <conio.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include "mailer.h"
#include "bbs.h"
#include "timers.h"
#include "window.h"
#include "keys.h"
#include "modem.h"
#include "xmisc.h"


    extern MDM           *modems[MAXINSTANCES];
    extern USER          *user[MAXINSTANCES];
    extern int           helpkey;
    extern USHORT        focusline;

    #define TIMEOUT      -1
    #define LOSTCARRIER  -2


void _fastcall hitreturn (int mode,USHORT cp) {

    int temp;

RePrompt:

    sayp(mode,cp,14,NULL,0);
    do {
        temp = wait_inkey(mode,cp);

        if(time(NULL) > user[cp]->offline) {  // Check timelimit timer
            DosSemClear(&modems[cp]->bbsrunningSEM);
            _endthread();
        }

        if(temp & 16384) {
            dputs(mode,cp,"\r\n");
            goto RePrompt;
        }

        if(temp == helpkey) {
            sayp(mode,cp,15,NULL,0);
            DosSleep(1500L);
            sayp(mode,cp,19,NULL,0);
            goto RePrompt;
        }

        if(temp != '\r') {
            dputs(D_REMOTE,cp,"\07");
            DosSleep(32L);
        }
        else DosSleep(1L);

    } while(temp != '\r');

    if(user[cp]->attribs & U_ANSI) dputs(mode,cp,"\r\x1b[K");
    else sayp(mode,cp,16,NULL,0);
}




int _fastcall do_more (int mode,USHORT cp) {    // For pausing at end-of-page

    int temp;

    if(user[cp]->attribs & U_NOMORE) {
      temp = toupper(inkey(mode,cp));
      if(temp) {
        if(temp == modems[cp]->STOP || temp == CTRL_K)
          return 1;
        if(temp == modems[cp]->PAUSE || temp == CTRL_S)
          mpause(mode,cp);
      }
      DosSleep(1L);
      return 0;
    }

RePrompt:

    sayp(mode,cp,17,NULL,0);

ReInput:

    temp = wait_inkey(mode,cp);

    if(time(NULL) > user[cp]->offline) {  // Check timelimit timer
        DosSemClear(&modems[cp]->bbsrunningSEM);
        _endthread();
    }

    if(temp & 16384) {
        dputs(mode,cp,"\r\n");
        goto RePrompt;
    }

    temp = toupper(temp);

    if(temp == helpkey) {
        sayp(mode,cp,15,NULL,0);
        DosSleep(1500L);
        sayp(mode,cp,19,NULL,0);
        goto ReInput;
    }

    if(temp == (int)modems[cp]->YES || temp == '\r')
      temp = 0;
    else if(temp == (int)modems[cp]->NO || temp == ESC)
      temp = 1;
    else {
      DosSleep(32L);
      goto ReInput;
    }

    if(user[cp]->attribs & U_ANSI)
      dputs(mode,cp,"\r\x1b[K");
    else
      sayp(mode,cp,18,NULL,0);

    return temp;
}




void _fastcall backup (int mode,USHORT cp,int howmany) {

    register int x;

    for(x = 0;x <( howmany + 1);x++)
       dputs(mode,cp,BACKSPACE);
}




void _fastcall cls (int mode,USHORT cp) {

  if(user[cp]->attribs & U_NOCLEAR) {
    dputs(mode,cp,"\r\n");
    return;
  }

  if(user[cp]->attribs & U_ANSI) {
    if(mode & D_REMOTE)
      dputs(D_REMOTE,cp,"\x1b[0m\x1b[2J");
  }
  else if (mode & D_REMOTE) dputs(D_REMOTE,cp,"\014");

  if(mode & D_LOCAL)
    local_cls(cp);
}




void _fastcall mpause (int mode,USHORT cp) {

    if(modems[cp]->curbaud && (mode & D_REMOTE))
      DosDevIOCtl(NULL,NULL,0x47,1,modems[cp]->mh);

    wait_inkey(mode,cp);

    if(time(NULL) > user[cp]->offline) {  /* Check timelimit timer */
      DosSemClear(&modems[cp]->bbsrunningSEM);
      _endthread();
    }

    if(modems[cp]->curbaud && (mode & D_REMOTE))
      DosDevIOCtl(NULL,NULL,0x48,1,modems[cp]->mh);
}





void _fastcall local_cls (USHORT cp) {

  dputs(D_LOCAL,cp,"\x1b[0m\x1b[2J");
}



void _fastcall quiet_bell (int mode,USHORT cp,int howmany) {

    if(modems[cp]->curbaud)
      while(howmany--) dputs(D_REMOTE,cp,"\07");
    else
      while(howmany--) dputs(mode,cp,"\07");
}



int _fastcall clear_toplines (int mode,USHORT cp,int howmany) {

    register int x;


    if(user[cp]->attribs & U_COLOR) {
      dputs(mode,cp,"\x1b[s");
      for(x = 0; x < howmany; x++)
        dprintf(mode,cp,"\x1b[%d;1H\x1b[K",x + 2);
      dputs(mode,cp,"\x1b[u");
      return x;
    }
    return 0;
}
