#define INCL_WIN

#include <sys/types.h>
#include <sys/stat.h>
#include <share.h>
#include <io.h>
#include <fcntl.h>
#include "mailer.h"
#include "xmisc.h"
#include "bbs.h"
#include "xbbs.h"

    extern ADDR *addresses;
    extern HWND xdhwnd;



MRESULT EXPENTRY GetFilesDlgBoxProc (HWND hwndDlg,USHORT msg,
                                     MPARAM mp1,MPARAM mp2) {

    static USHORT   fline = 65535,once = 0;
    static ADDR     faddr;
    static HPOINTER hwndIcon;


    switch(msg) {
        case WM_INITDLG:
            WinPostMsg(hwndDlg, WM_REFRESH, 0L, 0L);
            fline = SHORT1FROMMP(mp2);
            if(!once) {
                memset(&faddr,0,sizeof(ADDR));
                once++;
            }
            break;

        case WM_REFRESH:
            hwndIcon = (HPOINTER)WinQuerySysPointer(HWND_DESKTOP,SPTR_APPICON,0);
            WinDefDlgProc(hwndDlg, WM_SETICON, (MPARAM)hwndIcon, (MPARAM)0);
            WinSendDlgItemMsg(hwndDlg, GM_ADDR, EM_SETTEXTLIMIT,
                              MPFROM2SHORT(80,0), NULL);
            WinSendDlgItemMsg(hwndDlg, GM_FNAME, EM_SETTEXTLIMIT,
                              MPFROM2SHORT(255,0), NULL);
            WinSendDlgItemMsg(hwndDlg, GM_PASS, EM_SETTEXTLIMIT,
                              MPFROM2SHORT(8,0), NULL);
            WinSendDlgItemMsg(hwndDlg,GM_NORMAL,BM_SETCHECK,
                              MPFROM2SHORT(1,0),MPFROMLONG(0L));


            {
                char s[81];

                if(faddr.zone && *faddr.domain) {
                     sprintf(s,"%s#%u:%u/%u.%u",faddr.domain,faddr.zone,
                             faddr.net,faddr.node,faddr.point);
                }
                else {
                    *s = 0;
                }
                WinSetDlgItemText(hwndDlg,GM_ADDR,s);
            }
            return MRFROMSHORT(0);

        case WM_COMMAND:
            switch(SHORT1FROMMP(mp1)) {
                case GM_OK:
                    {
                        char       *p,s[256],*fname;
                        USHORT      rc,update = 0,ddate = 0,poll = 0;
                        struct stat st;
                        int         handle;

                        rc = WinQueryDlgItemText(hwndDlg, GM_ADDR, 80, s);
                        if (rc > 0) {
                            p = lstrip(rstrip(s));
                            if(parse_addr(&p,&faddr,addresses)) {
                                rc = WinQueryDlgItemText(hwndDlg, GM_ADDR, 80, s);
                                if(rc > 0) {
                                    if(!find_in_fidouser(0,(USHORT)-1,lstrip(rstrip(s)),&faddr)) {
                                        memset(&faddr,0,sizeof(ADDR));
                                        DosBeep(1000,10);
                                        break;
                                    }
                                }
                                else {
                                    memset(&faddr,0,sizeof(ADDR));
                                    DosBeep(1000,10);
                                    break;
                                }
                            }
                            if(faddr.zone && *faddr.domain) {
                                sprintf(s,"%s#%u:%u/%u.%u",faddr.domain,
                                        faddr.zone,faddr.net,
                                        faddr.node,faddr.point);
                                WinSetDlgItemText(hwndDlg,GM_ADDR,s);
                                rc = WinQueryDlgItemText(hwndDlg, GM_FNAME, 255, s);
                                if(rc > 0) {
                                    if(!(USHORT)WinSendDlgItemMsg(hwndDlg,
                                                GM_NORMAL,BM_QUERYCHECK,
                                                MPFROMLONG(0L),MPFROMLONG(0L))) {
                                        update = (USHORT)WinSendDlgItemMsg(hwndDlg,
                                                         GM_UPDATE,BM_QUERYCHECK,
                                                         MPFROMLONG(0L),MPFROMLONG(0L));
                                        if(update) {
                                            if(stat(s,&st)) {
                                                DosBeep(100,100);
                                                return MRFROMSHORT(1);
                                            }
                                        }
                                        else {
                                            ddate = (USHORT)WinSendDlgItemMsg(hwndDlg,
                                                            GM_DDATE,BM_QUERYCHECK,
                                                            MPFROMLONG(0L),MPFROMLONG(0L));
                                            if(ddate) {
                                                if(stat(s,&st)) {
                                                    DosBeep(100,100);
                                                    return MRFROMSHORT(1);
                                                }
                                            }
                                        }
                                    }

                                    poll = (USHORT)WinSendDlgItemMsg(hwndDlg,
                                                   GM_POLLTOO,BM_QUERYCHECK,
                                                   MPFROMLONG(0L),MPFROMLONG(0L));

                                    fname = malloc(1050);
                                    if(fname) {
                                      sprintf(fname,"%s/R.%u.%u.%u.%u.%s",
                                              d_outbound,
                                              faddr.zone,faddr.net,faddr.node,
                                              faddr.point,faddr.domain);
                                      handle = sopen(fname,O_RDWR | O_BINARY | O_CREAT,
                                                     SH_DENYWR,S_IWRITE | S_IREAD);
                                      free(fname);
                                    }
                                    else
                                      handle = -1;
                                    if(handle != -1) {
                                        lseek(handle,0L,SEEK_END);
                                        ffprintf(handle,"%s",s);
                                        rc = WinQueryDlgItemText(hwndDlg, GM_PASS, 8, s);
                                        if(rc > 0) {
                                            ffprintf(handle," !%s",s);
                                        }
                                        if(update) {
                                            ffprintf(handle," +%lu",st.st_mtime);
                                        }
                                        else if(ddate) {
                                            ffprintf(handle," -%lu",st.st_mtime);
                                        }
                                        ffprintf(handle,"\r\n");
                                        close(handle);
                                        if(poll) {
                                            fname = malloc(1050);
                                            if(fname) {
                                              sprintf(fname,"%s/C.%u.%u.%u.%u.%s",
                                                      d_outbound,
                                                      faddr.zone,faddr.net,faddr.node,
                                                      faddr.point,faddr.domain);
                                              handle = sopen(fname,O_RDWR | O_BINARY | O_CREAT,
                                                             SH_DENYNO,S_IWRITE | S_IREAD);
                                              free(fname);
                                            }
                                            else
                                              handle = -1;
                                            if(handle != -1) {
                                                close(handle);
                                            }
                                            else DosBeep(750,100);
                                        }
                                    }
                                    else {
                                        DosBeep(500,100);
                                    }
                                }
                            }
                        }
                        else {
                            DosBeep(250,100);
                        }
                    }
                    return MRFROMSHORT(1);

                case GM_CANCEL:
                    WinSetDlgItemText(hwndDlg,GM_FNAME,"");
                    WinSetDlgItemText(hwndDlg,GM_PASS,"");
                    WinSetDlgItemText(hwndDlg,GM_ADDR,"");
                    memset(&faddr,0,sizeof(ADDR));
                    WinDismissDlg(hwndDlg, 0);
                    break;

                case GM_QUIT:
                    WinDismissDlg(hwndDlg, 0);
                    break;

                default:
                    break;
            }

        case WM_CLOSE:
            WinDismissDlg(hwndDlg, 0);
            break;

        default:
            break;
    }

    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
