#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include "mailer.h"
#include "bbs.h"
#include "modem.h"
#include "bitfuncs.h"
#include "xmisc.h"

#pragma optimize("",off)

    extern MDM       *modems[MAXINSTANCES];
    extern USER      *user[MAXINSTANCES];
    extern MSGAREA   *msgareas;
    extern FILEAREA  *fileareas;
    extern BBS       *bbs;




void _fastcall adjust_fileareas (int mode,USHORT cp) {

    /* Set up file areas */
    /* NOTE:  user[cp]->bbsfile flags are used by system when determining if
       user has access to a given area.  user[cp]->userfile flags are used
       to save a "permanent" record of what the user's preferences are.
       bbs->bbsfile flags are used to determine what can be turned on. */

    #define NUMSELECTS 8

    char         prompt[54],color[13];
    static int   promptcolor = 5,cmdcolor = 13,normalcolor = 11;
    int          com,changed = 0;
    FILEAREA     *info;


    *prompt = 0;
    dputs(mode,cp,"\r\n");

    do {
        if(!clear_toplines(mode,cp,2)) dputs(mode,cp,"\r\n");
        com = pselect_one(mode,cp,225,NUMSELECTS,226,NULL,"Setup File",set_iflg(cp));
        com++;

        switch(com) {
            case 1: {   /* List areas */

                char *list[] = {"Current Areas","Off Areas","All Areas"};

                dputs(mode,cp,"\r\n");
                com = select_one(mode,cp,list,3,"List: ",NULL,"List FileAreas",set_iflg(cp));
                com++;
                switch(com) {
                    case 1:     /* Current Areas */
                        list_fileareas(mode,cp);
                        break;

                    case 2: {    /* Off Areas */
                                int    count = 0,lines = 0;

                                info = fileareas;
                                while(info) {
                                    if(!IsBit(user[cp]->bbsfile,info->number - 1)) {
                                        if(find_any_filearea(mode,cp,info->name)) {
                                            count++;
                                            lines++;
                                            dprintf(mode,cp,"\r\n%-5u %0.73s",info->number,info->name);
                                            if(info->descr) {
                                                dprintf(mode,cp,"\r\n %0.78s",info->descr);
                                                lines++;
                                            }
                                            info = info->next;
                                            if(info) {
                                                if(lines >= user[cp]->length - 2) {
                                                    dputs(mode,cp,"\r\n");
                                                    if(do_more(mode,cp)) break;
                                                    lines = 0;
                                                }
                                            }
                                        }
                                        else info = info->next;
                                    }
                                    else info = info->next;
                                    if(checkcarrier(cp)) break;
                                }
                            }
                            break;

                    case 0:
                    default:
                        break;
                }
                break;
            }

            case 2:     /* Inquire area */
                inquire_filearea(mode,cp);
                break;

            case 0:
            case NUMSELECTS:     /* Quit */
                if(changed) {
                    dputs(mode,cp,"\r\nYou have made changes to your file area setup which will not be\r\n");
                    dputs(mode,cp,"saved for your next call.  Choose the Permanent option if you need to.\r\n");
                    DosSleep(1500L);
                }
                com = 0;
                break;

            case 3:     /* Permanent */
                memcpy(user[cp]->userfile,user[cp]->bbsfile,64);
                dputs(mode,cp,"\r\nCurrent setup is now your \"permanent\" setup.\r\n");
                changed = 0;
                break;

            case 4:     /* Toggle Area */
                info = get_any_filearea(mode,cp);
                if(info) {
                    if(IsBit(user[cp]->bbsfile,info->number - 1)) {
                        BitOff(user[cp]->bbsfile,info->number - 1);
                        dputs(mode,cp,"\r\nArea turned Off\r\n");
                    }
                    else {
                        BitOn(user[cp]->bbsfile,info->number - 1);
                        dputs(mode,cp,"\r\nArea turned On\r\n");
                    }
                    changed = 1;
                }
                else {
                    dputs(mode,cp,"\r\nUnknown area\r\n");
                }
                break;

            case 6: {    /* All Areas */

                        char *list[] = {"All Areas On","Turn All Areas Off"};

                        dputs(mode,cp,"\r\n");
                        com = select_one(mode,cp,list,2,"All: ",NULL,"All FileAreas",set_iflg(cp));
                        com++;
                        switch(com) {
                            case 1:
                                memcpy(user[cp]->bbsfile,bbs->fileflags,64);
                                dputs(mode,cp,"\r\nAll accessible areas turned on\r\n");
                                changed = 1;
                                break;

                            case 2:
                                memset(user[cp]->bbsfile,0,64);
                                dputs(mode,cp,"\r\nAll areas turned Off\r\n");
                                changed = 1;
                                break;

                            default:
                                dputs(mode,cp,"\r\nNo change\r\n");
                                break;
                        }
                    }
                    break;

            case 7:     /* Prompt */
                info = next_file_area(fileareas,cp,0,0);
                while(info) {

                    char input[2];

                    dprintf(mode,cp,"\r\nArea #%u: %s",info->number,info->name);
                    strset(input,0);
                    input_string(mode,cp,input,1,1,
                                 "\r\n Leave area on? (Y/n/q) ",
                                 STRT_YNQ,STRF_UCASE | STRF_HOT,
                                 "FileSetup Prompted",NULL);
                    if(*input == 'N') {
                        BitOff(user[cp]->bbsfile,info->number - 1);
                        changed = 1;
                    }
                    else if(*input == 'Q') {
                        break;
                    }
                    info = next_file_area(info,cp,1,0);
                }
                dputs(mode,cp,"\r\n");
                break;

           case 5: {    /* Range */
                        char    input[49];
                        char *list[] = {"Areas On","Off","Toggle"};
                        FILEAREA *hi,*lo;

                        strset(input,0);
                        input_string(mode,cp,input,48,1,
                                     "\r\nLow area: ",
                                     STRT_ALL,STRF_NEAT,
                                     "FileSetup Lorange",NULL);
                        if(!*input) break;
                        lo = find_any_filearea(mode,cp,input);
                        if(!lo) break;
                        strset(input,0);
                        input_string(mode,cp,input,48,1,
                                     "\r\nLow area: ",
                                     STRT_ALL,STRF_NEAT,
                                     "FileSetup Hirange",NULL);
                        if(!*input) break;
                        hi = find_any_filearea(mode,cp,input);
                        if(!hi) break;

                        if(lo->number > hi->number) {
                            info = hi;
                            hi = lo;
                            lo = info;
                        }

                        dputs(mode,cp,"\r\n");
                        com = select_one(mode,cp,list,3,"Range: ",NULL,"FileSetup RangePick",set_iflg(cp));
                        com++;
                        switch(com) {
                            case 1: info = lo;
                                    while(info && info->number <= hi->number && info->number >= lo->number) {
                                        BitOn(user[cp]->bbsfile,info->number - 1);
                                        changed = 1;
                                        do {
                                            info = info->next;
                                        } while(info && !find_any_filearea(mode,cp,info->name));
                                    }

                            case 2: info = lo;
                                    while(info && info->number <= hi->number && info->number >= lo->number) {
                                        BitOff(user[cp]->bbsfile,info->number - 1);
                                        changed = 1;
                                        do {
                                            info = info->next;
                                        } while(info && !find_any_filearea(mode,cp,info->name));
                                    }

                            case 3: info = lo;
                                    while(info && info->number <= hi->number && info->number >= lo->number) {
                                        if(IsBit(user[cp]->bbsfile,info->number - 1)) {
                                            BitOff(user[cp]->bbsfile,info->number - 1);
                                        }
                                        else {
                                            BitOn(user[cp]->bbsfile,info->number - 1);
                                        }
                                        changed = 1;
                                        do {
                                            info = info->next;
                                        } while(info && !find_any_filearea(mode,cp,info->name));
                                    }

                            default: break;
                        }
                    }
                    break;

            default:  dputs(mode,cp,"\r\nNot yet implemented.\r\n");
                      DosSleep(2000L);
                      break;
        }

        dputs(mode,cp,"\r\n");

        if(user[cp]->offline < time(NULL) || checkcarrier(cp)) {
            break;
        }

    } while(com);
}





FILEAREA * _fastcall get_any_filearea (int mode,USHORT cp) {

    char temp[65];


    strset(temp,0);
    input_string(mode,cp,temp,64,1,
                 "\r\nFile area number or name\r\n: ",
                 STRT_ALL,STRF_NEAT,"FileArea Inquire",NULL);
    rstrip(temp);
    if(!*temp) {
        return NULL;
    }

    return find_any_filearea(mode,cp,temp);
}




FILEAREA * _fastcall find_any_filearea (int mode,USHORT cp,char *name) {

    FILEAREA      *info;
    unsigned int x;


    x = atoi(name);

    info = fileareas;
    while(info) {
        if(x == info->number || !stricmp(name,info->name)) {
            if(!IsBit(bbs->bbsfile,info->number - 1)) return NULL;
            if(info->r_security1 > user[cp]->security1) return NULL;
            if(info->r_security2 > user[cp]->security2) return NULL;
            if(info->r_flags1 & (~user[cp]->flags1)) return NULL;
            if(info->r_flags2 & (~user[cp]->flags2)) return NULL;
            if(info->age) {
                if(info->age < 0) {
                    if(user[cp]->age > abs(info->age)) return NULL;
                }
                else {
                    if(user[cp]->age < info->age) return NULL;
                }
            }
            if((info->areaflags & M_ANSI) && !(user[cp]->attribs & U_COLOR))
              return NULL;
            break;
        }
        info = info->next;
    }

    return info;
}




FILEAREA * _fastcall inquire_filearea (int mode,USHORT cp) {

    FILEAREA      *info;


    info = get_any_filearea(mode,cp);
    if(info) {
        dprintf(mode,cp,"\r\nArea #%u:  \"%s\"\r\n",info->number,info->name);
        if(info->descr) dprintf(mode,cp," %s\r\n",info->descr);
    }
    else {
        dprintf(mode,cp,"\r\nArea doesn't exist or no access.\r\n");
    }

    return info;
}

#pragma optimize("",on)

