#include <sys/types.h>
#include <sys/stat.h>
#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"
#include "xmsg.h"



    extern USER *user[MAXINSTANCES];



word _fastcall how_many_msgs (MSGAREA *info) {

    char fname[64];
    word nomess;
    struct stat st;


    if(!info) return 0;
    sprintf(fname,"MSG/XDATA.%03x",info->number);
    if(stat(fname,&st)) st.st_size = 0L;

    nomess = (word)(st.st_size / (long)sizeof(XMSG));
    return nomess;
}





int _fastcall kill_msg (USHORT cp,XMSG *msg,MSGAREA *info,
                        unsigned int messno) {

    /* Toggles deleted bit on message */

    if(msg->xflags & MSGDELETED) msg->xflags &= (~MSGDELETED);
    else msg->xflags |= MSGDELETED;
    if(put_mess(cp,msg,info->number,messno) != MSG_NOERR) {
        if(msg->xflags & MSGDELETED) msg->xflags &= (~MSGDELETED);
        else msg->xflags |= MSGDELETED;
    }
    return (msg->xflags & MSGDELETED);
}




int _fastcall copy_msg (USHORT cp,XMSG *msg,MSGAREA *from,MSGAREA *to,
                        unsigned int messno,int moving) {

    /* returns 0 (complete success) -1 (not copied/moved) -2 (copied/
       moved but reread of original header failed) or -3 (everything
       went to hell in a handbasket) */

    char *hold = NULL;
    int  err,err2;

    err = get_text(cp,&hold,msg,from->number,messno);
    if(err == MSG_NOERR) {
        err = post_message(cp,msg,&hold,to->number,0);
        err2 = get_mess (cp,msg,from->number,messno);
        if(err == MSG_NOERR) {
            if(err2 == MSG_NOERR && moving) {
                msg->fflags |= MSGDELETED;
                put_mess(cp,msg,from->number,messno);
            }
        }
    }

    if(hold)
      free(hold);

    if(err == MSG_NOERR && err2 == MSG_NOERR)
      return 0;
    else if(err != MSG_NOERR && err2 != MSG_NOERR)
      return -3;
    else if(err != MSG_NOERR)
      return -1;
    else if(err2 != MSG_NOERR)
      return -2;
  return -4;
}
