#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include "mailer.h"
#include "bbs.h"
#include "bitfuncs.h"
#include "xmisc.h"


    extern MDM       *modems[MAXINSTANCES];
    extern USER      *user[MAXINSTANCES];
    extern MSGAREA   *msgareas;
    extern FILEAREA  *fileareas;
    extern LIBAREA   *libareas;
    extern BBS       *bbs;





unsigned int _fastcall list_msgareas (int mode,USHORT cp) {

    MSGAREA      *info;
    unsigned int count = 0,nomess;
    int          lines = 0;


    dputs(mode,cp,"\r\n\r\n");

    info = next_msg_area(msgareas,cp,0);

    if(!info) {
        dputs(mode,cp,"No msg areas available.\r\n");
        return 0;
    }

    do {
        count++;
        lines++;
        nomess = how_many_msgs(info);
        dprintf(mode,cp,"%-5u %0.51s (%u msg%s)\r\n",info->number,info->name,
                nomess,&"s"[nomess == 1]);
        if(info->descr) {
            dprintf(mode,cp," %0.78s\r\n",info->descr);
            lines++;
        }
        info = next_msg_area(info,cp,1);
        if(info) {
            if(lines >= user[cp]->length - 2) {
                if(do_more(mode,cp)) break;
                lines = 0;
            }
        }
    } while(info);
    return count;
}





unsigned int _fastcall list_fileareas (int mode,USHORT cp) {

    FILEAREA     *info;
    unsigned int count = 0;
    int          lines = 0;


    if(mode) dputs(mode,cp,"\r\n\r\n");

    info = next_file_area(fileareas,cp,0,0);
    if(!info) {
        if(mode) dputs(mode,cp,"No file areas available.\r\n");
        return 0;
    }

    do {
        count++;
        lines++;
        if(mode) dprintf(mode,cp,"%-5u %0.73s\r\n",info->number,info->name);
        if(info->descr) {
            dprintf(mode,cp," %0.78s\r\n",info->descr);
            lines++;
        }
        info = next_file_area(info,cp,1,0);
        if(info) {
            if(lines >= user[cp]->length - 2) {
                if(do_more(mode,cp)) break;
                lines = 0;
            }
        }
    } while(info);
    return count;
}





unsigned int _fastcall list_libareas (int mode,USHORT cp) {

    LIBAREA      *info;
    unsigned int count = 0;
    int          lines = 0;


    dputs(mode,cp,"\r\n\r\n");

    info = next_lib_area(libareas,cp,0);

    if(!info) {
        dputs(mode,cp,"No library sections available.\r\n");
        return 0;
    }

    do {
        count++;
        lines++;
        dprintf(mode,cp,"%-5u %0.58s\r\n",info->number,info->name);
        if(info->descr) {
            dprintf(mode,cp," %0.78s\r\n",info->descr);
            lines++;
        }
        info = next_lib_area(info,cp,1);
        if(info) {
            if(lines >= user[cp]->length - 2) {
                if(do_more(mode,cp)) break;
                lines = 0;
            }
        }
    } while(info);
    return count;
}





unsigned int _fastcall select_msg_area (int mode,USHORT cp) {

    MSGAREA *info = NULL;
    char    temp[65];


    if(!msgareas) {
        dputs(mode,cp,"\r\nNo message areas available!\r\n");
        return 0;
    }

Again:

    strset(temp,0);
    input_string(mode,cp,temp,64,1,
                 "\r\nMessage area number or name\r\n(? for list): ",
                 STRT_ALL,STRF_NEAT,"MsgArea Selection",NULL);
    if(user[cp]->offline < time(NULL)) {
        return 0;
    }
    rstrip(temp);
    if(!*temp) return 0;

    if(*temp == '?' && temp[1] == 0) {
        list_msgareas(mode,cp);
        dputs(mode,cp,"\r\n");
        goto Again;
    }
    else if(*temp == '<' && temp[1] == 0) {
        info = next_msg_area(user[cp]->currmsgarea,cp,-1);
    }
    else if(*temp == '>' && temp[1] == 0) {
        info = next_msg_area(user[cp]->currmsgarea,cp,1);
    }
    else if(*temp == '0' && temp[1] == 0) {
        info = next_msg_area(msgareas,cp,0);
    }

    if(!info && atoi(temp)) {
        info = find_msg_area(NULL,cp,(unsigned int)atoi(temp));
    }
    if(!info) {
        info = find_msg_area(temp,cp,0);
    }

    if(!info) {
        dprintf(mode,cp,"\r\nCan't find msg area \"%s\"\r\n",temp);
        return 0;
    }
    else {
        if(info->password && *info->password) {
            strset(temp,0);
            if(stricmp(info->password,get_password(mode,cp,temp))) {
                if(!*temp) goto Again;
                if(user[cp]->badattempts == bbs->maxattempts) {
                    user[cp]->badattempts++;
                    dputs(mode,cp,"\r\nOne more bad password attempt and you're history.\r\n");
                }
                else if(user[cp]->badattempts > bbs->maxattempts) {
                    logfunc(0,cp,"Too many bad passwords");
                    dputs(mode,cp,"\r\nToo many bad passwords.\r\n");
                    DosSemClear(&modems[cp]->bbsrunningSEM);
                    _endthread();
                }
                else {
                    dputs(mode,cp,"\r\nBad password...noted.\r\n");
                    user[cp]->badattempts++;
                }
                return 0;
            }
        }
        if(info->number > 0 && info->number < 513)
          user[cp]->currmsgarea = info;
    }

    if(user[cp]->currmsgarea)
      user[cp]->lastmsgarea = user[cp]->currmsgarea->number;

    return user[cp]->currmsgarea->number;
}






unsigned int _fastcall select_file_area (int mode,USHORT cp) {

    FILEAREA *info = NULL;
    char     temp[65];


    if(!fileareas) {
        dputs(mode,cp,"\r\nNo file areas available!\r\n");
        return 0;
    }

Again:

    strset(temp,0);
    input_string(mode,cp,temp,64,1,
                 "\r\nFile area number or name\r\n(? for list): ",
                 STRT_ALL,STRF_NEAT,"FileArea Selection",NULL);
    if(user[cp]->offline < time(NULL)) {
        return 0;
    }
    rstrip(temp);
    if(!*temp) return 0;

    if(*temp == '?'&& temp[1] == 0) {
        list_fileareas(mode,cp);
        dputs(mode,cp,"\r\n");
        goto Again;
    }
    else if(*temp == '<' && temp[1] == 0) {
        info = next_file_area(user[cp]->currfilearea,cp,-1,0);
    }
    else if(*temp == '>' && temp[1] == 0) {
        info = next_file_area(user[cp]->currfilearea,cp,1,0);
    }
    else if(*temp == '0' && temp[1] == 0) {
        info = next_file_area(fileareas,cp,0,0);
    }

    if(!info && atoi(temp)) {
        info = find_file_area(NULL,cp,(unsigned int)atoi(temp),0);
    }
    if(!info) info = find_file_area(temp,cp,0,0);

    if(!info) {
        dprintf(mode,cp,"\r\nCan't find file area \"%s\"\r\n",temp);
        return 0;
    }
    else {
        if(info->password && *info->password) {
            strset(temp,0);
            if(stricmp(info->password,get_password(mode,cp,temp))) {
                if(!*temp) goto Again;
                if(user[cp]->badattempts == bbs->maxattempts) {
                    user[cp]->badattempts++;
                    dputs(mode,cp,"\r\nOne more bad password attempt and you're history.\r\n");
                }
                else if(user[cp]->badattempts > bbs->maxattempts) {
                    dputs(mode,cp,"\r\nToo many bad passwords.\r\n");
                    DosSemClear(&modems[cp]->bbsrunningSEM);
                    _endthread();
                }
                else {
                    dputs(mode,cp,"\r\nBad password...noted.\r\n");
                    user[cp]->badattempts++;
                }
                return 0;
            }
        }
        user[cp]->currfilearea = info;
    }

    if(user[cp]->currfilearea)
      user[cp]->lastfilearea = user[cp]->currfilearea->number;

    return user[cp]->currfilearea->number;
}



unsigned int _fastcall select_lib_area (int mode,USHORT cp) {

    LIBAREA *info = NULL;
    char    temp[65];


    if(!libareas) {
        dputs(mode,cp,"\r\nNo library sections available!\r\n");
        return 0;
    }

Again:

    *temp = 0;
    input_string(mode,cp,temp,64,1,
                 "\r\nLibrary section number or name\r\n(? for list): ",
                 STRT_ALL,STRF_NEAT,"LibArea Selection",NULL);
    if(user[cp]->offline < time(NULL)) {
        return 0;
    }
    rstrip(temp);
    if(!*temp) return 0;

    if(*temp == '?' && temp[1] == 0) {
        list_libareas(mode,cp);
        dputs(mode,cp,"\r\n");
        goto Again;
    }
    else if(*temp == '<' && temp[1] == 0) {
        info = next_lib_area(user[cp]->currlibarea,cp,-1);
    }
    else if(*temp == '>' && temp[1] == 0) {
        info = next_lib_area(user[cp]->currlibarea,cp,1);
    }
    else if(*temp == 0 && temp[1] == 0) {
        info = next_lib_area(libareas,cp,0);
    }

    if(!info && atoi(temp)) {
        info = find_lib_area(NULL,cp,(unsigned int)atoi(temp));
    }
    if(!info) {
        info = find_lib_area(temp,cp,0);
    }

    if(!info) {
        dprintf(mode,cp,"\r\nCan't find library section \"%s\"\r\n",temp);
        return 0;
    }
    else {
        if(info->password && *info->password) {
            strset(temp,0);
            if(stricmp(info->password,get_password(mode,cp,temp))) {
                if(!*temp) goto Again;
                if(user[cp]->badattempts == bbs->maxattempts) {
                    user[cp]->badattempts++;
                    dputs(mode,cp,"\r\nOne more bad password attempt and you're history.\r\n");
                }
                else if(user[cp]->badattempts > bbs->maxattempts) {
                    dputs(mode,cp,"\r\nToo many bad passwords.\r\n");
                    DosSemClear(&modems[cp]->bbsrunningSEM);
                    _endthread();
                }
                else {
                    dputs(mode,cp,"\r\nBad password...noted.\r\n");
                    user[cp]->badattempts++;
                }
                return 0;
            }
        }
        if(info->number > 0 && info->number < 513)
          user[cp]->currlibarea = info;
    }

    return user[cp]->currlibarea->number;
}






#ifdef DEBUG

void _fastcall dump_msgareas (int mode,USHORT cp) {

    MSGAREA *info;


    info = msgareas;

    while(info) {
        dprintf(mode,cp,"%u: %s\r\n",info->number,info->name);
        info = info->next;
    }
}

#endif




char * _fastcall get_password (int mode,USHORT cp,char *buffer) {

    *buffer = 0;
    return input_string(mode,cp,buffer,59,3,"\r\nArea Password: ",
                        STRT_ALL,STRF_ENCRYPT,
                        "Area Password",NULL);
}
