/* Does 'threading', finds personal msgs, etc. very fast */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <io.h>
#include <share.h>
#include <errno.h>
#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"
#include "xmsg.h"
#include "keys.h"
#include "modem.h"

    extern MDM  *modems[MAXINSTANCES];
    extern USER *user[MAXINSTANCES];

    #define ARRAYDEPTH 10


unsigned int _fastcall thread (int mode,USHORT cp,int which,
                               unsigned int messno,char *body,
                               XMSG *msg,MSGAREA *info) {

 /*
  * performs threading forward or backward in an area.
  * if which == 'B' threads backward, else threads forward.
  * is smart enough to reverse at end/beginning of message.
  * if body contains anything, it's used (MSGID/REPLY),
  * else the msg->subj is matched.
  * returns matching message # or 0 on no-match
  */

    register char *p;
    unsigned int nomess;
    int          direction;
    XMSG         msg2;
    char         *subj[ARRAYDEPTH],*text[ARRAYDEPTH];

    nomess = how_many_msgs(info);
    if (nomess <= 1)
      return 0;
    if (messno >= nomess)
      which = 'B';
    if (messno <= 1)
      which = 'F';
    if (which != 'B' && which != 'F')
      which = 'F';
    if(which == 'B')
      direction = (-1);
    else
      direction = 1;

    memset(text,0,sizeof(char *) * ARRAYDEPTH);
    memset(subj,0,sizeof(char *) * ARRAYDEPTH);

    if(!body || !*body) {
      p = msg->subj;
      lstrip(p);
      rstrip(p);
      while(!strnicmp(p,"RE:",3)) {
        p += 3;
        while(*p == ' ')
          p++;
      }
      subj[0] = p;
    }
    else
      text[0] = body;

    for(;;) {
      messno = superthread(mode,cp,NULL,NULL,subj,
                           ((direction < 0) ? NULL:text),
                           ((direction < 0) ? text:NULL),
                           NULL,direction,0,info,messno);
      if(!messno)
        break;
      if(get_messu(cp,&msg2,info->number,messno,user[cp]) != MSG_NOERR) {
        messno += direction;
        continue;
      }
      else
        break;
    }

    return messno;
}


/* look for match using hash tables (body & reverse direction
 * cause jump to normalthread())
 */

unsigned int _fastcall superthread (int mode,USHORT cp, char **from, char **to,
                                    char **subj, char **msgid,char **reply,
                                    char **body,int direction,int flags,
                                    MSGAREA *curr,unsigned int startat) {

  /* bitmapped flags:
   * 1: don't match to unless MSGREAD bit is NOT set
   * 2: must match all of one set
   */

  register INDEXES *idx;
  register int     cntr;
  USHORT      numrecs,numtoread = 0,numalloc = 1000,numread = 0,match = 0;
  int         handle,status,x,fromc[ARRAYDEPTH],toc[ARRAYDEPTH],
              subjc[ARRAYDEPTH];
  char        filename[81],*p,*pp;
  struct stat st;
  long        mc[ARRAYDEPTH],ms[ARRAYDEPTH],rc[ARRAYDEPTH],rs[ARRAYDEPTH];
  XMSG        msg;

// remove when debugged
return normalthread(mode,cp,from,to,subj,msgid,reply,body,direction,
                    flags,curr,startat);

// remove when written to work in reverse, too
if(direction < 0)
  return normalthread(mode,cp,from,to,subj,msgid,reply,body,direction,
                      flags,curr,startat);

// remove when body checks built in
for(cntr = 0;cntr < ARRAYDEPTH;cntr++) {
  if(body && body[cntr] && *body[cntr]) {
    return normalthread(mode,cp,from,to,subj,msgid,reply,body,direction,
                        flags,curr,startat);
  }
}

  sprintf(filename,"MSG/XIDX.%03x",curr->number);  /* open idx file, calc offsets */
  if(stat(filename,&st))
    return 0;
  numrecs = (USHORT)(st.st_size / (long)sizeof(INDEXES));
  if(!numrecs)
    return 0;
  numtoread = numrecs - startat;
  if(!numtoread)
    return 0;
  if(numtoread < numalloc)
    numalloc = numtoread;
  idx = malloc(sizeof(INDEXES) * numalloc);
  if(!idx)
    return 0;
  handle = sopen(filename,O_RDONLY | O_BINARY,SH_DENYNO);
  if(handle == -1) {
    free(idx);
    return 0;
  }
  lseek(handle,(long)sizeof(INDEXES) * ((long)startat - 1L),SEEK_SET);

  for(cntr = 0;cntr < ARRAYDEPTH;cntr++) {
    if(from && from[cntr] && *from[cntr])
      fromc[cntr] = csum16str(from[cntr]);
    if(to && to[cntr] && *to[cntr])
      toc[cntr] = csum16str(to[cntr]);
    if(subj && subj[cntr] && *subj[cntr])
      subjc[cntr] = csum16str(subj[cntr]);
    if(msgid && msgid[cntr] && *msgid[cntr]) {
      p = msgid[cntr];
      pp = NULL;
      while(*p && *p != ' ')
        p++;
      if(*p) {
        pp = p;
        *p = ' ';
        p++;
      }
      mc[cntr] = crc32str(msgid[cntr]);
      if(pp) {
        p = pp;
        ms[cntr] = strtol(pp,&p,16);
      }
    }
    if(reply && reply[cntr] && *reply[cntr]) {
      p = reply[cntr];
      pp = NULL;
      while(*p && *p != ' ')
        p++;
      if(*p) {
        pp = p;
        *p = ' ';
        p++;
      }
      rc[cntr] = crc32str(reply[cntr]);
      if(pp) {
        p = pp;
        rs[cntr] = strtol(pp,&p,16);
      }
    }
  }

  while(numread < numtoread) {        /* look for hashes in idx */
    status = read(handle,idx,sizeof(INDEXES) * numalloc);
    if(status == -1 || !status)
      break;
    numtoread -= (status / sizeof(INDEXES));
    for(x = 0;x < (status / sizeof(INDEXES));x++) {
      for(cntr = 0;cntr < ARRAYDEPTH;cntr++) {  /* check rest in array loop */
        if(from && from[cntr] && *from[cntr]) {
          if(fromc[cntr] == idx[x].from) {
            if(get_messu(cp,&msg,curr->number,startat + x,user[cp]) == MSG_NOERR &&
               !stricmp(msg.from,from[cntr])) {
              match = startat + x;
              break;
            }
          }
        }
        if(to && to[cntr] && *to[cntr]) {
          if(toc[cntr] == idx[x].to) {
            if(get_messu(cp,&msg,curr->number,startat + x,user[cp]) == MSG_NOERR &&
               !stricmp(msg.to,to[cntr]) && (!(flags & 1) ||
               !(msg.xflags & MSGREAD))) {
              match = startat + x;
              break;
            }
          }
        }
        if(subj && subj[cntr] && *subj[cntr]) {
          if(subjc[cntr] == idx[x].subj) {
            if(get_messu(cp,&msg,curr->number,startat + x,user[cp]) == MSG_NOERR &&
               !stricmp(msg.subj,subj[cntr])) {
              match = startat + x;
              break;
            }
          }
        }
        if(msgid && mc[cntr] && ms[cntr]) {
          if(mc[cntr] == idx[x].msgidcrc && ms[cntr] == idx[x].msgidserialno) {
            match = startat + x;
            break;
          }
        }
        if(reply && rc[cntr] && rs[cntr]) {
          if(rc[cntr] == idx[x].replycrc && rs[cntr] == idx[x].replyserialno) {
            match = startat + x;
            break;
          }
        }
      }
      if(match)
        break;
    }
    startat += (status / sizeof(INDEXES));
  }

  close(handle);
  free(idx);
  return match;
}


#define BUFMSGS 200


unsigned int _fastcall normalthread (int mode,USHORT cp, char **from, char **to,
                                     char **subj, char **msgid,char **reply,
                                     char **body,int direction,int flags,
                                     MSGAREA *curr,unsigned int messno) {

  /* bitmapped flags:
   * 1 = don't match to unless MSGREAD flag is NOT set
   * 2 = must match all of one set
   */

  register unsigned int x = 0,cntr;
  USHORT                temp;
  XMSG                  *msgs = NULL;
  char                  filename[81];
  int                   handle,handle2 = -1,y,keyhit,gotbody = 0,
                        bc = 3,reduced,realbody = 0,match,hifrom = 0,hito = 0,
                        hisubj = 0,hibody = 0,himsgid = 0,hireply = 0;
  USHORT                handstate;
  char                  finished = 0,*buffer = NULL,busy[4] = "/-|\\";

  sprintf(filename,"MSG\\XDATA.%03x",curr->number);
  handle = bbs_sopen(cp,filename,O_RDONLY | O_BINARY, SH_DENYNO);
  if(handle == -1) {
    return 0;
  }

  if(direction < 0) {
    DosQFHandState(handle,&handstate);
    if((handstate & (1 << 12)))
      DosSetFHandState(handle,handstate & ~(1 << 12));
    if(messno > BUFMSGS - 1){
      x = BUFMSGS;
      messno -= BUFMSGS;
    }
    else {
      x = messno - 1;
      messno = 1;
    }
  }
  else {
    DosQFHandState(handle,&handstate);
    if(!(handstate & (1 << 12)))
      DosSetFHandState(handle,handstate | (1 << 12));
  }

  for(cntr = 0;cntr < ARRAYDEPTH;cntr++) {  /* any need to check text? */
    if(body && body[cntr] && *body[cntr]) { /* and what's the highest in each? */
      gotbody++;
      realbody++;
      if(!cntr || body[cntr - 1])
        hibody = cntr + 1;
    }
    if(msgid && msgid[cntr] && *msgid[cntr]) {
      gotbody++;
      if(!cntr || msgid[cntr - 1])
        himsgid = cntr + 1;
    }
    if(reply && reply[cntr] && *reply[cntr]) {
      gotbody++;
      if(!cntr || reply[cntr - 1])
        hireply = cntr + 1;
    }
    if(from && from[cntr] && *from[cntr]) {
      if(!cntr || from[cntr - 1])
        hifrom = cntr + 1;
    }
    if(to && to[cntr] && *to[cntr]) {
      if(!cntr || to[cntr - 1])
        hito = cntr + 1;
    }
    if(subj && subj[cntr] && *subj[cntr]) {
      if(!cntr || subj[cntr - 1])
        hisubj = cntr + 1;
    }
  }

  if(gotbody) {
    sprintf(filename,"MSG\\XTEXT.%03x",curr->number);
    handle2 = bbs_sopen(cp,filename,O_RDONLY | O_BINARY, SH_DENYNO);
    if(handle2 == -1)
      goto Abort;

    DosQFHandState(handle2,&handstate);
    if((handstate & (1 << 12)))
      DosSetFHandState(handle2,handstate & ~(1 << 12));
  }

  msgs = bbs_malloc(cp,sizeof(XMSG) * BUFMSGS);
  if(!msgs) {
    goto Abort;
  }
  buffer = bbs_malloc(cp,65201U);
  if(!buffer) {
    goto Abort;
  }

  for(;;) {
    memset(msgs,0,sizeof(XMSG) * BUFMSGS);

    keyhit = inkey(mode,cp);  /* check for abort */
    if(keyhit == (int)modems[cp]->STOP)
      goto Abort;

    if(direction > 0) {   /* find next message to start at */
      x = (unsigned int)(filelength(handle) / (long)sizeof(XMSG));
      if(messno > x || finished)
        goto Abort;
      if((x - messno) < BUFMSGS - 1)
        x -= (messno - 1);
      else
        x = BUFMSGS;
    }

    /* load a block of headers */

    if(lseek(handle,((long)messno - 1L) *           /* seek error */
       (long)sizeof(XMSG),SEEK_SET) == -1) {
      goto Abort;
    }

    if(DosRead(handle,msgs,(x * sizeof(XMSG)),&temp) || temp < 1) { /* read err */
      goto Abort;
    }

    if((temp / sizeof(XMSG)) < x)
      x = temp / sizeof(XMSG);
    if(direction < 0)
      y = x - 1;
    else
      y = 0;


    if(!busy[++bc])
      bc = 0;
    dputc(mode,cp,busy[bc]);
    dputc(mode,cp,'\b');

    for(;;) {
      /* can we "see" this message at all? */
      if((msgs[y].xflags & MSGDELETED) && msg_sysop_ok(user[cp],curr))
        goto NoGot;
      if(msgs[y].fflags & MSGPRIVATE) {
        if(mymsg(user[cp],&msgs[y]) && msg_sysop_ok(user[cp],curr))
          goto NoGot;
      }
      /* yes; does it match any of our criterion? */
      for(cntr = 0;cntr < ARRAYDEPTH;cntr++) {
        match = 0;
        if(cntr < hifrom && from[cntr] && *from[cntr]) {
          if(!stricmp(msgs[y].from,from[cntr])) {
            if(!(flags & 2)) {
              messno += y;
              goto FoundIt;
            }
            else
              match++;
          }
          else if(flags & 2)
            continue;
        }

        if(cntr < hito && to[cntr] && *to[cntr]) {
          if(!(flags & 1) || !(msgs[y].fflags & MSGREAD)) {
            if(!stricmp(msgs[y].to,to[cntr])) {
              if(!(flags & 2)) {
                messno += y;
                goto FoundIt;
              }
              else
                match++;
            }
            else if(flags & 2)
              continue;
          }
        }

        if(cntr < hisubj && subj[cntr] && *subj[cntr]) {
          if(stristr(msgs[y].subj,subj[cntr])) {
            if(!(flags & 2)) {
              messno += y;
              goto FoundIt;
            }
            else
              match++;
          }
          else if(flags & 2)
            continue;
        }

      /* not in the header... */
      if(gotbody) {       /* now check text */
        if(!msgs[y].length)
          goto NoGot;      /* no text, no need to check it */
        if(cntr == 0) {
            if(realbody) {
              if(msgs[y].length > 65200U) {
                msgs[y].length = 65200U;
                reduced = 1;
              }
              else
                reduced = 0;
            }
            else {                        /* just threading */
              if(msgs[y].length > 1024)
                msgs[y].length = 1024;
              reduced = 1;
            }
            if(lseek(handle2,msgs[y].start,SEEK_SET) == -1L) /* seek error */
              goto NoGot;
            *buffer = 0;
            if(!DosRead(handle2,buffer,msgs[y].length,&temp)) {
              buffer[temp + 1] = 0;
              if(realbody && (msgs[y].xflags & MSGPACKED) && !reduced) { /* handle compressed text */

                char *hold;

                hold = strdup(buffer);
                if(hold) {
                  if(unpack_msg(cp,&msgs[y],&hold) != NULL && hold)
                    strcpy(buffer,hold);
                  if(hold)
                    bbs_free(cp,hold);
                }
              }
            }
          }
          if(cntr < hibody && body[cntr] && *body[cntr]) {
            if(stristr(buffer,body[cntr])) {
              if(!(flags & 2)) {
                messno += y;
                goto FoundIt;
              }
              else
                match++;
            }
            else if(flags & 2)
              continue;
          }

          if(cntr < himsgid && msgid[cntr] && *msgid[cntr]) {
            if(stristr(buffer,msgid[cntr])) {
              if(!(flags & 2)) {
                messno += y;
                goto FoundIt;
              }
              else
                match++;
            }
            else if(flags & 2)
              continue;
          }

          if(cntr < hireply && reply[cntr] && *reply[cntr]) {
            if(stristr(buffer,reply[cntr])) {
              if(!(flags & 2)) {
                messno += y;
                goto FoundIt;
              }
              else
                match++;
            }
            else if(flags & 2)
              continue;
          }
        }

        if((flags & 2) && match) {   /* if we get here, everything matched */
          messno += y;
          goto FoundIt;
        }
      }

      /* no luck; we aren't interested in that message */

NoGot:

      /* move along in our buffered headers;
       * loop to load next batch if exhausted
       */

      y += (direction);
      if(direction < 0) {
        if(y < 0)
          break;
      }
      else if(y >= (int)x)
        break;
    }

    if(direction > 0) {
      if((long)messno + (long)x > 65535L)
        finished = 1;
      else
        messno += x;
    }
    else {
      if(messno == 1)
        goto Abort;
      else {
        if(messno <= x)
          messno = 1;
        else
          messno -= x;
      }
    }
  }

FoundIt:    /* exit point on success */

  if(handle2 != -1)
    bbs_close(cp,handle2);
  bbs_close(cp,handle);
  if(msgs)
    bbs_free(cp,msgs);
  if(buffer)
    bbs_free(cp,buffer);
  if(busy[bc])
    dprintf(mode,cp," \b");
  return messno;      /* the message we found that matched something */

Abort:      /* exit point on failure */

  if(handle2 != -1)
    bbs_close(cp,handle2);
  bbs_close(cp,handle);
  if(msgs)
    bbs_free(cp,msgs);
  if(buffer)
    bbs_free(cp,buffer);
  if(busy[bc])
    dprintf(mode,cp," \b");
  return 0;           /* no-match flag */
}

