#include <io.h>
#include <share.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include "mailer.h"
#include "bbs.h"
#include "bitfuncs.h"
#include "xmisc.h"


    FILEAREA       *fileareas = NULL;
    FILEAREA       *fileareatail = NULL;




int _fastcall load_fileareas (void) {

    int  handle;
    char ln[1024];
    char *p,*pp;
    int  temp;
    FILEAREA *info;


    handle = sopen(searchpath("FILEAREA.BB2",ln,511),O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYNO);
    if(handle == -1) {
        return 0;
    }

    while(!eof(handle)) {
        if(!fgetsx(ln,1024,handle)) break;
        lstrip(ln);
        if(*ln == ';') continue;
        stripcr(ln);
        rstrip(ln);
        if(!*ln || *ln == '\x1a') continue;

        info = (FILEAREA *)malloc(sizeof(FILEAREA));
        if(!info) {
            return -1;
        }

        memset(info,0,sizeof(FILEAREA));

        p = ln;
        pp = to_delim(p,",");
        if(!*p) {
            info->name = NULL;
            goto BadArea;
        }
        *pp = 0;
        info->name = strdup(ln);
        if(!info->name) {
            return -1;
        }

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->age = atoi(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->r_security1 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->r_security2 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->r_flags1 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->r_flags2 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->w_security1 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->w_security2 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->w_flags1 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->w_flags2 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->s_security1 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->s_security2 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->s_flags1 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->s_flags2 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->cost_per_k = atoi(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->areaflags = (unsigned int)atoi(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->number = (unsigned int)atoi(p);

        if(!info->number || info->number > 512) {

BadArea:

            if(info->name) free(info->name);
            free(info);
            continue;
        }

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        temp = strlen(p);
        if(p[temp - 1] == '\\' || p[temp - 1] == '/') p[temp - 1] = 0;
        info->upath = strdup(p);
        if(!info->upath) {
            logfmain("Allocation for upload path, filearea %s, failed.",info->name);
            free(info->name);
            free(info);
            continue;
        }

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        temp = strlen(p);
        if(p[temp - 1] == '\\' || p[temp - 1] == '/') p[temp - 1] = 0;
        info->dpath = strdup(p);
        if(!info->dpath) {
            logfmain("Allocation for download path, filearea %s, failed.",info->name);
            free(info->upath);
            free(info->name);
            free(info);
            continue;
        }

        pp++;
        if(*pp) {
          p = pp;
          pp = to_delim(p,",");
          *pp = 0;
          if(!*p) info->descr = NULL;
          else {
            if(strlen(p) > 77) p[77] = 0;
            info->descr = strdup(p);
          }
          pp++;
          if(*pp) {
            p = pp;
            pp = to_delim(p,",");
            if(*pp) {
                *pp = 0;
                if(!*p) info->password = NULL;
                else {
                    *pp = 0;
                    info->password = strdup(p);
                    if(!info->password) {
                        logfmain("Allocation for password, filearea %s, failed.",info->name);
                        logfmain("Removing area from memory for security.");
                        if(info->descr) free(info->descr);
                        free(info->dpath);
                        free(info->upath);
                        free(info->name);
                        free(info);
                        continue;
                    }
                }
            }
          }
        }

        if(!fileareas) {
            fileareas = info;
            fileareatail = info;
            info->prior = NULL;
        }
        else {
            fileareatail->next = info;
            info->prior = fileareatail;
            fileareatail = info;
        }
        info->next = NULL;
    }

    close(handle);
    return 0;
}
