#define INCL_DOS

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <os2.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <io.h>
#include <share.h>
#include <ctype.h>

#define TEXTLEN 289

char * _fastcall fgetsx (char *str,unsigned int num,unsigned int handle) {

    char         *p;
    long         pos;
    unsigned int x;


    if (eof(handle)) {
        *str = 0;
        return NULL;
    }
    DosChgFilePtr(handle,0L,1,&pos);
    if(DosRead(handle,str,num - 1,&x) || x < 1) {
        *str = 0;
        return NULL;
    }
    str[x] = 0;
    p = str;
    while(*p && *p != '\r' && *p != '\n') p++;
    if(!*p) return str;
    if(*p == '\r') {
        if (p[1] == '\n') {
            p++;
        }
    }
    p++;
    *p = 0;
    DosChgFilePtr(handle,pos + (long)((int)p - (int)str),0,&pos);
    return str;
}


int main (int argc,char *argv[]) {

    /* index fidouser.lst, standalone, for nodelist processing batch files */

    struct _fuseridx {
      char firstchar;
      long pos;
    }            fux;
    int          f,fx;
    unsigned int cntr;
    long         low,high,mid;
    struct stat  buf;
    char         lastchar = 0,s[290];

    if(argc > 1 && (argv[1][0] == '?' || argv[1][1] == '?')) {
      printf("\n\nUsage: INDEXUSR\n"
             "\nIndexes FIDOUSER.LST (to FIDOUSER.IDX) for use with XBBS-OS/2\n"
             "and HeadEdit OS/2.  Better to use a v7 nodelist.\n"
             "FIDOUSER.LST must be in the default directory.\n");
      return 0;
    }

    if(stat("FIDOUSER.LST",&buf)) {
      printf("\nCan't find FIDOUSER.LST\n");
      return 1;
    }

    f = sopen("FIDOUSER.LST",O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYNO); /* open it */
    if(f == -1) {
      printf("\nCan't open FIDOUSER.LST\n");
      return 2;
    }

    fx = sopen("FIDOUSER.IDX",O_NOINHERIT | O_RDWR | O_BINARY,SH_DENYWR);
    if(fx == -1)
      fx = sopen("FIDOUSER.IDX",O_CREAT | O_RDWR | O_BINARY | O_NOINHERIT,SH_DENYWR,S_IWRITE | S_IREAD);
    else {
      read(fx,&mid,sizeof(long));
      read(fx,&high,sizeof(long));
      if(mid == buf.st_size && high == buf.st_mtime) {
        printf("\nNo need to reindex.\n");
        return 0;
      }
    }

    printf("\nIndexing FIDOUSER.LST...\n");
    DosNewSize(fx,0L);
    lseek(fx,(long)sizeof(long) * 2L,SEEK_SET);
    cntr = 0;
    while(!eof(f)) {
        low = tell(f);
        if(!fgetsx(s,TEXTLEN + 1,f)) break;
        if(*s != ' ') {
            if(toupper(*s) != (int)lastchar) {
                lastchar = (char)toupper(*s);
                fux.firstchar = lastchar;
                fux.pos = low;
                write(fx,&fux,sizeof(struct _fuseridx));
            }
        }
        cntr++;
        if(!(cntr % 500)) {
            printf("\r%-5u",cntr);
            DosSleep(1L);
        }
    }
    lseek(fx,0L,SEEK_SET);
    write(fx,&buf.st_size,sizeof(long));
    write(fx,&buf.st_mtime,sizeof(long));
    printf("\nComplete.\n");

    return 0;
}

